/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import org.scribble.model.ParameterDecl;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.RoleDecl;
import org.scribble.model.Visitor;
import org.scribble.model.global.GBlock;
import org.scribble.model.global.GVisitor;

public class GProtocolDefinition
extends ProtocolDecl {
    private GBlock _block = null;

    public GBlock getBlock() {
        if (this._block == null) {
            this._block = new GBlock();
            this._block.setParent(this);
        }
        return this._block;
    }

    public void setBlock(GBlock block) {
        if (this._block != null) {
            this._block.setParent(null);
        }
        this._block = block;
        if (this._block != null) {
            this._block.setParent(this);
        }
    }

    public void visit(Visitor visitor) {
        if (visitor instanceof GVisitor) {
            if (((GVisitor)visitor).start(this) && this.getBlock() != null) {
                this.getBlock().visit(visitor);
            }
            ((GVisitor)visitor).end(this);
        }
    }

    public String toString() {
        int i;
        String ret = "global protocol " + this.getName();
        if (this.getParameterDeclarations().size() > 0) {
            ret = ret + " <";
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                ParameterDecl pd = this.getParameterDeclarations().get(i);
                if (i > 0) {
                    ret = ret + ",";
                }
                ret = ret + pd.getType().name().toLowerCase() + " " + pd.getName();
                if (pd.getAlias() == null) continue;
                ret = ret + " as " + pd.getAlias();
            }
            ret = ret + ">";
        }
        ret = ret + " ( ";
        for (i = 0; i < this.getRoleDeclarations().size(); ++i) {
            RoleDecl role = this.getRoleDeclarations().get(i);
            if (i > 0) {
                ret = ret + ",";
            }
            ret = ret + "role " + role.getName() + " ";
            if (role.getAlias() == null) continue;
            ret = ret + " as " + role.getAlias();
        }
        ret = ret + ")\n";
        ret = ret + this.getBlock();
        return ret;
    }

    public void toText(StringBuffer buf, int level) {
        int i;
        GProtocolDefinition.indent(buf, level);
        buf.append("global protocol ");
        buf.append(this.getName());
        if (this.getParameterDeclarations().size() > 0) {
            buf.append("<");
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                this.getParameterDeclarations().get(i).toText(buf, level);
            }
            buf.append(">");
        }
        buf.append("(");
        for (i = 0; i < this.getRoleDeclarations().size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("role ");
            this.getRoleDeclarations().get(i).toText(buf, level);
        }
        buf.append(") ");
        if (this._block != null) {
            this._block.toText(buf, level);
        }
        buf.append("\n");
    }
}

