/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.scribble.model.Message;
import org.scribble.model.Role;
import org.scribble.model.RoleDecl;
import org.scribble.model.global.GActivity;
import org.scribble.model.global.GVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMessageTransfer
extends GActivity {
    private Message _message = null;
    private Role _fromRole = null;
    private List<Role> _toRoles = new ArrayList<Role>();

    public GMessageTransfer() {
    }

    public GMessageTransfer(GMessageTransfer i) {
        super(i);
        if (i._message != null) {
            this._message = new Message(i._message);
        }
        this._fromRole = i._fromRole;
        for (Role r : i._toRoles) {
            this._toRoles.add(new Role(r));
        }
    }

    public GMessageTransfer(Message sig, Role fromRole, List<Role> toRoles) {
        this._message = sig;
        this._fromRole = fromRole;
        this._toRoles = toRoles;
    }

    @Override
    public boolean isRoleInvolved(RoleDecl role) {
        boolean ret = false;
        if (this._fromRole != null) {
            ret = role.isRole(this._fromRole);
        }
        for (int i = 0; !ret && i < this._toRoles.size(); ++i) {
            ret = role.isRole(this._toRoles.get(i));
        }
        return ret;
    }

    @Override
    public void identifyInvolvedRoles(Set<Role> roles) {
        if (this._fromRole != null) {
            roles.add(this._fromRole);
        }
        roles.addAll(this._toRoles);
    }

    public Message getMessage() {
        return this._message;
    }

    public void setMessage(Message message) {
        if (this._message != null) {
            this._message.setParent(null);
        }
        this._message = message;
        if (this._message != null) {
            this._message.setParent(this);
        }
    }

    public Role getFromRole() {
        return this._fromRole;
    }

    public void setFromRole(Role part) {
        this._fromRole = part;
    }

    public List<Role> getToRoles() {
        return this._toRoles;
    }

    public void setToRoles(List<Role> part) {
        this._toRoles = part;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.getMessage() != null) {
            ret.append(this.getMessage());
            ret.append(" ");
        }
        ret.append(this.getFromRole());
        ret.append("->");
        for (int i = 0; i < this.getToRoles().size(); ++i) {
            if (i > 0) {
                ret.append(",");
            }
            ret.append(this.getToRoles().get(i));
        }
        return ret.toString();
    }

    @Override
    public void visit(GVisitor visitor) {
        visitor.accept(this);
        if (this.getMessage() != null) {
            this.getMessage().visit(visitor);
        }
    }

    public boolean equals(Object o) {
        boolean ret;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GMessageTransfer that = (GMessageTransfer)o;
        boolean bl = !(this._fromRole == null ? that._fromRole != null : !this._fromRole.equals(that._fromRole)) && !(this._message == null ? that._message != null : !this._message.equals(that._message)) ? true : (ret = false);
        if (ret) {
            if (this._toRoles.size() != that.getToRoles().size()) {
                return false;
            }
            for (int i = 0; i < this._toRoles.size(); ++i) {
                Role r = this._toRoles.get(i);
                if (r.equals(that.getToRoles().get(i))) continue;
                return false;
            }
        }
        return ret;
    }

    public int hashCode() {
        int result = this._message != null ? this._message.hashCode() : 0;
        result = 31 * result + (this._fromRole != null ? this._fromRole.hashCode() : 0);
        return result;
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        GMessageTransfer.indent(buf, level);
        this._message.toText(buf, level);
        if (this._fromRole != null) {
            buf.append(" from ");
            this._fromRole.toText(buf, level);
        }
        if (this._toRoles != null) {
            buf.append(" to ");
            for (int i = 0; i < this.getToRoles().size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                this._toRoles.get(i).toText(buf, level);
            }
        }
        buf.append(";\n");
    }
}

