/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model;

import java.util.List;
import org.scribble.model.ContainmentList;
import org.scribble.model.ModelObject;
import org.scribble.model.PayloadElement;
import org.scribble.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSignature
extends ModelObject {
    private String _operator = null;
    private List<PayloadElement> _types = new ContainmentList<PayloadElement>(this, PayloadElement.class);

    public MessageSignature() {
    }

    public MessageSignature(String operator, List<PayloadElement> types) {
        this._operator = operator;
        this._types.addAll(types);
    }

    public MessageSignature(MessageSignature msig) {
        super(msig);
        this._operator = msig.getOperator();
        for (PayloadElement tref : msig.getPayloadElements()) {
            this._types.add(new PayloadElement(tref));
        }
    }

    public String getOperator() {
        return this._operator;
    }

    public void setOperator(String operator) {
        this._operator = operator;
    }

    public List<PayloadElement> getPayloadElements() {
        return this._types;
    }

    public int hashCode() {
        int result = 13;
        result = 31 * result + this._types.hashCode();
        result = 31 * result + (this._operator == null ? 0 : this._operator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        MessageSignature other;
        boolean ret = false;
        if (obj instanceof MessageSignature && (other = (MessageSignature)obj).getPayloadElements().size() == this.getPayloadElements().size()) {
            if (other._operator != null && this._operator != null) {
                ret = other._operator.equals(this._operator);
            } else if (other._operator == null && this._operator == null) {
                ret = true;
            }
            for (int i = 0; ret && i < this.getPayloadElements().size(); ++i) {
                ret = this.getPayloadElements().get(i).equals(other.getPayloadElements().get(i));
            }
        }
        return ret;
    }

    public String toString() {
        String ret = "";
        ret = ret + this.getOperator() + "(";
        for (int i = 0; i < this._types.size(); ++i) {
            if (i > 0) {
                ret = ret + ",";
            }
            ret = ret + this._types.get(i).getName();
        }
        if ((ret = ret + ")").equals("")) {
            ret = "<No Signature>";
        }
        return ret;
    }

    @Override
    public void visit(Visitor visitor) {
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        buf.append(this._operator);
        buf.append('(');
        for (int i = 0; i < this.getPayloadElements().size(); ++i) {
            if (i > 0) {
                buf.append(',');
            }
            this.getPayloadElements().get(i).toText(buf, level);
        }
        buf.append(')');
    }
}

