/*
 * Copyright 2009 www.scribble.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.scribble.model;

/**
 * This interface provides the definitions for the properties
 * associated with objects in the model.
 */
public interface ModelProperties {

    /**
     * This construct defines the start location in a textual description of
     * a scribble construct.
     */
    public static final String START_LOCATION="scribble.start.location";
    
    /**
     * This construct defines the end location in a textual description of
     * a scribble construct.
     */
    public static final String END_LOCATION="scribble.end.location";

    /**
     * This construct defines the URI for locating the source component.
     */
    public static final String URI="scribble.uri";

}
