/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.local;

import org.scribble.model.RoleDecl;
import org.scribble.model.Visitor;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LProtocolDecl;
import org.scribble.model.local.LVisitor;

public class LProtocolDefinition
extends LProtocolDecl {
    private LBlock _block = null;

    public LBlock getBlock() {
        if (this._block == null) {
            this._block = new LBlock();
            this._block.setParent(this);
        }
        return this._block;
    }

    public void setBlock(LBlock block) {
        if (this._block != null) {
            this._block.setParent(null);
        }
        this._block = block;
        if (this._block != null) {
            this._block.setParent(this);
        }
    }

    public void visit(Visitor visitor) {
        if (visitor instanceof LVisitor) {
            if (((LVisitor)visitor).start(this) && this.getBlock() != null) {
                this.getBlock().visit(visitor);
            }
            ((LVisitor)visitor).end(this);
        }
    }

    public String toString() {
        String ret = "local protocol " + this.getName() + " ( ";
        for (RoleDecl role : this.getRoleDeclarations()) {
            ret = ret + "role " + role.getName() + " ";
        }
        ret = ret + ")\n";
        ret = ret + this.getBlock();
        return ret;
    }

    public void toText(StringBuffer buf, int level) {
        int i;
        LProtocolDefinition.indent(buf, level);
        buf.append("local protocol ");
        buf.append(this.getName());
        buf.append(" at ");
        if (this.getLocalRole() != null) {
            this.getLocalRole().toText(buf, level);
        }
        if (this.getParameterDeclarations().size() > 0) {
            buf.append("<");
            for (i = 0; i < this.getParameterDeclarations().size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                this.getParameterDeclarations().get(i).toText(buf, level);
            }
            buf.append(">");
        }
        buf.append("(");
        for (i = 0; i < this.getRoleDeclarations().size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("role ");
            this.getRoleDeclarations().get(i).toText(buf, level);
        }
        buf.append(") ");
        if (this._block != null) {
            this._block.toText(buf, level);
        }
        buf.append("\n");
    }
}

