/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.local;

import java.util.List;
import org.scribble.model.ContainmentList;
import org.scribble.model.local.LActivity;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LParallel
extends LActivity {
    private List<LBlock> _blocks = new ContainmentList<LBlock>(this, LBlock.class);

    public List<LBlock> getPaths() {
        return this._blocks;
    }

    @Override
    public void visit(LVisitor visitor) {
        if (visitor.start(this)) {
            for (LBlock b : this.getPaths()) {
                b.visit(visitor);
            }
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LParallel that = (LParallel)o;
        return this._blocks.equals(that._blocks);
    }

    public int hashCode() {
        int result = this._blocks.hashCode();
        return result;
    }

    public String toString() {
        String result = "parallel ";
        for (LBlock b : this._blocks) {
            if (this._blocks.indexOf(b) > 0) {
                result = result + "and ";
            }
            result = result + b + "\n";
        }
        return result;
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        LParallel.indent(buf, level);
        buf.append("par ");
        for (int i = 0; i < this.getPaths().size(); ++i) {
            if (i > 0) {
                buf.append(" and ");
            }
            this.getPaths().get(i).toText(buf, level);
        }
        buf.append("\n");
    }
}

