/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.local;

import java.util.List;
import org.scribble.model.Argument;
import org.scribble.model.ContainmentList;
import org.scribble.model.FullyQualifiedName;
import org.scribble.model.RoleInstantiation;
import org.scribble.model.local.LActivity;
import org.scribble.model.local.LVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDo
extends LActivity {
    private FullyQualifiedName _protocol = null;
    private String _scope = null;
    private List<Argument> _arguments = new ContainmentList<Argument>(this, Argument.class);
    private List<RoleInstantiation> _roleInstantiations = new ContainmentList<RoleInstantiation>(this, RoleInstantiation.class);

    public LDo() {
    }

    public LDo(LDo copy) {
        super(copy);
        this._protocol = copy.getProtocol();
        for (Argument arg : copy.getArguments()) {
            this._arguments.add(new Argument(arg));
        }
        for (RoleInstantiation ri : copy.getRoleInstantiations()) {
            this._roleInstantiations.add(new RoleInstantiation(ri));
        }
    }

    public FullyQualifiedName getProtocol() {
        return this._protocol;
    }

    public void setProtocol(FullyQualifiedName protocol) {
        this._protocol = protocol;
    }

    public String getScope() {
        return this._scope;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public List<Argument> getArguments() {
        return this._arguments;
    }

    public List<RoleInstantiation> getRoleInstantiations() {
        return this._roleInstantiations;
    }

    @Override
    public void visit(LVisitor visitor) {
        visitor.accept(this);
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        int i;
        LDo.indent(buf, level);
        buf.append("do ");
        if (this._scope != null) {
            buf.append(this._scope);
            buf.append(": ");
        }
        this._protocol.toText(buf, level);
        if (this._arguments.size() > 0) {
            buf.append('<');
            for (i = 0; i < this._arguments.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this._arguments.get(i));
            }
            buf.append(">");
        }
        buf.append("(");
        for (i = 0; i < this._roleInstantiations.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            this._roleInstantiations.get(i).toText(buf, level);
        }
        buf.append(");\n");
    }
}

