/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.local;

import java.util.List;
import org.scribble.model.ContainmentList;
import org.scribble.model.Role;
import org.scribble.model.local.LActivity;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LChoice
extends LActivity {
    private Role _role = null;
    private List<LBlock> _blocks = new ContainmentList<LBlock>(this, LBlock.class);

    public Role getRole() {
        return this._role;
    }

    public void setRole(Role role) {
        this._role = role;
    }

    public List<LBlock> getPaths() {
        return this._blocks;
    }

    @Override
    public void visit(LVisitor visitor) {
        if (visitor.start(this)) {
            for (LBlock b : this.getPaths()) {
                b.visit(visitor);
            }
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LChoice that = (LChoice)o;
        return !(this._role == null ? that._role != null : !this._role.equals(that._role)) && this._blocks.equals(that._blocks);
    }

    public int hashCode() {
        int result = this._blocks.hashCode();
        result = 31 * result + (this._role != null ? this._role.hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "choice ";
        if (this._role != null) {
            result = result + "at " + this._role + " ";
        }
        for (LBlock b : this._blocks) {
            if (this._blocks.indexOf(b) > 0) {
                result = result + "or ";
            }
            result = result + b + "\n";
        }
        return result;
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        LChoice.indent(buf, level);
        buf.append("choice at ");
        if (this._role != null) {
            buf.append(this._role);
            buf.append(" ");
        }
        for (int i = 0; i < this.getPaths().size(); ++i) {
            if (i > 0) {
                buf.append(" or ");
            }
            this.getPaths().get(i).toText(buf, level);
        }
        buf.append("\n");
    }
}

