/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model.global;

import java.util.List;
import java.util.Set;
import org.scribble.model.Argument;
import org.scribble.model.ContainmentList;
import org.scribble.model.FullyQualifiedName;
import org.scribble.model.Role;
import org.scribble.model.RoleDecl;
import org.scribble.model.RoleInstantiation;
import org.scribble.model.global.GActivity;
import org.scribble.model.global.GVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDo
extends GActivity {
    private FullyQualifiedName _protocol = null;
    private String _scopeName = null;
    private List<Argument> _arguments = new ContainmentList<Argument>(this, Argument.class);
    private List<RoleInstantiation> _roleInstantiations = new ContainmentList<RoleInstantiation>(this, RoleInstantiation.class);

    public GDo() {
    }

    public GDo(GDo copy) {
        super(copy);
        this._protocol = copy.getProtocol();
        for (Argument arg : copy.getArguments()) {
            this._arguments.add(new Argument(arg));
        }
        for (RoleInstantiation ri : copy.getRoleInstantiations()) {
            this._roleInstantiations.add(new RoleInstantiation(ri));
        }
    }

    @Override
    public boolean isRoleInvolved(RoleDecl role) {
        boolean ret = false;
        for (int i = 0; !ret && i < this._roleInstantiations.size(); ++i) {
            RoleInstantiation ri = this._roleInstantiations.get(i);
            ret = role.isRole(new Role(ri.getName()));
        }
        return ret;
    }

    @Override
    public void identifyInvolvedRoles(Set<Role> roles) {
        for (int i = 0; i < this._roleInstantiations.size(); ++i) {
            RoleInstantiation ri = this._roleInstantiations.get(i);
            roles.add(new Role(ri.getName()));
        }
    }

    public FullyQualifiedName getProtocol() {
        return this._protocol;
    }

    public void setProtocol(FullyQualifiedName protocol) {
        this._protocol = protocol;
    }

    public String getScope() {
        return this._scopeName;
    }

    public void setScope(String scope) {
        this._scopeName = scope;
    }

    public List<Argument> getArguments() {
        return this._arguments;
    }

    public List<RoleInstantiation> getRoleInstantiations() {
        return this._roleInstantiations;
    }

    @Override
    public void visit(GVisitor visitor) {
        visitor.accept(this);
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        int i;
        GDo.indent(buf, level);
        buf.append("do ");
        if (this._scopeName != null) {
            buf.append(this._scopeName);
            buf.append(": ");
        }
        this._protocol.toText(buf, level);
        if (this._arguments.size() > 0) {
            buf.append('<');
            for (i = 0; i < this._arguments.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this._arguments.get(i));
            }
            buf.append(">");
        }
        buf.append("(");
        for (i = 0; i < this._roleInstantiations.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            this._roleInstantiations.get(i).toText(buf, level);
        }
        buf.append(");\n");
    }
}

