/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model;

import java.util.List;
import org.scribble.model.ContainmentList;
import org.scribble.model.FullyQualifiedName;
import org.scribble.model.ImportDecl;
import org.scribble.model.ModelObject;
import org.scribble.model.PayloadTypeDecl;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
extends ModelObject {
    private FullyQualifiedName _fqn = null;
    private List<ImportDecl> _imports = new ContainmentList<ImportDecl>(this, ImportDecl.class);
    private List<PayloadTypeDecl> _payloadTypes = new ContainmentList<PayloadTypeDecl>(this, PayloadTypeDecl.class);
    private List<ProtocolDecl> _protocols = new ContainmentList<ProtocolDecl>(this, ProtocolDecl.class);

    public FullyQualifiedName getFullyQualifiedName() {
        return this._fqn;
    }

    public void setFullyQualifiedName(FullyQualifiedName fqn) {
        this._fqn = fqn;
    }

    public List<ImportDecl> getImports() {
        return this._imports;
    }

    public List<PayloadTypeDecl> getPayloadTypeDeclarations() {
        return this._payloadTypes;
    }

    public PayloadTypeDecl getTypeDeclaration(String name) {
        for (PayloadTypeDecl ptd : this._payloadTypes) {
            if (ptd.getAlias() == null || !ptd.getAlias().equals(name)) continue;
            return ptd;
        }
        return null;
    }

    public List<ProtocolDecl> getProtocols() {
        return this._protocols;
    }

    public ProtocolDecl getProtocol(String name) {
        for (ProtocolDecl p : this._protocols) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void visit(Visitor visitor) {
        for (ImportDecl imp : this.getImports()) {
            imp.visit(visitor);
        }
        for (PayloadTypeDecl ptd : this.getPayloadTypeDeclarations()) {
            ptd.visit(visitor);
        }
        for (ProtocolDecl protocol : this.getProtocols()) {
            protocol.visit(visitor);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toText(buf, 0);
        return buf.toString();
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        if (this._fqn != null) {
            Module.indent(buf, level);
            buf.append("module ");
            this._fqn.toText(buf, level);
            buf.append(";\n\n");
        }
        for (ImportDecl imp : this.getImports()) {
            imp.toText(buf, level);
        }
        if (this.getImports().size() > 0) {
            buf.append("\n");
        }
        for (PayloadTypeDecl ptd : this.getPayloadTypeDeclarations()) {
            ptd.toText(buf, level);
        }
        if (this.getPayloadTypeDeclarations().size() > 0) {
            buf.append("\n");
        }
        for (int i = 0; i < this.getProtocols().size(); ++i) {
            ProtocolDecl protocol = this.getProtocols().get(i);
            if (i > 0) {
                buf.append("\n");
            }
            protocol.toText(buf, level);
        }
    }
}

