/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.model;

import org.scribble.model.FullyQualifiedName;
import org.scribble.model.ModelObject;
import org.scribble.model.Visitor;

public class ImportDecl
extends ModelObject {
    private FullyQualifiedName _moduleName = null;
    private String _memberName = null;
    private String _alias = null;

    public ImportDecl() {
    }

    public ImportDecl(ImportDecl copy) {
        super(copy);
        this._moduleName = copy.getModuleName();
        this._memberName = copy.getMemberName();
        this._alias = copy.getAlias();
    }

    public FullyQualifiedName getModuleName() {
        return this._moduleName;
    }

    public void setModuleName(FullyQualifiedName module) {
        this._moduleName = module;
    }

    public String getMemberName() {
        return this._memberName;
    }

    public void setMemberName(String name) {
        this._memberName = name;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public String getDeclarationName() {
        String ret = null;
        ret = this.getAlias() != null ? this.getAlias() : (this.getMemberName() != null ? this.getModuleName().toString() + "." + this.getMemberName() : this.getModuleName().toString());
        return ret;
    }

    public void visit(Visitor visitor) {
        visitor.accept(this);
    }

    public String toString() {
        String ret = this.getMemberName();
        if (ret == null) {
            ret = "<Module Not Set>";
        }
        return ret;
    }

    public void toText(StringBuffer buf, int level) {
        ImportDecl.indent(buf, level);
        if (this._memberName != null) {
            buf.append("from ");
        } else {
            buf.append("import ");
        }
        buf.append(this._moduleName);
        if (this._memberName != null) {
            buf.append(" import ");
            buf.append(this._memberName);
        }
        if (this._alias != null) {
            buf.append(" as ");
            buf.append(this._alias);
        }
        buf.append(";\n");
    }
}

