/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.HashMap;
import java.util.Map;
import org.scribble.protocol.model.Module;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelObject {
    public static final String START_LINE = "start.line";
    public static final String START_COLUMN = "start.column";
    public static final String END_LINE = "end.line";
    public static final String END_COLUMN = "end.column";
    public static final String START_POSITION = "position.start";
    public static final String END_POSITION = "position.end";
    public static final String RESOURCE_URL = "resource.url";
    private ModelObject _parent = null;
    private Map<String, Object> _properties = new HashMap<String, Object>();

    public ModelObject() {
    }

    public ModelObject(ModelObject obj) {
        this._properties.putAll(obj.getProperties());
    }

    public ModelObject getParent() {
        return this._parent;
    }

    public void setParent(ModelObject parent) {
        this._parent = parent;
    }

    public void derivedFrom(ModelObject modelObj) {
        if (modelObj != null) {
            this._properties = new HashMap<String, Object>(modelObj.getProperties());
        }
    }

    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public Module getModule() {
        Module ret = null;
        ModelObject cur = this;
        while (ret == null && cur != null) {
            if (cur instanceof Module) {
                ret = (Module)cur;
                continue;
            }
            cur = cur.getParent();
        }
        return ret;
    }

    public abstract void visit(Visitor var1);

    public abstract void toText(StringBuffer var1, int var2);

    protected void indent(StringBuffer buf, int level) {
        for (int i = 0; i < level; ++i) {
            buf.append('\t');
        }
    }
}

