/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.util;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActivityUtil {
    private ActivityUtil() {
    }

    public static boolean isDeclaration(Activity act) {
        boolean ret = false;
        if (act instanceof Introduces) {
            ret = true;
        }
        return ret;
    }

    public static boolean isBehaviour(Activity act) {
        return !ActivityUtil.isDeclaration(act);
    }

    public static Block getEnclosingBlock(List<Block> blockList) {
        Block ret = null;
        if (blockList.size() == 1) {
            ret = blockList.get(0);
        } else if (blockList.size() > 1) {
            Vector<List<Block>> listOfBlocks = new Vector<List<Block>>();
            for (Block block : blockList) {
                List<Block> lb = ActivityUtil.getBlockPath(block);
                if (lb == null || lb.size() <= 0) continue;
                listOfBlocks.add(lb);
            }
            int pos = -1;
            List refblocks = (List)listOfBlocks.get(0);
            for (int j = 0; j < refblocks.size(); ++j) {
                boolean same = true;
                Block ref = (Block)refblocks.get(j);
                for (int i = 1; same && i < listOfBlocks.size(); ++i) {
                    List lb = (List)listOfBlocks.get(i);
                    if (lb.size() > j && ref == lb.get(j)) continue;
                    same = false;
                }
                if (!same) continue;
                pos = j;
            }
            if (pos != -1) {
                ret = (Block)refblocks.get(pos);
            }
        }
        return ret;
    }

    protected static List<Block> getBlockPath(Block b) {
        Vector<Block> ret = new Vector<Block>();
        ModelObject cur = b;
        while (cur instanceof Block) {
            ret.add(0, (Block)cur);
            while ((cur = cur.getParent()) != null && !(cur instanceof Block)) {
            }
        }
        return ret;
    }
}

