/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Choice
extends Activity {
    private Role _role = null;
    private List<Block> _blocks = new ContainmentList<Block>(this, Block.class);

    public Role getRole() {
        return this._role;
    }

    public void setRole(Role part) {
        this._role = part;
    }

    public List<Block> getPaths() {
        return this._blocks;
    }

    @Override
    public void visit(Visitor visitor) {
        if (visitor.start(this)) {
            for (Block b : this.getPaths()) {
                b.visit(visitor);
            }
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Choice that = (Choice)o;
        return !(this._role == null ? that._role != null : !this._role.equals(that._role)) && ((Object)this._blocks).equals(that._blocks);
    }

    public int hashCode() {
        int result = ((Object)this._blocks).hashCode();
        result = 31 * result + (this._role != null ? this._role.hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "choice ";
        if (this._role != null) {
            result = result + "at " + this._role + " ";
        }
        for (Block b : this._blocks) {
            if (this._blocks.indexOf(b) > 0) {
                result = result + "or ";
            }
            result = result + b + "\n";
        }
        return result;
    }
}

