/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation;

import java.util.ArrayList;
import java.util.List;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.AbstractModelObjectVisitor;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;
import org.scribble.protocol.validation.ProtocolValidator;
import org.scribble.protocol.validation.ProtocolValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolComponentValidator
implements ProtocolValidator {
    private List<ProtocolComponentValidatorRule> _rules = null;

    public List<ProtocolComponentValidatorRule> getRules() {
        if (this._rules == null) {
            this._rules = new ArrayList<ProtocolComponentValidatorRule>();
        }
        return this._rules;
    }

    public void setRules(List<ProtocolComponentValidatorRule> rules) {
        this._rules = rules;
    }

    @Override
    public void validate(ProtocolValidatorContext pvc, ProtocolModel model, Journal journal) {
        ValidatingVisitor vv = new ValidatingVisitor(pvc, journal);
        model.visit(vv);
        vv.process(model);
    }

    public class ValidatingVisitor
    extends AbstractModelObjectVisitor {
        private ProtocolValidatorContext _pvc = null;
        private Journal _logger = null;

        public ValidatingVisitor(ProtocolValidatorContext pvc, Journal logger) {
            this._pvc = pvc;
            this._logger = logger;
        }

        public boolean process(ModelObject obj) {
            for (ProtocolComponentValidatorRule rule : ProtocolComponentValidator.this.getRules()) {
                if (!rule.isSupported(obj)) continue;
                rule.validate(this._pvc, obj, this._logger);
            }
            return true;
        }
    }
}

