/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.DirectedChoice;
import org.scribble.protocol.model.Do;
import org.scribble.protocol.model.End;
import org.scribble.protocol.model.Inline;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Interrupt;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.OnMessage;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Parameter;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.RecBlock;
import org.scribble.protocol.model.Recursion;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.Unordered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoleUtil {
    private RoleUtil() {
    }

    public static Set<Role> getDeclaredRoles(Block block) {
        final HashSet<Role> roles = new HashSet<Role>();
        block.visit(new DefaultVisitor(){

            protected void addRole(Role r) {
                if (r != null && !roles.contains(r)) {
                    roles.add(r);
                }
            }

            public void accept(Introduces elem) {
                for (Role r : elem.getIntroducedRoles()) {
                    this.addRole(r);
                }
            }

            public boolean start(Protocol elem) {
                return false;
            }
        });
        return roles;
    }

    public static Protocol getEnclosingProtocol(Role role) {
        Protocol ret = null;
        if (role.getParent() instanceof Introduces) {
            ret = ((Introduces)role.getParent()).getEnclosingProtocol();
        } else if (role.getParent() instanceof ParameterDefinition && role.getParent().getParent() instanceof Protocol) {
            ret = (Protocol)role.getParent().getParent();
        }
        return ret;
    }

    public static Set<Role> getUsedRoles(final ModelObject act) {
        final HashSet<Role> roles = new HashSet<Role>();
        act.visit(new DefaultVisitor(){

            protected void addRole(Role r) {
                if (r != null && !roles.contains(r)) {
                    roles.add(r);
                }
            }

            public void accept(Interaction elem) {
                this.addRole(elem.getFromRole());
                for (Role r : elem.getToRoles()) {
                    this.addRole(r);
                }
            }

            public void accept(Inline elem) {
                Set<Role> inscope = RoleUtil.getRolesInScope(elem);
                block0: for (Parameter p : elem.getParameters()) {
                    for (Role r : inscope) {
                        if (!r.getName().equals(p.getName())) continue;
                        this.addRole(r);
                        continue block0;
                    }
                }
            }

            public void accept(Run elem) {
                Set<Role> inscope = RoleUtil.getRolesInScope(elem);
                block0: for (Parameter p : elem.getParameters()) {
                    for (Role r : inscope) {
                        if (!r.getName().equals(p.getName())) continue;
                        this.addRole(r);
                        continue block0;
                    }
                }
            }

            public boolean start(Choice elem) {
                this.addRole(elem.getRole());
                return true;
            }

            public boolean start(DirectedChoice elem) {
                this.addRole(elem.getFromRole());
                for (Role r : elem.getToRoles()) {
                    this.addRole(r);
                }
                return true;
            }

            public boolean start(Protocol elem) {
                return elem == act;
            }
        });
        return roles;
    }

    public static Set<Role> getRolesInScope(Activity activity) {
        Protocol protocol;
        HashSet<Role> ret = new HashSet<Role>();
        if (activity != null && (protocol = activity.getEnclosingProtocol()) != null) {
            RoleLocator visitor = new RoleLocator(protocol, activity, ret);
            protocol.visit(visitor);
        }
        return ret;
    }

    public static Block getEnclosingBlock(final Protocol protocol, final Role role) {
        Block ret = null;
        final Vector blocks = new Vector();
        protocol.visit(new DefaultVisitor(){

            public boolean start(Protocol elem) {
                if (protocol == elem && protocol.getParameterDefinition(role.getName()) != null) {
                    blocks.add(elem.getBlock());
                }
                return protocol == elem;
            }

            public void accept(Interaction elem) {
                if (role.equals(elem.getFromRole()) || elem.getToRoles().contains(role) || (elem.getFromRole() == null || elem.getToRoles().size() == 0) && role.equals(elem.getEnclosingProtocol().getLocatedRole())) {
                    blocks.add((Block)elem.getParent());
                }
            }

            public boolean start(Choice elem) {
                if (role.equals(elem.getRole())) {
                    blocks.add((Block)elem.getParent());
                }
                return true;
            }

            public boolean start(DirectedChoice elem) {
                if (role.equals(elem.getFromRole()) || elem.getToRoles().contains(role) || (elem.getFromRole() == null || elem.getToRoles().size() == 0) && role.equals(elem.getEnclosingProtocol().getLocatedRole())) {
                    blocks.add((Block)elem.getParent());
                }
                return true;
            }

            public void accept(Introduces elem) {
                if (elem.getIntroducedRoles().contains(role)) {
                    blocks.add((Block)elem.getParent());
                }
            }
        });
        if (blocks.size() == 1) {
            ret = (Block)blocks.get(0);
        } else if (blocks.size() > 1) {
            Vector<List<Block>> listOfBlocks = new Vector<List<Block>>();
            for (Block block : blocks) {
                List<Block> lb = RoleUtil.getBlockPath(block);
                if (lb == null || lb.size() <= 0) continue;
                listOfBlocks.add(lb);
            }
            int pos = -1;
            List refblocks = (List)listOfBlocks.get(0);
            for (int j = 0; j < refblocks.size(); ++j) {
                boolean same = true;
                Block ref = (Block)refblocks.get(j);
                for (int i = 1; same && i < listOfBlocks.size(); ++i) {
                    List lb = (List)listOfBlocks.get(i);
                    if (lb.size() > j && ref == lb.get(j)) continue;
                    same = false;
                }
                if (!same) continue;
                pos = j;
            }
            if (pos != -1) {
                ret = (Block)refblocks.get(pos);
            }
        }
        return ret;
    }

    protected static List<Block> getBlockPath(Block b) {
        Vector<Block> ret = new Vector<Block>();
        ModelObject cur = b;
        while (cur instanceof Block) {
            ret.add(0, (Block)cur);
            while ((cur = cur.getParent()) != null && !(cur instanceof Block)) {
            }
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoleLocator
    extends DefaultVisitor {
        private boolean _recurse = true;
        private Protocol _protocol = null;
        private Activity _activity = null;
        private Set<Role> _result = null;
        private List<List<Role>> _roleStack = new Vector<List<Role>>();

        public RoleLocator(Protocol protocol, Activity activity, Set<Role> result) {
            this._protocol = protocol;
            this._activity = activity;
            this._result = result;
        }

        @Override
        public boolean start(Block elem) {
            return this.startBlock(elem);
        }

        protected boolean startBlock(Block elem) {
            this._roleStack.add(new Vector());
            return true;
        }

        @Override
        public void end(Block elem) {
            this.endBlock(elem);
        }

        protected void endBlock(Block elem) {
            this._roleStack.remove(this._roleStack.size() - 1);
        }

        @Override
        public boolean start(Choice elem) {
            this.checkActivity(elem);
            return this._recurse;
        }

        @Override
        public boolean start(DirectedChoice elem) {
            this.checkActivity(elem);
            return this._recurse;
        }

        @Override
        public boolean start(OnMessage elem) {
            return this._recurse;
        }

        @Override
        public boolean start(Unordered elem) {
            this.checkActivity(elem);
            return this._recurse;
        }

        @Override
        public boolean start(Parallel elem) {
            this.checkActivity(elem);
            return this._recurse;
        }

        @Override
        public boolean start(Protocol elem) {
            boolean ret;
            boolean bl = ret = this._protocol == elem;
            if (ret) {
                Vector<Role> rlist = new Vector<Role>();
                this._roleStack.add(rlist);
                if (elem.getLocatedRole() != null) {
                    rlist.add(elem.getLocatedRole());
                }
                for (ParameterDefinition p : elem.getParameterDefinitions()) {
                    if (p.getType() != null) continue;
                    rlist.add(new Role(p.getName()));
                }
            }
            return ret;
        }

        @Override
        public boolean start(Repeat elem) {
            this.checkActivity(elem);
            return this._recurse;
        }

        @Override
        public boolean start(RecBlock elem) {
            this.checkActivity(elem);
            return this._recurse;
        }

        @Override
        public boolean start(Do elem) {
            this.checkActivity(elem);
            return this._recurse;
        }

        @Override
        public boolean start(Interrupt elem) {
            return this._recurse;
        }

        @Override
        public void accept(Run elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(Interaction elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(Introduces elem) {
            List<Role> rlist = this._roleStack.get(this._roleStack.size() - 1);
            rlist.addAll(elem.getIntroducedRoles());
        }

        @Override
        public void accept(Inline elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(Recursion elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(End elem) {
            this.checkActivity(elem);
        }

        protected void checkActivity(Activity elem) {
            if (elem == this._activity) {
                for (List<Role> plist : this._roleStack) {
                    for (Role p : plist) {
                        this._result.add(p);
                    }
                }
                this._recurse = false;
            }
        }
    }
}

