/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.common.resource.ResourceContent;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.ProtocolTools;
import org.scribble.protocol.export.ProtocolExportManager;
import org.scribble.protocol.model.ProtocolImport;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParserManager;
import org.scribble.protocol.projection.ProtocolProjector;
import org.scribble.protocol.validation.ProtocolValidationManager;

public class DefaultProtocolTools
implements ProtocolTools {
    private ProtocolParserManager _parserManager = null;
    private ProtocolValidationManager _validationManager = null;
    private ResourceLocator _resourceLocator = null;
    private ProtocolProjector _projector = null;
    private ProtocolExportManager _exportManager = null;
    private static Logger logger = Logger.getLogger(DefaultProtocolTools.class.getName());

    public DefaultProtocolTools() {
    }

    public DefaultProtocolTools(ProtocolParserManager parserManager, ResourceLocator locator) {
        this._parserManager = parserManager;
        this._resourceLocator = locator;
    }

    public ResourceLocator getResourceLocator() {
        return this._resourceLocator;
    }

    public void setResourceLocator(ResourceLocator locator) {
        this._resourceLocator = locator;
    }

    public void setProtocolParserManager(ProtocolParserManager ppm) {
        this._parserManager = ppm;
    }

    public ProtocolValidationManager getProtocolValidationManager() {
        return this._validationManager;
    }

    public void setProtocolValidationManager(ProtocolValidationManager vm) {
        this._validationManager = vm;
    }

    public ProtocolModel getProtocolModel(ProtocolImport pi, Journal journal) {
        ProtocolModel ret = null;
        if (pi.getLocation() == null || pi.getLocation().trim().length() == 0) {
            journal.error("Protocol import does not define a location", pi.getProperties());
        } else {
            try {
                URI uri = this.getResourceLocator().getResourceURI(pi.getLocation());
                ResourceContent content = new ResourceContent(uri);
                ret = this._parserManager.parse(this, (Content)content, journal);
            }
            catch (MalformedURLException mue) {
                journal.error("Invalid URL '" + mue + "'", pi.getProperties());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to read protocol from '" + pi.getLocation() + "'", e);
                journal.error("Failed to read protocol from '" + pi.getLocation() + "'", pi.getProperties());
            }
        }
        return ret;
    }

    public ProtocolProjector getProtocolProjector() {
        return this._projector;
    }

    public void setProtocolProjector(ProtocolProjector pp) {
        this._projector = pp;
    }

    public ProtocolExportManager getProtocolExportManager() {
        return this._exportManager;
    }

    public void setProtocolExportManager(ProtocolExportManager em) {
        this._exportManager = em;
    }
}

