/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.MultiPathBehaviour;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;
import org.scribble.protocol.model.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Choice
extends MultiPathBehaviour {
    private static final long serialVersionUID = 1989654742243530028L;
    private List<When> m_whens = new ContainmentList<When>(this, When.class);
    private Role m_fromRole = null;
    private Role m_toRole = null;

    @Override
    public boolean isMutuallyExclusivePaths() {
        return true;
    }

    @Override
    public boolean isWaitState() {
        boolean ret = false;
        Role role = this.locatedRole();
        if (role != null && this.m_toRole != null && role.getName().equals(this.m_toRole.getName())) {
            ret = true;
        }
        return ret;
    }

    public Role getFromRole() {
        return this.m_fromRole;
    }

    public void setFromRole(Role part) {
        this.m_fromRole = part;
    }

    public Role getToRole() {
        return this.m_toRole;
    }

    public void setToRole(Role part) {
        this.m_toRole = part;
    }

    public List<When> getWhens() {
        return this.m_whens;
    }

    @Override
    public List<? extends Block> getPaths() {
        Vector<Block> ret = new Vector<Block>();
        for (When w : this.getWhens()) {
            ret.add(w.getBlock());
        }
        return ret;
    }

    public boolean removePath(Block path) {
        boolean ret = false;
        ret = this.m_whens.remove(path);
        return ret;
    }

    @Override
    public boolean isStrictScope() {
        return false;
    }

    @Override
    public List<Role> initiatorRoles() {
        List<Role> ret = super.initiatorRoles();
        if (this.getFromRole() != null) {
            ret.add(this.getFromRole());
        }
        return ret;
    }

    @Override
    public List<Role> finalRoles() {
        List<Role> ret = super.finalRoles();
        return ret;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.start(this);
        if (this.getFromRole() != null) {
            this.getFromRole().visit(visitor);
        }
        if (this.getToRole() != null) {
            this.getToRole().visit(visitor);
        }
        for (When w : this.getWhens()) {
            w.visit(visitor);
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Choice that = (Choice)o;
        return !(this.m_fromRole == null ? that.m_fromRole != null : !this.m_fromRole.equals(that.m_fromRole)) && !(this.m_toRole == null ? that.m_toRole != null : !this.m_toRole.equals(that.m_toRole)) && ((Object)this.m_whens).equals(that.m_whens);
    }

    public int hashCode() {
        int result = ((Object)this.m_whens).hashCode();
        result = 31 * result + (this.m_fromRole != null ? this.m_fromRole.hashCode() : 0);
        result = 31 * result + (this.m_toRole != null ? this.m_toRole.hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "choice ";
        if (this.m_fromRole != null) {
            result = result + "from " + this.m_fromRole;
        }
        if (this.m_toRole != null) {
            result = result + "to " + this.m_toRole;
        }
        result = result + "{\n";
        for (When w : this.m_whens) {
            result = result + w + "\n";
        }
        return result + "}";
    }
}

