/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ImportList;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.ProjectorContext;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.util.RoleUtil;

public class ProtocolModelProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == ProtocolModel.class;
    }

    public ModelObject project(ProjectorContext context, ModelObject model, Role role, Journal l) {
        ProtocolModel ret = new ProtocolModel();
        ProtocolModel source = (ProtocolModel)model;
        ret.derivedFrom((ModelObject)source);
        for (int i = 0; i < source.getImports().size(); ++i) {
            ImportList newImport = (ImportList)context.project((ModelObject)source.getImports().get(i), role, l);
            if (newImport == null) continue;
            ret.getImports().add(newImport);
        }
        Protocol protocol = null;
        Role roleDefn = null;
        for (Role sr : source.getRoles()) {
            if (!sr.equals((Object)role)) continue;
            roleDefn = sr;
            break;
        }
        if (roleDefn == null) {
            l.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.projection.Messages").getString("_UNKNOWN_ROLE"), role.getName()), ret.getProperties());
            ret = null;
        } else {
            Block block;
            Protocol srcprotocol = RoleUtil.getEnclosingProtocol(roleDefn);
            if (srcprotocol != null && (block = RoleUtil.getEnclosingBlock((Protocol)(protocol = (Protocol)context.project((ModelObject)srcprotocol, role, l)), (Role)roleDefn)) != null) {
                if (srcprotocol != source.getProtocol()) {
                    protocol.setName(source.getProtocol().getName());
                    protocol.getParameterDefinitions().clear();
                }
                protocol.setBlock(block);
                Set declaredRoles = RoleUtil.getDeclaredRoles((Block)protocol.getBlock());
                Set usedRoles = RoleUtil.getUsedRoles((Activity)protocol.getBlock());
                usedRoles.removeAll(declaredRoles);
                protocol.getParameterDefinitions().clear();
                for (Role used : usedRoles) {
                    if (used.equals((Object)role)) continue;
                    ParameterDefinition pd = new ParameterDefinition();
                    pd.setName(used.getName());
                    protocol.getParameterDefinitions().add(pd);
                }
            }
            ret.setProtocol(protocol);
        }
        return ret;
    }
}

