/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.util.List;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Parameter;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolImport;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.ProtocolReference;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.projection.impl.ProjectorContext;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.util.ProtocolModelUtil;
import org.scribble.protocol.util.RunUtil;

public class RunProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Run.class;
    }

    public ModelObject project(ProjectorContext context, ModelObject model, Role role, Journal l) {
        Run ret = new Run();
        Run source = (Run)model;
        ret.derivedFrom((ModelObject)source);
        List params = source.getParameters();
        int mappedIndex = -1;
        for (int i = 0; i < params.size(); ++i) {
            Parameter db = (Parameter)params.get(i);
            if (!db.getName().equals(role.getName())) {
                Parameter dbcopy = new Parameter(db.getName());
                dbcopy.derivedFrom((ModelObject)db);
                ret.getParameters().add(dbcopy);
                continue;
            }
            mappedIndex = i;
        }
        if (source.getProtocolReference() != null) {
            boolean f_inner = false;
            Protocol defn = RunUtil.getInnerProtocol((Protocol)source.enclosingProtocol(), (ProtocolReference)source.getProtocolReference());
            if (defn == null) {
                ProtocolImport pi = ProtocolModelUtil.getProtocolImport((ProtocolModel)source.getModel(), (ProtocolReference)source.getProtocolReference());
                if (pi == null) {
                    l.error("Referenced protocol '" + source.getProtocolReference().getName() + "' not found within model or in import statements", source.getProperties());
                } else {
                    ProtocolModel pm = context.getProtocolContext().getProtocolModel(pi, l);
                    if (pm != null) {
                        defn = pm.getProtocol();
                    } else {
                        l.error("Referenced protocol '" + source.getProtocolReference().getName() + "' could not be loaded from location '" + pi.getLocation() + "'", source.getProperties());
                    }
                }
            } else {
                f_inner = true;
            }
            if (defn != null && mappedIndex != -1) {
                Role mappedRole = null;
                if (mappedIndex < defn.getParameterDefinitions().size()) {
                    ParameterDefinition pd = (ParameterDefinition)defn.getParameterDefinitions().get(mappedIndex);
                    if (pd.getType() != null) {
                        l.error("Run parameter is not a role", source.getProperties());
                    } else {
                        mappedRole = new Role(pd.getName());
                    }
                } else {
                    l.error("Run parameter is not a role", source.getProperties());
                }
                if (mappedRole != null) {
                    if (f_inner) {
                        context.registerInterest(defn, mappedRole);
                    }
                    ret.setProtocolReference((ProtocolReference)context.project((ModelObject)source.getProtocolReference(), mappedRole, l));
                }
            } else {
                ret = null;
            }
        }
        if (ret != null && source.getBlock() != null) {
            ret.setBlock((Block)context.project((ModelObject)source.getBlock(), role, l));
            ret.getBlock().setParent((ModelObject)ret);
        }
        return ret;
    }
}

