/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.ImportList;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.RoleList;
import org.scribble.protocol.projection.impl.ProjectorContext;
import org.scribble.protocol.projection.impl.ProjectorRule;

public class ProtocolModelProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == ProtocolModel.class;
    }

    public ModelObject project(ProjectorContext context, ModelObject model, Role role, Journal l) {
        ProtocolModel ret = new ProtocolModel();
        ProtocolModel source = (ProtocolModel)model;
        ret.derivedFrom((ModelObject)source);
        for (int i = 0; i < source.getImports().size(); ++i) {
            ImportList newImport = (ImportList)context.project((ModelObject)source.getImports().get(i), role, l);
            if (newImport == null) continue;
            ret.getImports().add(newImport);
        }
        Protocol protocol = null;
        Role roleDefn = null;
        for (Role sr : source.getRoles()) {
            if (!sr.equals((Object)role)) continue;
            roleDefn = sr;
            break;
        }
        if (roleDefn == null) {
            l.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.projection.Messages").getString("_UNKNOWN_ROLE"), role.getName()), ret.getProperties());
            ret = null;
        } else {
            Protocol srcprotocol = ((RoleList)roleDefn.getParent()).enclosingProtocol();
            if (srcprotocol != null) {
                protocol = (Protocol)context.project((ModelObject)srcprotocol, role, l);
            }
            ret.setProtocol(protocol);
        }
        return ret;
    }
}

