/*
 * Copyright 2009-10 www.scribble.org
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.scribble.protocol.projection.impl;

import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.*;

/**
 * This class provides the Include implementation of the
 * projector rule.
 */
public class IncludeProjectorRule implements ProjectorRule {

	/**
	 * This method determines whether the projection rule is
	 * appropriate for the supplied model object.
	 * 
	 * @param obj The model object to be projected
	 * @return Whether the rule is relevant for the
	 * 				model object
	 */
	public boolean isSupported(ModelObject obj) {
		return(obj.getClass() == Include.class);
	}
	
	/**
	 * This method projects the supplied model object based on the
	 * specified role.
	 * 
	 * @param model The model object
	 * @param role The role
	 * @param l The model listener
	 * @return The projected model object
	 */
	public ModelObject project(ProjectorContext context, ModelObject model,
					Role role, Journal l) {
		Include ret=new Include();
		Include source=(Include)model;
		
		ret.derivedFrom(source);
		
		java.util.Iterator<Parameter> iter=
					source.getParameters().iterator();
		while (iter.hasNext()) {
			Parameter db=iter.next();
			
			// Don't project declaration if same as role - this
			// will be done in the model include statement,
			// not the bindings
			if (db.getName().equals(role.getName()) == false) {
				
				Parameter dbcopy=
						new Parameter(db.getName(),
									db.getBoundName());
					
				dbcopy.derivedFrom(db);
					
				ret.getParameters().add(dbcopy);
			}
		}
		
		Role mappedRole=role;
		
		// Determine whether role name has been mapped
		Parameter db=null;
		if ((db=source.getParameter(role.getName())) != null) {
			String rename=db.getBoundName();
			
			if (rename != null) {
				mappedRole = new Role();
				mappedRole.setName(rename);
			}
		}
		
		if (source.getReference() != null) {
			
			/*
			// Store protocol against mapped role
			Protocol defn=source.getProtocol();
			
			if (defn != null &&
					defn.getRoles().contains(mappedRole)) {
				
				// If inner reference, then record interest
				// in project of definition against this mapped
				// role
				if (source.getReference().isInner()) {
					context.registerInterest(defn, mappedRole);
				}
				*/
				ret.setReference((ProtocolReference)context.project(
							source.getReference(), mappedRole, l));
				
				/*
			} else {
				ret = null;
			}
			*/
		}

		return(ret);
	}
}
