/*
 * Decompiled with CFR 0.152.
 */
package scoverage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scoverage.Constants$;

public final class IOUtils$ {
    public static IOUtils$ MODULE$;
    private final char UnixSeperator;
    private final char WindowsSeperator;
    private final String UTF8Encoding;
    private final Function1<File, Object> isMeasurementFile;
    private final Function1<File, Object> isReportFile;
    private final Function1<File, Object> isDebugReportFile;

    static {
        new IOUtils$();
    }

    public File getTempDirectory() {
        return new File(this.getTempPath());
    }

    public String getTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public String readStreamAsString(InputStream in) {
        return Source$.MODULE$.fromInputStream(in, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private char UnixSeperator() {
        return this.UnixSeperator;
    }

    private char WindowsSeperator() {
        return this.WindowsSeperator;
    }

    private String UTF8Encoding() {
        return this.UTF8Encoding;
    }

    public Object getName(String path) {
        int lastUnixPos = path.lastIndexOf(this.UnixSeperator());
        int lastWindowsPos = path.lastIndexOf(this.WindowsSeperator());
        int index = Math.max(lastUnixPos, lastWindowsPos);
        return new StringOps(Predef$.MODULE$.augmentString(path)).drop(index + 1);
    }

    public File reportFile(File outputDir, boolean debug) {
        File file;
        boolean bl = debug;
        if (bl) {
            file = new File(outputDir, Constants$.MODULE$.XMLReportFilenameWithDebug());
        } else if (!bl) {
            file = new File(outputDir, Constants$.MODULE$.XMLReportFilename());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return file;
    }

    public boolean reportFile$default$2() {
        return false;
    }

    public void clean(File dataDir) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.findMeasurementFiles(dataDir))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.delete()));
    }

    public void clean(String dataDir) {
        this.clean(new File(dataDir));
    }

    public void writeToFile(File file, String str) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.UTF8Encoding()));){
            writer.write(str);
        }
    }

    public File measurementFile(File dataDir) {
        return this.measurementFile(dataDir.getAbsolutePath());
    }

    public File measurementFile(String dataDir) {
        return new File(dataDir, new StringBuilder(0).append(Constants$.MODULE$.MeasurementsPrefix()).append(Thread.currentThread().getId()).toString());
    }

    public File[] findMeasurementFiles(String dataDir) {
        return this.findMeasurementFiles(new File(dataDir));
    }

    public File[] findMeasurementFiles(File dataDir) {
        return dataDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith(Constants$.MODULE$.MeasurementsPrefix());
            }
        });
    }

    public Seq<File> scoverageDataDirsSearch(File baseDir) {
        return IOUtils$.search$1(baseDir);
    }

    public Function1<File, Object> isMeasurementFile() {
        return this.isMeasurementFile;
    }

    public Function1<File, Object> isReportFile() {
        return this.isReportFile;
    }

    public Function1<File, Object> isDebugReportFile() {
        return this.isDebugReportFile;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Tuple2<Object, String>> invoked(Seq<File> files) {
        void var2_2;
        scala.collection.mutable.Set acc = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        files.foreach((Function1 & Serializable & scala.Serializable)file -> {
            IOUtils$.$anonfun$invoked$1(acc, file);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    private static final FileFilter directoryFilter$1() {
        return new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final Seq search$1(File file2) {
        void var1_6;
        File file3 = file2;
        if (file3.isDirectory()) {
            String string = file3.getName();
            String string2 = Constants$.MODULE$.DataDir();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{file3}));
                return var1_6;
            }
        }
        if (file3.isDirectory()) {
            Seq seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file3.listFiles(IOUtils$.directoryFilter$1()))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)file -> IOUtils$.search$1(file), Seq$.MODULE$.canBuildFrom());
            return var1_6;
        }
        Nil$ nil$ = Nil$.MODULE$;
        return var1_6;
    }

    public static final /* synthetic */ boolean $anonfun$isMeasurementFile$1(File file) {
        return file.getName().startsWith(Constants$.MODULE$.MeasurementsPrefix());
    }

    public static final /* synthetic */ boolean $anonfun$isReportFile$1(File file) {
        String string = file.getName();
        String string2 = Constants$.MODULE$.XMLReportFilename();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isDebugReportFile$1(File file) {
        String string = file.getName();
        String string2 = Constants$.MODULE$.XMLReportFilenameWithDebug();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$invoked$1(scala.collection.mutable.Set acc$1, File file) {
        BufferedSource reader = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
        reader.getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
            BoxedUnit boxedUnit;
            if (!line.isEmpty()) {
                Tuple2 tuple2;
                List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split(" "))).toList();
                Some some = List$.MODULE$.unapplySeq((Seq)list);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                    String idx = (String)((LinearSeqOptimized)some.get()).apply(0);
                    String clazz = (String)((LinearSeqOptimized)some.get()).apply(1);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(idx)).toInt()), (Object)clazz);
                } else {
                    Some some2 = List$.MODULE$.unapplySeq((Seq)list);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
                        String idx = (String)((LinearSeqOptimized)some2.get()).apply(0);
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(idx)).toInt()), (Object)"");
                    } else {
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"");
                    }
                }
                boxedUnit = acc$1.$plus$eq((Object)tuple2);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        reader.close();
    }

    private IOUtils$() {
        MODULE$ = this;
        this.UnixSeperator = (char)47;
        this.WindowsSeperator = (char)92;
        this.UTF8Encoding = "UTF-8";
        this.isMeasurementFile = (Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$isMeasurementFile$1(file));
        this.isReportFile = (Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$isReportFile$1(file));
        this.isDebugReportFile = (Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)IOUtils$.$anonfun$isDebugReportFile$1(file));
    }
}

