/*
 * Decompiled with CFR 0.152.
 */
package scoverage.domain;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scoverage.domain.CodeGrid$Cell$;
import scoverage.domain.Invoked$;
import scoverage.domain.MeasuredFile;
import scoverage.domain.NoData$;
import scoverage.domain.NotInvoked$;
import scoverage.domain.StatementStatus;

public class CodeGrid {
    private final Option<String> sourceEncoding;
    public final CodeGrid$Cell$ Cell$lzy1;
    private final String lineBreak;
    private final Cell[] cells;
    private final String highlighted;

    public CodeGrid(MeasuredFile mFile, Option<String> sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
        this.Cell$lzy1 = new CodeGrid$Cell$(this);
        this.lineBreak = "\n";
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.source(mFile).split(this.lineBreak));
        Cell[][] lines = (Cell[][])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)line -> {
            Object object = Predef$.MODULE$.charArrayOps(line.toCharArray());
            Object object2 = Predef$.MODULE$.charArrayOps((char[])ArrayOps$.MODULE$.$plus$plus$extension(object, (IterableOnce)Predef$.MODULE$.wrapString(this.lineBreak), ClassTag$.MODULE$.apply(Character.TYPE)));
            return (Cell[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$1 -> this.$init$$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)), ClassTag$.MODULE$.apply(Cell.class));
        }, ClassTag$.MODULE$.apply(Cell.class).wrap());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])lines);
        this.cells = (Cell[])ArrayOps$.MODULE$.flatten$extension(object2, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Cell.class));
        mFile.statements().foreach((Function1)(JProcedure1 & Serializable)stmt -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(stmt.start()), stmt.end()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.cells);
            if (k < ArrayOps$.MODULE$.size$extension(object)) {
                StatementStatus statementStatus = this.cells[k].status();
                if (Invoked$.MODULE$.equals(statementStatus)) {
                    if (!stmt.isInvoked()) {
                        this.cells[k].status_$eq(NotInvoked$.MODULE$);
                        return;
                    }
                    return;
                }
                if (NoData$.MODULE$.equals(statementStatus)) {
                    if (!stmt.isInvoked()) {
                        this.cells[k].status_$eq(NotInvoked$.MODULE$);
                        return;
                    }
                    if (stmt.isInvoked()) {
                        this.cells[k].status_$eq(Invoked$.MODULE$);
                        return;
                    }
                    return;
                }
                if (NotInvoked$.MODULE$.equals(statementStatus)) {
                    return;
                }
                throw new MatchError((Object)statementStatus);
            }
        }));
        IntRef lineNumber = IntRef.create((int)1);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])lines);
        String code = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)line -> {
            int n;
            ObjectRef style = ObjectRef.create((Object)this.cellStyle(NoData$.MODULE$));
            scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
            sb.append(lineNumber$1.elem).append(" ");
            lineNumber$1.elem = n = lineNumber$1.elem + 1;
            sb.append(this.spanStart(NoData$.MODULE$));
            Object object = Predef$.MODULE$.refArrayOps((Object[])line);
            ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)cell -> {
                String style2 = this.cellStyle(cell.status());
                String string = (String)style$1.elem;
                String string2 = style2;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    sb.append("</span>");
                    sb.append(this.spanStart(cell.status()));
                    String string3 = style2;
                    style$1.elem = string3;
                    string3 = null;
                }
                char c = cell.char();
                switch (c) {
                    case '<': {
                        return sb.append("&lt;");
                    }
                    case '>': {
                        return sb.append("&gt;");
                    }
                    case '&': {
                        return sb.append("&amp;");
                    }
                    case '\"': {
                        return sb.append("&quot;");
                    }
                }
                char c2 = c;
                return sb.append(c2);
            }, ClassTag$.MODULE$.apply(scala.collection.mutable.StringBuilder.class));
            sb.append("</span>");
            return sb.toString();
        }, ClassTag$.MODULE$.apply(String.class))).mkString("");
        this.highlighted = new StringBuilder(69).append("<pre style='font-size: 12pt; font-family: courier, monospace;'>").append(code).append("</pre>").toString();
    }

    public CodeGrid(MeasuredFile mFile) {
        this(mFile, (Option<String>)None$.MODULE$);
    }

    public final CodeGrid$Cell$ Cell() {
        return this.Cell$lzy1;
    }

    public String highlighted() {
        return this.highlighted;
    }

    private String source(MeasuredFile mfile) {
        String string;
        BufferedSource bufferedSource;
        Option<String> option = this.sourceEncoding;
        if (option instanceof Some) {
            String enc = (String)((Some)option).value();
            bufferedSource = Source$.MODULE$.fromFile(mfile.source(), enc);
        } else if (None$.MODULE$.equals(option)) {
            bufferedSource = Source$.MODULE$.fromFile(mfile.source(), Codec$.MODULE$.UTF8().name());
        } else {
            throw new MatchError(option);
        }
        try (BufferedSource src = bufferedSource;){
            string = src.mkString();
        }
        return string;
    }

    private String spanStart(StatementStatus status) {
        return new StringBuilder(15).append("<span style='").append(this.cellStyle(status)).append("'>").toString();
    }

    private String cellStyle(StatementStatus status) {
        String GREEN = "#AEF1AE";
        String RED = "#F0ADAD";
        StatementStatus statementStatus = status;
        if (Invoked$.MODULE$.equals(statementStatus)) {
            return new StringBuilder(12).append("background: ").append(GREEN).toString();
        }
        if (NotInvoked$.MODULE$.equals(statementStatus)) {
            return new StringBuilder(12).append("background: ").append(RED).toString();
        }
        if (NoData$.MODULE$.equals(statementStatus)) {
            return "";
        }
        throw new MatchError((Object)statementStatus);
    }

    private final /* synthetic */ Cell $init$$$anonfun$1$$anonfun$1(char _$1) {
        return this.Cell().apply(_$1, NoData$.MODULE$);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Cell
    implements Product,
    Serializable {
        private final char char;
        private StatementStatus status;
        private final /* synthetic */ CodeGrid $outer;

        public Cell(CodeGrid $outer, char c, StatementStatus status) {
            this.char = c;
            this.status = status;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.char());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.status()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cell)) return false;
            if (((Cell)object).scoverage$domain$CodeGrid$Cell$$$outer() != this.$outer) return false;
            Cell cell = (Cell)object;
            if (this.char() != cell.char()) return false;
            StatementStatus statementStatus = this.status();
            StatementStatus statementStatus2 = cell.status();
            if (statementStatus == null) {
                if (statementStatus2 != null) {
                    return false;
                }
            } else if (!statementStatus.equals(statementStatus2)) return false;
            if (!cell.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Cell;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Cell";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToCharacter((char)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "char";
            }
            if (1 == n2) {
                return "status";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public char char() {
            return this.char;
        }

        public StatementStatus status() {
            return this.status;
        }

        public void status_$eq(StatementStatus x$1) {
            this.status = x$1;
        }

        public Cell copy(char c, StatementStatus status) {
            return new Cell(this.$outer, c, status);
        }

        public char copy$default$1() {
            return this.char();
        }

        public StatementStatus copy$default$2() {
            return this.status();
        }

        public char _1() {
            return this.char();
        }

        public StatementStatus _2() {
            return this.status();
        }

        public final /* synthetic */ CodeGrid scoverage$domain$CodeGrid$Cell$$$outer() {
            return this.$outer;
        }
    }
}

