/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.math.BigInt;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scodec.bits.Bases;
import scodec.bits.Bases$Alphabets$Base32$;
import scodec.bits.Bases$Alphabets$Base58$;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$Binary$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.BitVector;
import scodec.bits.BitVector$Append$;
import scodec.bits.BitVector$Bytes$;
import scodec.bits.BitVector$Chunks$;
import scodec.bits.BitVector$Drop$;
import scodec.bits.BitVector$GroupedOp$;
import scodec.bits.BitVector$Suspend$;
import scodec.bits.BitVectorCompanionCrossPlatform;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class BitVector$
implements BitVectorCompanionCrossPlatform,
Mirror.Sum,
Serializable {
    private static final BitVector empty;
    private static final BitVector zero;
    private static final BitVector one;
    private static final BitVector lowByte;
    private static final BitVector highByte;
    public static final BitVector$Bytes$ Bytes;
    public static final BitVector$Drop$ Drop;
    public static final BitVector$Append$ Append;
    public static final BitVector$Suspend$ Suspend;
    public static final BitVector$Chunks$ Chunks;
    private static final byte[] bitReversalTable;
    public static final BitVector$GroupedOp$ GroupedOp;
    public static final BitVector$ MODULE$;

    private BitVector$() {
    }

    static {
        MODULE$ = new BitVector$();
        empty = MODULE$.toBytes(ByteVector$.MODULE$.empty(), 0L);
        zero = MODULE$.toBytes(ByteVector$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}), Numeric.IntIsIntegral$.MODULE$), 1L);
        one = MODULE$.toBytes(ByteVector$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{255}), Numeric.IntIsIntegral$.MODULE$), 1L);
        lowByte = MODULE$.toBytes(ByteVector$.MODULE$.low(1L), 8L);
        highByte = MODULE$.toBytes(ByteVector$.MODULE$.high(1L), 8L);
        bitReversalTable = new byte[]{(byte)0, (byte)128, (byte)64, (byte)192, (byte)32, (byte)160, (byte)96, (byte)224, (byte)16, (byte)144, (byte)80, (byte)208, (byte)48, (byte)176, (byte)112, (byte)240, (byte)8, (byte)136, (byte)72, (byte)200, (byte)40, (byte)168, (byte)104, (byte)232, (byte)24, (byte)152, (byte)88, (byte)216, (byte)56, (byte)184, (byte)120, (byte)248, (byte)4, (byte)132, (byte)68, (byte)196, (byte)36, (byte)164, (byte)100, (byte)228, (byte)20, (byte)148, (byte)84, (byte)212, (byte)52, (byte)180, (byte)116, (byte)244, (byte)12, (byte)140, (byte)76, (byte)204, (byte)44, (byte)172, (byte)108, (byte)236, (byte)28, (byte)156, (byte)92, (byte)220, (byte)60, (byte)188, (byte)124, (byte)252, (byte)2, (byte)130, (byte)66, (byte)194, (byte)34, (byte)162, (byte)98, (byte)226, (byte)18, (byte)146, (byte)82, (byte)210, (byte)50, (byte)178, (byte)114, (byte)242, (byte)10, (byte)138, (byte)74, (byte)202, (byte)42, (byte)170, (byte)106, (byte)234, (byte)26, (byte)154, (byte)90, (byte)218, (byte)58, (byte)186, (byte)122, (byte)250, (byte)6, (byte)134, (byte)70, (byte)198, (byte)38, (byte)166, (byte)102, (byte)230, (byte)22, (byte)150, (byte)86, (byte)214, (byte)54, (byte)182, (byte)118, (byte)246, (byte)14, (byte)142, (byte)78, (byte)206, (byte)46, (byte)174, (byte)110, (byte)238, (byte)30, (byte)158, (byte)94, (byte)222, (byte)62, (byte)190, (byte)126, (byte)254, (byte)1, (byte)129, (byte)65, (byte)193, (byte)33, (byte)161, (byte)97, (byte)225, (byte)17, (byte)145, (byte)81, (byte)209, (byte)49, (byte)177, (byte)113, (byte)241, (byte)9, (byte)137, (byte)73, (byte)201, (byte)41, (byte)169, (byte)105, (byte)233, (byte)25, (byte)153, (byte)89, (byte)217, (byte)57, (byte)185, (byte)121, (byte)249, (byte)5, (byte)133, (byte)69, (byte)197, (byte)37, (byte)165, (byte)101, (byte)229, (byte)21, (byte)149, (byte)85, (byte)213, (byte)53, (byte)181, (byte)117, (byte)245, (byte)13, (byte)141, (byte)77, (byte)205, (byte)45, (byte)173, (byte)109, (byte)237, (byte)29, (byte)157, (byte)93, (byte)221, (byte)61, (byte)189, (byte)125, (byte)253, (byte)3, (byte)131, (byte)67, (byte)195, (byte)35, (byte)163, (byte)99, (byte)227, (byte)19, (byte)147, (byte)83, (byte)211, (byte)51, (byte)179, (byte)115, (byte)243, (byte)11, (byte)139, (byte)75, (byte)203, (byte)43, (byte)171, (byte)107, (byte)235, (byte)27, (byte)155, (byte)91, (byte)219, (byte)59, (byte)187, (byte)123, (byte)251, (byte)7, (byte)135, (byte)71, (byte)199, (byte)39, (byte)167, (byte)103, (byte)231, (byte)23, (byte)151, (byte)87, (byte)215, (byte)55, (byte)183, (byte)119, (byte)247, (byte)15, (byte)143, (byte)79, (byte)207, (byte)47, (byte)175, (byte)111, (byte)239, (byte)31, (byte)159, (byte)95, (byte)223, (byte)63, (byte)191, (byte)127, (byte)255};
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BitVector$.class);
    }

    public BitVector empty() {
        return empty;
    }

    public BitVector zero() {
        return zero;
    }

    public BitVector one() {
        return one;
    }

    public BitVector lowByte() {
        return lowByte;
    }

    public BitVector highByte() {
        return highByte;
    }

    public BitVector bit(boolean high) {
        if (high) {
            return this.one();
        }
        return this.zero();
    }

    public BitVector bits(Iterable<Object> b2) {
        return (BitVector)b2.iterator().zipWithIndex().foldLeft((Object)this.low(b2.size()), (Function2 & Serializable)(acc, b) -> acc.update(b._2$mcI$sp(), b._1$mcZ$sp()));
    }

    public BitVector high(long n) {
        return this.fill(n, true);
    }

    public BitVector low(long n) {
        return this.fill(n, false);
    }

    public BitVector apply(ByteVector bs) {
        return this.toBytes(bs, bs.size() * 8L);
    }

    public BitVector apply(ByteBuffer buffer) {
        return this.apply(ByteVector$.MODULE$.apply(buffer));
    }

    public BitVector apply(byte[] bs) {
        Object object = Predef$.MODULE$.byteArrayOps(bs);
        return this.toBytes(ByteVector$.MODULE$.apply(bs), (long)ArrayOps$.MODULE$.size$extension(object) * 8L);
    }

    public BitVector apply(IterableOnce<Object> bs) {
        return this.apply(ByteVector$.MODULE$.apply(bs));
    }

    public <A> BitVector apply(Seq<A> bytes, Integral<A> evidence$1) {
        return this.apply(ByteVector$.MODULE$.apply(bytes, evidence$1));
    }

    public BitVector view(ByteBuffer buffer) {
        return this.toBytes(ByteVector$.MODULE$.view(buffer), (long)buffer.limit() * 8L);
    }

    public BitVector view(ByteBuffer buffer, long sizeInBits) {
        return this.toBytes(ByteVector$.MODULE$.view(buffer), sizeInBits);
    }

    public BitVector view(byte[] bs) {
        Object object = Predef$.MODULE$.byteArrayOps(bs);
        return this.view(bs, (long)ArrayOps$.MODULE$.size$extension(object) * 8L);
    }

    public BitVector view(byte[] bs, long sizeInBits) {
        return this.toBytes(ByteVector$.MODULE$.view(bs), sizeInBits);
    }

    public BitVector fill(long n, boolean high) {
        long needed = this.scodec$bits$BitVector$$$bytesNeededForBits(n);
        ByteVector bs = ByteVector$.MODULE$.fill(needed, high ? BoxesRunTime.boxToInteger((int)-1) : BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$);
        return this.toBytes(bs, n);
    }

    public BitVector fromByte(byte b, int size) {
        Predef$.MODULE$.require(size <= 8);
        return ((BitVector)this.apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{b}), (Integral)Numeric.ByteIsIntegral$.MODULE$).$less$less(BoxesRunTime.boxToLong((long)(8L - (long)size)))).take(size);
    }

    public int fromByte$default$2() {
        return 8;
    }

    public BitVector fromShort(short s, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 16);
        ByteBuffer buffer = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort(s);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(16L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        if (!(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null)) {
            return relevantBits;
        }
        return relevantBits.reverseByteOrder();
    }

    public int fromShort$default$2() {
        return 16;
    }

    public ByteOrdering fromShort$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public BitVector fromInt(int i, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 32);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(i);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(32L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        if (!(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null)) {
            return relevantBits;
        }
        return relevantBits.reverseByteOrder();
    }

    public int fromInt$default$2() {
        return 32;
    }

    public ByteOrdering fromInt$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public BitVector fromLong(long l, int size, ByteOrdering ordering) {
        Predef$.MODULE$.require(size <= 64);
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(l);
        buffer.flip();
        BitVector relevantBits = ((BitVector)this.view(buffer).$less$less(BoxesRunTime.boxToLong((long)(64L - (long)size)))).take(size);
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        if (!(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null)) {
            return relevantBits;
        }
        return relevantBits.reverseByteOrder();
    }

    public int fromLong$default$2() {
        return 64;
    }

    public ByteOrdering fromLong$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public BitVector fromBigInt(BigInt value, Option<Object> size, ByteOrdering ordering) {
        int actualSize = BoxesRunTime.unboxToInt((Object)size.getOrElse(() -> BitVector$.$anonfun$2(value)));
        Predef$.MODULE$.require(actualSize > 0);
        BitVector bits = this.view(value.toByteArray());
        BitVector relevantBits = bits.size() < (long)actualSize ? this.fill((long)actualSize - bits.size(), bits.head()).$plus$plus(bits) : bits.takeRight(Int$.MODULE$.int2long(actualSize));
        ByteOrdering byteOrdering = ordering;
        ByteOrdering$BigEndian$ byteOrdering$BigEndian$ = ByteOrdering$BigEndian$.MODULE$;
        if (!(byteOrdering != null ? !byteOrdering.equals(byteOrdering$BigEndian$) : byteOrdering$BigEndian$ != null)) {
            return relevantBits;
        }
        return relevantBits.reverseByteOrder();
    }

    public ByteOrdering fromBigInt$default$3() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final BitVector fromUUID(UUID u) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(u.getMostSignificantBits());
        buf.putLong(u.getLeastSignificantBits());
        return this.view(buf.array());
    }

    public Either<String, BitVector> fromBinDescriptive(String str, Bases.BinaryAlphabet alphabet) {
        Left left;
        try {
            int n;
            int count;
            Tuple2<ByteVector, Object> tuple2 = ByteVector$.MODULE$.fromBinInternal(str, alphabet);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ByteVector bytes = (ByteVector)tuple2._1();
            int count2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)count2));
            ByteVector bytes2 = (ByteVector)tuple22._1();
            int n2 = count = BoxesRunTime.unboxToInt((Object)tuple22._2());
            if (0 == n2) {
                n = 0;
            } else {
                int n3 = n2;
                if (n3 % 8 == 0) {
                    n = 0;
                } else {
                    int n4 = n2;
                    n = 8 - n4 % 8;
                }
            }
            int toDrop = n;
            left = package$.MODULE$.Right().apply((Object)bytes2.toBitVector().drop(toDrop));
        }
        catch (IllegalArgumentException t) {
            left = package$.MODULE$.Left().apply((Object)t.getMessage());
        }
        return left;
    }

    public Bases.BinaryAlphabet fromBinDescriptive$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Option<BitVector> fromBin(String str, Bases.BinaryAlphabet alphabet) {
        return this.fromBinDescriptive(str, alphabet).toOption();
    }

    public Bases.BinaryAlphabet fromBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public BitVector fromValidBin(String str, Bases.BinaryAlphabet alphabet) {
        return (BitVector)this.fromBinDescriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (BitVector)Predef$.MODULE$.identity(x));
    }

    public Bases.BinaryAlphabet fromValidBin$default$2() {
        return Bases$Alphabets$Binary$.MODULE$;
    }

    public Either<String, BitVector> fromHexDescriptive(String str, Bases.HexAlphabet alphabet) {
        Left left;
        try {
            Tuple2<ByteVector, Object> tuple2 = ByteVector$.MODULE$.fromHexInternal(str, alphabet);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ByteVector bytes = (ByteVector)tuple2._1();
            int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)count));
            ByteVector bytes2 = (ByteVector)tuple22._1();
            int count2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
            int toDrop = count2 % 2 == 0 ? 0 : 4;
            left = package$.MODULE$.Right().apply((Object)bytes2.toBitVector().drop(toDrop));
        }
        catch (IllegalArgumentException t) {
            left = package$.MODULE$.Left().apply((Object)t.getMessage());
        }
        return left;
    }

    public Bases.HexAlphabet fromHexDescriptive$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Option<BitVector> fromHex(String str, Bases.HexAlphabet alphabet) {
        return this.fromHexDescriptive(str, alphabet).toOption();
    }

    public Bases.HexAlphabet fromHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public BitVector fromValidHex(String str, Bases.HexAlphabet alphabet) {
        return (BitVector)this.fromHexDescriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (BitVector)Predef$.MODULE$.identity(x));
    }

    public Bases.HexAlphabet fromValidHex$default$2() {
        return Bases$Alphabets$HexLowercase$.MODULE$;
    }

    public Either<String, BitVector> fromBase32Descriptive(String str, Bases.Base32Alphabet alphabet) {
        return ByteVector$.MODULE$.fromBase32Descriptive(str, alphabet).map((Function1 & Serializable)_$19 -> _$19.toBitVector());
    }

    public Bases.Base32Alphabet fromBase32Descriptive$default$2() {
        return Bases$Alphabets$Base32$.MODULE$;
    }

    public Option<BitVector> fromBase32(String str, Bases.Base32Alphabet alphabet) {
        return this.fromBase32Descriptive(str, alphabet).toOption();
    }

    public Bases.Base32Alphabet fromBase32$default$2() {
        return Bases$Alphabets$Base32$.MODULE$;
    }

    public BitVector fromValidBase32(String str, Bases.Base32Alphabet alphabet) {
        return (BitVector)this.fromBase32Descriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (BitVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Base32Alphabet fromValidBase32$default$2() {
        return Bases$Alphabets$Base32$.MODULE$;
    }

    public Either<String, BitVector> fromBase58Descriptive(String str, Bases.Alphabet alphabet) {
        return ByteVector$.MODULE$.fromBase58Descriptive(str, alphabet).map((Function1 & Serializable)_$20 -> _$20.toBitVector());
    }

    public Bases.Alphabet fromBase58Descriptive$default$2() {
        return Bases$Alphabets$Base58$.MODULE$;
    }

    public Option<BitVector> fromBase58(String str, Bases.Alphabet alphabet) {
        return this.fromBase58Descriptive(str, alphabet).toOption();
    }

    public Bases.Alphabet fromBase58$default$2() {
        return Bases$Alphabets$Base58$.MODULE$;
    }

    public BitVector fromValidBase58(String str, Bases.Alphabet alphabet) {
        return (BitVector)this.fromBase58Descriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (BitVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Alphabet fromValidBase58$default$2() {
        return Bases$Alphabets$Base58$.MODULE$;
    }

    public Either<String, BitVector> fromBase64Descriptive(String str, Bases.Base64Alphabet alphabet) {
        return ByteVector$.MODULE$.fromBase64Descriptive(str, alphabet).map((Function1 & Serializable)_$21 -> _$21.toBitVector());
    }

    public Bases.Base64Alphabet fromBase64Descriptive$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Option<BitVector> fromBase64(String str, Bases.Base64Alphabet alphabet) {
        return this.fromBase64Descriptive(str, alphabet).toOption();
    }

    public Bases.Base64Alphabet fromBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public BitVector fromValidBase64(String str, Bases.Base64Alphabet alphabet) {
        return (BitVector)this.fromBase64Descriptive(str, alphabet).fold((Function1 & Serializable)msg -> {
            throw new IllegalArgumentException((String)msg);
        }, (Function1 & Serializable)x -> (BitVector)Predef$.MODULE$.identity(x));
    }

    public Bases.Base64Alphabet fromValidBase64$default$2() {
        return Bases$Alphabets$Base64$.MODULE$;
    }

    public Either<CharacterCodingException, BitVector> encodeString(String str, Charset charset) {
        return ByteVector$.MODULE$.encodeString(str, charset).map((Function1 & Serializable)_$22 -> _$22.bits());
    }

    public Either<CharacterCodingException, BitVector> encodeUtf8(String str) {
        return ByteVector$.MODULE$.encodeUtf8(str).map((Function1 & Serializable)_$23 -> _$23.bits());
    }

    public Either<CharacterCodingException, BitVector> encodeAscii(String str) {
        return ByteVector$.MODULE$.encodeAscii(str).map((Function1 & Serializable)_$24 -> _$24.bits());
    }

    public BitVector concat(IterableOnce<BitVector> bvs) {
        return (BitVector)bvs.iterator().foldLeft((Object)this.empty(), (Function2 & Serializable)(_$25, _$26) -> _$25.$plus$plus((BitVector)_$26));
    }

    public <S> BitVector unfold(S s, Function1<S, Option<Tuple2<BitVector, S>>> f) {
        return BitVector$Suspend$.MODULE$.apply((Function0<BitVector>)(Function0 & Serializable)() -> (BitVector)((Option)f.apply(s)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BitVector h = (BitVector)tuple2._1();
                Object t = tuple2._2();
                return BitVector$Append$.MODULE$.apply(h, MODULE$.unfold(t, f));
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse(BitVector$::unfold$$anonfun$1$$anonfun$2));
    }

    public BitVector fromInputStream(InputStream in2, int chunkSizeInBytes) {
        return this.unfold(in2, (Function1 & Serializable)in -> {
            byte[] buf = new byte[chunkSizeInBytes];
            int nRead = in.read(buf);
            if (nRead == chunkSizeInBytes) {
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)MODULE$.apply(buf), in));
            }
            if (nRead == -1) {
                return None$.MODULE$;
            }
            Object object = Predef$.MODULE$.byteArrayOps(buf);
            return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)MODULE$.apply((byte[])ArrayOps$.MODULE$.take$extension(object, nRead)), in));
        });
    }

    public int fromInputStream$default$2() {
        return 0xFA0000;
    }

    public BitVector fromChannel(ReadableByteChannel in2, int chunkSizeInBytes, boolean direct) {
        return this.unfold(in2, (Function1 & Serializable)in -> {
            ByteBuffer buf = direct ? ByteBuffer.allocateDirect(chunkSizeInBytes) : ByteBuffer.allocate(chunkSizeInBytes);
            int nRead = in.read(buf);
            buf.flip();
            if (nRead != -1) {
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)MODULE$.view(buf, (long)nRead * 8L), in));
            }
            return None$.MODULE$;
        });
    }

    public int fromChannel$default$2() {
        return 0xFA0000;
    }

    public boolean fromChannel$default$3() {
        return false;
    }

    public BitVector fromMmap(FileChannel in, int chunkSizeInBytes) {
        FileChannel fileChannel = (FileChannel)Predef$.MODULE$.ArrowAssoc((Object)in);
        return this.unfold(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)fileChannel, (Object)BoxesRunTime.boxToLong((long)0L)), (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                FileChannel in = (FileChannel)tuple2._1();
                long pos = BoxesRunTime.unboxToLong((Object)tuple2._2());
                if (pos == in.size()) {
                    return None$.MODULE$;
                }
                Predef$.MODULE$.require(pos < in.size());
                long bytesToRead = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(in.size() - pos), (long)chunkSizeInBytes);
                MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, pos, bytesToRead);
                Predef$.MODULE$.require((long)buf.limit() == bytesToRead);
                FileChannel fileChannel = (FileChannel)Predef$.MODULE$.ArrowAssoc((Object)in);
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)MODULE$.view(buf), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)fileChannel, (Object)BoxesRunTime.boxToLong((long)(pos + bytesToRead)))));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public int fromMmap$default$2() {
        return 0xFA0000;
    }

    public BitVector.Bytes toBytes(ByteVector bs, long sizeInBits) {
        long needed = this.scodec$bits$BitVector$$$bytesNeededForBits(sizeInBits);
        Predef$.MODULE$.require(needed <= bs.size());
        ByteVector b = bs.size() > needed ? bs.take(needed) : bs;
        return BitVector$Bytes$.MODULE$.apply(b, sizeInBits);
    }

    public BitVector concat(Vector<BitVector> vs) {
        return (BitVector)vs.foldLeft((Object)this.empty(), (Function2 & Serializable)(_$28, _$29) -> _$28.$plus$plus((BitVector)_$29));
    }

    public boolean scodec$bits$BitVector$$$getBit(byte by, int n) {
        return (128 >> n & by) != 0;
    }

    private byte setBit(byte by, int n, boolean high) {
        return (byte)(high ? 128 >> n | by : ~(128 >> n) & by);
    }

    public long scodec$bits$BitVector$$$validBitsInLastByte(long size) {
        long mod = size % 8L;
        if (mod == 0L) {
            return 8L;
        }
        return mod;
    }

    public byte scodec$bits$BitVector$$$topNBits(int n) {
        return (byte)(-1 << 8 - n);
    }

    public long scodec$bits$BitVector$$$bytesNeededForBits(long size) {
        return (size + 7L) / 8L;
    }

    public byte reverseBitsInByte(byte b) {
        return bitReversalTable[b & 0xFF];
    }

    public ByteVector scodec$bits$BitVector$$$clearUnneededBits(long size, ByteVector bytes) {
        int valid = (int)this.scodec$bits$BitVector$$$validBitsInLastByte(size);
        if (bytes.nonEmpty() && valid < 8) {
            long idx = bytes.size() - 1L;
            byte last = bytes.apply(idx);
            return bytes.update(idx, (byte)(last & this.scodec$bits$BitVector$$$topNBits(valid)));
        }
        return bytes;
    }

    public <A> A reduceBalanced(Iterable<A> v, Function1<A, Object> size, Function2<A, A, A> f) {
        return (A)((List)v.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable)(stack, a) -> {
            Object object = Predef$.MODULE$.ArrowAssoc(a);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, size.apply(a));
            return this.fixup$1(f, stack.$colon$colon((Object)tuple2));
        })).reverse().map((Function1 & Serializable)_$30 -> _$30._1()).reduceLeft(f);
    }

    public final BitVector GroupedOp(BitVector self) {
        return self;
    }

    public int ordinal(BitVector x$0) {
        BitVector bitVector = x$0;
        if (bitVector instanceof BitVector.Bytes) {
            return 0;
        }
        if (bitVector instanceof BitVector.Drop) {
            return 1;
        }
        if (bitVector instanceof BitVector.Append) {
            return 2;
        }
        if (bitVector instanceof BitVector.Suspend) {
            return 3;
        }
        if (bitVector instanceof BitVector.Chunks) {
            return 4;
        }
        throw new MatchError((Object)bitVector);
    }

    private static final int $anonfun$2(BigInt value$1) {
        return value$1.bitLength() + 1;
    }

    private static final BitVector unfold$$anonfun$1$$anonfun$2() {
        return MODULE$.empty();
    }

    public static /* bridge */ /* synthetic */ byte scodec$bits$BitVector$Bytes$$_$_$$anonfun$adapted$2(long n$11, boolean high$2, Object _$27) {
        return BitVector$.MODULE$.setBit(BoxesRunTime.unboxToByte((Object)_$27), (int)(n$11 % 8L), high$2);
    }

    private static final /* synthetic */ int $anonfun$5(int bitsToShiftEachByte$1, byte x$1, byte x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)x$1), (Object)BoxesRunTime.boxToByte((byte)x$2));
        if (tuple2 != null) {
            byte a = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte b = BoxesRunTime.unboxToByte((Object)tuple2._2());
            int hi = a << bitsToShiftEachByte$1;
            int low = ((byte)(b & MODULE$.scodec$bits$BitVector$$$topNBits(bitsToShiftEachByte$1)) & 0xFF) >>> 8 - bitsToShiftEachByte$1;
            return hi | low;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* bridge */ /* synthetic */ int scodec$bits$BitVector$Drop$$_$_$$anonfun$adapted$3(int bitsToShiftEachByte$2, Object x$1, Object x$2) {
        return BitVector$.$anonfun$5(bitsToShiftEachByte$2, BoxesRunTime.unboxToByte((Object)x$1), BoxesRunTime.unboxToByte((Object)x$2));
    }

    private final List fixup$1(Function2 f$4, List stack) {
        List list;
        while ((list = stack) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List list2 = colon2.next$access$1();
            if (tuple2 == null) break;
            Object h2 = tuple2._1();
            long n = BoxesRunTime.unboxToLong((Object)tuple2._2());
            if (!(list2 instanceof .colon.colon)) break;
            .colon.colon colon3 = (.colon.colon)list2;
            Tuple2 tuple22 = (Tuple2)colon3.head();
            List list3 = colon3.next$access$1();
            if (tuple22 == null) break;
            Object h = tuple22._1();
            long m = BoxesRunTime.unboxToLong((Object)tuple22._2());
            List t = list3;
            if (n <= m / 2L) break;
            Tuple2 tuple23 = Tuple2$.MODULE$.apply(f$4.apply(h, h2), (Object)BoxesRunTime.boxToLong((long)(m + n)));
            stack = t.$colon$colon((Object)tuple23);
        }
        return stack;
    }
}

