/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordered;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.hashing.MurmurHash3$;
import scodec.bits.Bases;
import scodec.bits.Bases$Alphabets$Base32$;
import scodec.bits.Bases$Alphabets$Base58$;
import scodec.bits.Bases$Alphabets$Base64$;
import scodec.bits.Bases$Alphabets$Base64NoPad$;
import scodec.bits.Bases$Alphabets$Base64Url$;
import scodec.bits.Bases$Alphabets$Base64UrlNoPad$;
import scodec.bits.Bases$Alphabets$Binary$;
import scodec.bits.Bases$Alphabets$HexLowercase$;
import scodec.bits.BitVector;
import scodec.bits.BitVector$;
import scodec.bits.BitwiseOperations;
import scodec.bits.ByteOrdering;
import scodec.bits.ByteOrdering$BigEndian$;
import scodec.bits.ByteVector$;
import scodec.bits.ByteVector$Append$;
import scodec.bits.ByteVector$Buffer$;
import scodec.bits.ByteVector$Chunk$;
import scodec.bits.ByteVector$Chunks$;
import scodec.bits.ByteVector$GroupedOp$;
import scodec.bits.ByteVector$View$;
import scodec.bits.ByteVectorCrossPlatform;
import scodec.bits.HexDumpFormat$;

public abstract class ByteVector
implements ByteVectorCrossPlatform,
BitwiseOperations<ByteVector, Object>,
Ordered<ByteVector>,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ByteVector.class.getDeclaredField("hashCode$lzy1"));
    private volatile Object hashCode$lzy1;

    public static ByteVector GroupedOp(ByteVector byteVector) {
        return ByteVector$.MODULE$.GroupedOp(byteVector);
    }

    public static ByteVector concat(IterableOnce<ByteVector> iterableOnce) {
        return ByteVector$.MODULE$.concat(iterableOnce);
    }

    public static ByteVector empty() {
        return ByteVector$.MODULE$.empty();
    }

    public static Either<CharacterCodingException, ByteVector> encodeAscii(String string) {
        return ByteVector$.MODULE$.encodeAscii(string);
    }

    public static Either<CharacterCodingException, ByteVector> encodeString(String string, Charset charset) {
        return ByteVector$.MODULE$.encodeString(string, charset);
    }

    public static Either<CharacterCodingException, ByteVector> encodeUtf8(String string) {
        return ByteVector$.MODULE$.encodeUtf8(string);
    }

    public static <A> ByteVector fill(long l, A a, Integral<A> integral) {
        return ByteVector$.MODULE$.fill(l, a, integral);
    }

    public static Option<ByteVector> fromBase32(String string, Bases.Base32Alphabet base32Alphabet) {
        return ByteVector$.MODULE$.fromBase32(string, base32Alphabet);
    }

    public static Either<String, ByteVector> fromBase32Descriptive(String string, Bases.Base32Alphabet base32Alphabet) {
        return ByteVector$.MODULE$.fromBase32Descriptive(string, base32Alphabet);
    }

    public static Option<ByteVector> fromBase58(String string, Bases.Alphabet alphabet) {
        return ByteVector$.MODULE$.fromBase58(string, alphabet);
    }

    public static Either<String, ByteVector> fromBase58Descriptive(String string, Bases.Alphabet alphabet) {
        return ByteVector$.MODULE$.fromBase58Descriptive(string, alphabet);
    }

    public static Option<ByteVector> fromBase64(String string, Bases.Base64Alphabet base64Alphabet) {
        return ByteVector$.MODULE$.fromBase64(string, base64Alphabet);
    }

    public static Either<String, ByteVector> fromBase64Descriptive(String string, Bases.Base64Alphabet base64Alphabet) {
        return ByteVector$.MODULE$.fromBase64Descriptive(string, base64Alphabet);
    }

    public static Option<ByteVector> fromBin(String string, Bases.BinaryAlphabet binaryAlphabet) {
        return ByteVector$.MODULE$.fromBin(string, binaryAlphabet);
    }

    public static Either<String, ByteVector> fromBinDescriptive(String string, Bases.BinaryAlphabet binaryAlphabet) {
        return ByteVector$.MODULE$.fromBinDescriptive(string, binaryAlphabet);
    }

    public static Tuple2<ByteVector, Object> fromBinInternal(String string, Bases.BinaryAlphabet binaryAlphabet) {
        return ByteVector$.MODULE$.fromBinInternal(string, binaryAlphabet);
    }

    public static ByteVector fromByte(byte by) {
        return ByteVector$.MODULE$.fromByte(by);
    }

    public static Option<ByteVector> fromHex(String string, Bases.HexAlphabet hexAlphabet) {
        return ByteVector$.MODULE$.fromHex(string, hexAlphabet);
    }

    public static Either<String, ByteVector> fromHexDescriptive(String string, Bases.HexAlphabet hexAlphabet) {
        return ByteVector$.MODULE$.fromHexDescriptive(string, hexAlphabet);
    }

    public static Tuple2<ByteVector, Object> fromHexInternal(String string, Bases.HexAlphabet hexAlphabet) {
        return ByteVector$.MODULE$.fromHexInternal(string, hexAlphabet);
    }

    public static ByteVector fromInt(int n, int n2, ByteOrdering byteOrdering) {
        return ByteVector$.MODULE$.fromInt(n, n2, byteOrdering);
    }

    public static ByteVector fromLong(long l, int n, ByteOrdering byteOrdering) {
        return ByteVector$.MODULE$.fromLong(l, n, byteOrdering);
    }

    public static ByteVector fromShort(short s, int n, ByteOrdering byteOrdering) {
        return ByteVector$.MODULE$.fromShort(s, n, byteOrdering);
    }

    public static ByteVector fromUUID(UUID uUID) {
        return ByteVector$.MODULE$.fromUUID(uUID);
    }

    public static ByteVector fromValidBase32(String string, Bases.Base32Alphabet base32Alphabet) {
        return ByteVector$.MODULE$.fromValidBase32(string, base32Alphabet);
    }

    public static ByteVector fromValidBase58(String string, Bases.Alphabet alphabet) {
        return ByteVector$.MODULE$.fromValidBase58(string, alphabet);
    }

    public static ByteVector fromValidBase64(String string, Bases.Base64Alphabet base64Alphabet) {
        return ByteVector$.MODULE$.fromValidBase64(string, base64Alphabet);
    }

    public static ByteVector fromValidBin(String string, Bases.BinaryAlphabet binaryAlphabet) {
        return ByteVector$.MODULE$.fromValidBin(string, binaryAlphabet);
    }

    public static ByteVector fromValidHex(String string, Bases.HexAlphabet hexAlphabet) {
        return ByteVector$.MODULE$.fromValidHex(string, hexAlphabet);
    }

    public static ByteVector high(long l) {
        return ByteVector$.MODULE$.high(l);
    }

    public static ByteVector low(long l) {
        return ByteVector$.MODULE$.low(l);
    }

    public static int toIntSize(long l) {
        return ByteVector$.MODULE$.toIntSize(l);
    }

    public static Some<scala.collection.immutable.Seq<Object>> unapplySeq(ByteVector byteVector) {
        return ByteVector$.MODULE$.unapplySeq(byteVector);
    }

    public static ByteVector view(At at, long l) {
        return ByteVector$.MODULE$.view(at, l);
    }

    public static ByteVector view(ByteBuffer byteBuffer) {
        return ByteVector$.MODULE$.view(byteBuffer);
    }

    public static ByteVector view(byte[] byArray) {
        return ByteVector$.MODULE$.view(byArray);
    }

    public static ByteVector view(byte[] byArray, int n, int n2) {
        return ByteVector$.MODULE$.view(byArray, n, n2);
    }

    public static ByteVector viewAt(Function1<Object, Object> function1, long l) {
        return ByteVector$.MODULE$.viewAt(function1, l);
    }

    public static ByteVector viewI(Function1<Object, Object> function1, long l) {
        return ByteVector$.MODULE$.viewI(function1, l);
    }

    public static Bases.Base32Alphabet fromBase32$default$2() {
        return ByteVector$.MODULE$.fromBase32$default$2();
    }

    public static Bases.Base32Alphabet fromBase32Descriptive$default$2() {
        return ByteVector$.MODULE$.fromBase32Descriptive$default$2();
    }

    public static Bases.Alphabet fromBase58$default$2() {
        return ByteVector$.MODULE$.fromBase58$default$2();
    }

    public static Bases.Alphabet fromBase58Descriptive$default$2() {
        return ByteVector$.MODULE$.fromBase58Descriptive$default$2();
    }

    public static Bases.Base64Alphabet fromBase64$default$2() {
        return ByteVector$.MODULE$.fromBase64$default$2();
    }

    public static Bases.Base64Alphabet fromBase64Descriptive$default$2() {
        return ByteVector$.MODULE$.fromBase64Descriptive$default$2();
    }

    public static Bases.BinaryAlphabet fromBin$default$2() {
        return ByteVector$.MODULE$.fromBin$default$2();
    }

    public static Bases.BinaryAlphabet fromBinDescriptive$default$2() {
        return ByteVector$.MODULE$.fromBinDescriptive$default$2();
    }

    public static Bases.HexAlphabet fromHex$default$2() {
        return ByteVector$.MODULE$.fromHex$default$2();
    }

    public static Bases.HexAlphabet fromHexDescriptive$default$2() {
        return ByteVector$.MODULE$.fromHexDescriptive$default$2();
    }

    public static int fromInt$default$2() {
        return ByteVector$.MODULE$.fromInt$default$2();
    }

    public static int fromLong$default$2() {
        return ByteVector$.MODULE$.fromLong$default$2();
    }

    public static int fromShort$default$2() {
        return ByteVector$.MODULE$.fromShort$default$2();
    }

    public static Bases.Base32Alphabet fromValidBase32$default$2() {
        return ByteVector$.MODULE$.fromValidBase32$default$2();
    }

    public static Bases.Alphabet fromValidBase58$default$2() {
        return ByteVector$.MODULE$.fromValidBase58$default$2();
    }

    public static Bases.Base64Alphabet fromValidBase64$default$2() {
        return ByteVector$.MODULE$.fromValidBase64$default$2();
    }

    public static Bases.BinaryAlphabet fromValidBin$default$2() {
        return ByteVector$.MODULE$.fromValidBin$default$2();
    }

    public static Bases.HexAlphabet fromValidHex$default$2() {
        return ByteVector$.MODULE$.fromValidHex$default$2();
    }

    public static ByteOrdering fromInt$default$3() {
        return ByteVector$.MODULE$.fromInt$default$3();
    }

    public static ByteOrdering fromLong$default$3() {
        return ByteVector$.MODULE$.fromLong$default$3();
    }

    public static ByteOrdering fromShort$default$3() {
        return ByteVector$.MODULE$.fromShort$default$3();
    }

    public ByteVector() {
        Ordered.$init$((Ordered)this);
    }

    public abstract long size();

    public final Option<Object> intSize() {
        if (this.size() <= Integer.MAX_VALUE) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.size())));
        }
        return None$.MODULE$;
    }

    public final long length() {
        return this.size();
    }

    public final boolean isEmpty() {
        return this.size() == 0L;
    }

    public final boolean nonEmpty() {
        return !this.isEmpty();
    }

    public byte get(long index) {
        this.checkIndex(index);
        return this.getImpl(index);
    }

    public abstract byte getImpl(long var1);

    public final byte apply(long index) {
        return this.get(index);
    }

    public final Option<Object> lift(long index) {
        if (index >= 0L && index < this.size()) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)this.apply(index)));
        }
        return None$.MODULE$;
    }

    public final ByteVector update(long idx, byte b) {
        this.checkIndex(idx);
        return this.take(idx).$colon$plus(b).$plus$plus(this.drop(idx + 1L));
    }

    public final ByteVector insert(long idx, byte b) {
        return this.take(idx).$colon$plus(b).$plus$plus(this.drop(idx));
    }

    public final ByteVector splice(long idx, ByteVector b) {
        return this.take(idx).$plus$plus(b).$plus$plus(this.drop(idx));
    }

    public final ByteVector patch(long idx, ByteVector b) {
        return this.take(idx).$plus$plus(b).$plus$plus(this.drop(idx + b.size()));
    }

    public ByteVector $plus$plus(ByteVector other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return ByteVector$Chunks$.MODULE$.apply(ByteVector$Append$.MODULE$.apply(this, other)).bufferBy(64);
    }

    public final ByteVector $plus$colon(byte by) {
        return ByteVector$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{by}), Numeric.ByteIsIntegral$.MODULE$).$plus$plus(this);
    }

    public ByteVector $colon$plus(byte by) {
        return this.$plus$plus(ByteVector$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{by}), Numeric.ByteIsIntegral$.MODULE$));
    }

    public ByteVector drop(long n) {
        long n1 = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(n), this.size())), 0L);
        if (n1 == this.size()) {
            return ByteVector$.MODULE$.empty();
        }
        if (n1 == 0L) {
            return this;
        }
        return ByteVector.go$1(this, n1, (List)package$.MODULE$.Nil());
    }

    public final ByteVector dropRight(long n) {
        return this.take(this.size() - RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(n), 0L));
    }

    public final ByteVector dropWhile(Function1<Object, Object> f) {
        LongRef toDrop = LongRef.create((long)0L);
        this.foreachSPartial(new F1BB(f, toDrop){
            private final Function1 f$1;
            private final LongRef toDrop$1;
            {
                this.f$1 = f$20;
                this.toDrop$1 = toDrop$2;
            }

            public boolean apply(byte b) {
                boolean cont = BoxesRunTime.unboxToBoolean((Object)this.f$1.apply((Object)BoxesRunTime.boxToByte((byte)b)));
                if (cont) {
                    long l;
                    this.toDrop$1.elem = l = this.toDrop$1.elem + 1L;
                }
                return cont;
            }
        });
        return this.drop(toDrop.elem);
    }

    public ByteVector take(long n) {
        long n1 = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(n), this.size())), 0L);
        if (n1 == this.size()) {
            return this;
        }
        if (n1 == 0L) {
            return ByteVector$.MODULE$.empty();
        }
        return ByteVector.go$2(ByteVector$.MODULE$.empty(), this, n1);
    }

    public final ByteVector takeRight(long n) {
        return this.drop(this.size() - n);
    }

    public final ByteVector takeWhile(Function1<Object, Object> f) {
        LongRef toTake = LongRef.create((long)0L);
        this.foreachSPartial(new F1BB(f, toTake){
            private final Function1 f$2;
            private final LongRef toTake$1;
            {
                this.f$2 = f$21;
                this.toTake$1 = toTake$2;
            }

            public boolean apply(byte b) {
                boolean cont = BoxesRunTime.unboxToBoolean((Object)this.f$2.apply((Object)BoxesRunTime.boxToByte((byte)b)));
                if (cont) {
                    long l;
                    this.toTake$1.elem = l = this.toTake$1.elem + 1L;
                }
                return cont;
            }
        });
        return this.take(toTake.elem);
    }

    public final Tuple2<ByteVector, ByteVector> splitAt(long n) {
        return Tuple2$.MODULE$.apply((Object)this.take(n), (Object)this.drop(n));
    }

    public final ByteVector slice(long from, long until) {
        return this.drop(from).take(until - RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(from), 0L));
    }

    public Either<String, ByteVector> acquire(long n) {
        if (n <= this.size()) {
            return package$.MODULE$.Right().apply((Object)this.take(n));
        }
        return package$.MODULE$.Left().apply((Object)new java.lang.StringBuilder(56).append("cannot acquire ").append(n).append(" bytes from a vector that contains ").append(this.size()).append(" bytes").toString());
    }

    public final <A> Either<String, Tuple2<ByteVector, A>> consume(long n, Function1<ByteVector, Either<String, A>> decode) {
        return this.acquire(n).flatMap((Function1 & Serializable)toDecode -> ((Either)decode.apply(toDecode)).map((Function1 & Serializable)decoded -> Tuple2$.MODULE$.apply((Object)this.drop(n), decoded)));
    }

    public final <A> A foldLeft(A z, Function2<A, Object, A> f) {
        ObjectRef acc = ObjectRef.create(z);
        this.foreachS(new F1BU(f, acc){
            private final Function2 f$3;
            private final ObjectRef acc$1;
            {
                this.f$3 = f$22;
                this.acc$1 = acc$2;
            }

            public void apply(byte b) {
                Object object;
                this.acc$1.elem = object = this.f$3.apply(this.acc$1.elem, (Object)BoxesRunTime.boxToByte((byte)b));
                object = null;
            }
        });
        return (A)acc.elem;
    }

    public final <A> A foldRight(A z, Function2<Object, A, A> f) {
        return this.reverse().foldLeft(z, (Function2 & Serializable)(tl, h) -> f.apply((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)h)), tl));
    }

    public final <A> A foldLeftBB(A z, Function2<A, ByteBuffer, A> f) {
        return (A)ByteVector.go$3(f, package$.MODULE$.Nil().$colon$colon((Object)this), z);
    }

    public final <A> A foldRightBB(A z, Function2<ByteBuffer, A, A> f) {
        return this.reverse().foldLeftBB(z, (Function2 & Serializable)(tl, h) -> f.apply(h, tl));
    }

    public final void foreach(Function1<Object, BoxedUnit> f) {
        this.foreachS(new F1BU(f){
            private final Function1 f$7;
            {
                this.f$7 = f$24;
            }

            public void apply(byte b) {
                this.f$7.apply((Object)BoxesRunTime.boxToByte((byte)b));
            }
        });
    }

    public final void foreachS(F1BU f) {
        this.foreachV((Function1<View, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> _$3.foreach(f));
    }

    public final boolean foreachSPartial(F1BB f) {
        return this.foreachVPartial((Function1<View, Object>)(Function1 & Serializable)_$4 -> _$4.foreachPartial(f));
    }

    public final void foreachV(Function1<View, BoxedUnit> f) {
        ByteVector.go$4(f, package$.MODULE$.Nil().$colon$colon((Object)this));
    }

    public final boolean foreachVPartial(Function1<View, Object> f) {
        return ByteVector.go$5(f, package$.MODULE$.Nil().$colon$colon((Object)this));
    }

    public final boolean startsWith(ByteVector b) {
        return this.take(b.size()).$eq$eq$eq(b);
    }

    public final boolean endsWith(ByteVector b) {
        return this.takeRight(b.size()).$eq$eq$eq(b);
    }

    public final long indexOfSlice(ByteVector slice) {
        return this.indexOfSlice(slice, 0L);
    }

    public final long indexOfSlice(ByteVector slice, long from) {
        return ByteVector.go$6(slice, this.drop(from), from);
    }

    public final boolean containsSlice(ByteVector slice) {
        return this.indexOfSlice(slice) >= 0L;
    }

    public final Stream<ByteVector> grouped(long chunkSize) {
        return this.scodec$bits$ByteVector$$groupedIterator(chunkSize).toStream();
    }

    public final Iterator<ByteVector> scodec$bits$ByteVector$$groupedIterator(long chunkSize) {
        if (this.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        if (this.size() <= chunkSize) {
            return package$.MODULE$.Iterator().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ByteVector[]{this}));
        }
        return package$.MODULE$.Iterator().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ByteVector[]{this.take(chunkSize)})).$plus$plus(() -> this.groupedIterator$$anonfun$1(chunkSize));
    }

    public final byte head() {
        return this.apply(0L);
    }

    public final Option<Object> headOption() {
        return this.lift(0L);
    }

    public final ByteVector tail() {
        return this.drop(1L);
    }

    public final ByteVector init() {
        return this.dropRight(1L);
    }

    public final byte last() {
        return this.apply(this.size() - 1L);
    }

    public final Option<Object> lastOption() {
        return this.lift(this.size() - 1L);
    }

    public final ByteVector padTo(long n) {
        return this.padRight(n);
    }

    public final ByteVector padRight(long n) {
        if (n < this.size()) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(21).append("ByteVector.padRight(").append(n).append(")").toString());
        }
        return this.$plus$plus(ByteVector$.MODULE$.fill(n - this.size(), BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$));
    }

    public final ByteVector padLeft(long n) {
        if (n < this.size()) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(20).append("ByteVector.padLeft(").append(n).append(")").toString());
        }
        return ByteVector$.MODULE$.fill(n - this.size(), BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$).$plus$plus(this);
    }

    public final ByteVector map(Function1<Object, Object> f) {
        return ByteVector$.MODULE$.viewAt((Function1<Object, Object>)(Function1 & Serializable)i -> this.map$$anonfun$1(f, BoxesRunTime.unboxToLong((Object)i)), this.size());
    }

    public final ByteVector mapI(Function1<Object, Object> f) {
        return this.map((Function1<Object, Object>)f.andThen((Function1 & Serializable)_$5 -> ByteVector.mapI$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$5))));
    }

    public final ByteVector mapS(F1B f) {
        return ByteVector$.MODULE$.view(new At(f, this){
            private final F1B f$13;
            private final /* synthetic */ ByteVector $outer;
            {
                this.f$13 = f$26;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public byte apply(long i) {
                return this.f$13.apply(this.$outer.apply(i));
            }
        }, this.size());
    }

    public final ByteVector reverse() {
        return ByteVector$.MODULE$.viewAt((Function1<Object, Object>)(Function1 & Serializable)l -> this.reverse$$anonfun$1(BoxesRunTime.unboxToLong((Object)l)), this.size());
    }

    @Override
    public final ByteVector shiftLeft(long n) {
        return BitVector$.MODULE$.apply(this).shiftLeft(n).toByteVector();
    }

    @Override
    public final ByteVector shiftRight(long n, boolean signExtension) {
        return BitVector$.MODULE$.apply(this).shiftRight(n, signExtension).toByteVector();
    }

    @Override
    public final ByteVector rotateLeft(long n) {
        return BitVector$.MODULE$.apply(this).rotateLeft(n).toByteVector();
    }

    @Override
    public final ByteVector rotateRight(long n) {
        return BitVector$.MODULE$.apply(this).rotateRight(n).toByteVector();
    }

    public final ByteVector compact() {
        ByteVector byteVector = this;
        if (byteVector instanceof Chunk) {
            Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
            View view = chunk._1();
            return this;
        }
        return this.copy();
    }

    public final ByteVector partialCompact(long chunkSize) {
        ByteVector byteVector = this;
        ByteVector small = byteVector;
        if (small.size() <= chunkSize) {
            return small.compact();
        }
        if (byteVector instanceof Append) {
            Append append = ByteVector$Append$.MODULE$.unapply((Append)byteVector);
            ByteVector byteVector2 = append._1();
            ByteVector byteVector3 = append._2();
            ByteVector l = byteVector2;
            ByteVector r = byteVector3;
            return ByteVector$Append$.MODULE$.apply(l.partialCompact(chunkSize), r.partialCompact(chunkSize));
        }
        return this;
    }

    public final ByteVector copy() {
        long sz = this.size();
        if (sz <= Integer.MAX_VALUE) {
            byte[] arr = this.toArray();
            return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(new AtArray(arr), 0L, sz));
        }
        return this.take(Integer.MAX_VALUE).copy().$plus$plus(this.drop(Integer.MAX_VALUE).copy());
    }

    public final byte[] toArray() {
        byte[] buf = new byte[ByteVector$.MODULE$.toIntSize(this.size())];
        this.copyToArray(buf, 0);
        return buf;
    }

    public final byte[] toArrayUnsafe() {
        ByteVector byteVector = this;
        if (byteVector instanceof Chunk) {
            View view;
            Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
            View v = view = chunk._1();
            return v.toArrayUnsafe();
        }
        return this.toArray();
    }

    public final void copyToArray(byte[] xs, int start) {
        IntRef i = IntRef.create((int)start);
        this.foreachV((Function1<View, BoxedUnit>)(JProcedure1 & Serializable)v -> {
            int n;
            v.copyToArray(xs, i$1.elem);
            i$1.elem = n = i$1.elem + ByteVector$.MODULE$.toIntSize(v.size());
        });
    }

    public final void copyToArray(byte[] xs, int start, long offset, int size) {
        LongRef i = LongRef.create((long)0L);
        LongRef voffset = LongRef.create((long)0L);
        this.foreachV((Function1<View, BoxedUnit>)(JProcedure1 & Serializable)v -> {
            if (i$2.elem < (long)size) {
                long l;
                long reloff = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(offset - voffset$1.elem), 0L);
                if (voffset$1.elem >= offset || reloff < v.size()) {
                    long l2;
                    long sz = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)size - i$2.elem), v.size() - reloff);
                    v.copyToArray(xs, ByteVector$.MODULE$.toIntSize((long)start + i$2.elem), reloff, ByteVector$.MODULE$.toIntSize(sz));
                    i$2.elem = l2 = i$2.elem + sz;
                }
                voffset$1.elem = l = voffset$1.elem + v.size();
                return;
            }
        });
    }

    public final int copyToBuffer(ByteBuffer buffer) {
        IntRef copied = IntRef.create((int)0);
        this.foreachVPartial((Function1<View, Object>)(Function1 & Serializable)v -> {
            int n;
            int copiedFromView = v.copyToBuffer(buffer);
            copied$1.elem = n = copied$1.elem + copiedFromView;
            return (long)copiedFromView == v.size();
        });
        return copied.elem;
    }

    public final void copyToStream(OutputStream s) {
        this.foreachV((Function1<View, BoxedUnit>)(JProcedure1 & Serializable)_$6 -> _$6.copyToStream(s));
    }

    public final InputStream toInputStream() {
        return new ByteVectorInputStream(this);
    }

    public final scala.collection.immutable.IndexedSeq<Object> toIndexedSeq() {
        return new scala.collection.immutable.IndexedSeq<Object>(this){
            private final int length;
            private final /* synthetic */ ByteVector $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
                scala.collection.immutable.Iterable.$init$((scala.collection.immutable.Iterable)this);
                PartialFunction.$init$((PartialFunction)this);
                SeqOps.$init$((SeqOps)this);
                Seq.$init$((Seq)this);
                scala.collection.immutable.Seq.$init$((scala.collection.immutable.Seq)this);
                IndexedSeqOps.$init$((IndexedSeqOps)this);
                IndexedSeq.$init$((IndexedSeq)this);
                scala.collection.immutable.IndexedSeqOps.$init$((scala.collection.immutable.IndexedSeqOps)this);
                scala.collection.immutable.IndexedSeq.$init$((scala.collection.immutable.IndexedSeq)this);
                this.length = ByteVector$.MODULE$.toIntSize($outer.size());
            }

            public scala.collection.immutable.IndexedSeq scala$collection$SeqOps$$super$concat(IterableOnce suffix) {
                return (scala.collection.immutable.IndexedSeq)IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
            }

            public int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
                return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
            }

            public int scala$collection$SeqOps$$super$sizeCompare(Iterable that) {
                return IterableOps.sizeCompare$((IterableOps)this, (Iterable)that);
            }

            public scala.collection.immutable.IndexedSeq scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
                return (scala.collection.immutable.IndexedSeq)IndexedSeqOps.slice$((IndexedSeqOps)this, (int)from, (int)until);
            }

            public boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
                return Seq.canEqual$((Seq)this, (Object)that);
            }

            public boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
                return SeqOps.sameElements$((SeqOps)this, (IterableOnce)that);
            }

            public int length() {
                return this.length;
            }

            public byte apply(int i) {
                return this.$outer.apply(i);
            }

            public Object foldRight(Object z, Function2 op) {
                return this.$outer.foldRight(z, op);
            }
        };
    }

    public final scala.collection.immutable.Seq<Object> toSeq() {
        return this.toIndexedSeq();
    }

    public final Iterable<Object> toIterable() {
        return this.toIndexedSeq();
    }

    public final BitVector toBitVector() {
        return BitVector$.MODULE$.apply(this);
    }

    public final BitVector bits() {
        return this.toBitVector();
    }

    public final ByteVector buffer() {
        return this.bufferBy(1024);
    }

    public final ByteVector bufferBy(int chunkSize) {
        ByteVector byteVector = this;
        if (byteVector instanceof Buffer) {
            Buffer b = (Buffer)byteVector;
            if (b.lastChunk().length >= chunkSize) {
                return b;
            }
            return b.rebuffer(chunkSize);
        }
        return ByteVector$Buffer$.MODULE$.apply(new AtomicLong(0L), 0L, this, new byte[chunkSize], 0);
    }

    public ByteVector unbuffer() {
        return this;
    }

    public final ByteBuffer toByteBuffer() {
        ByteVector byteVector = this;
        if (byteVector instanceof Chunk) {
            View view;
            Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
            View v = view = chunk._1();
            return v.asByteBuffer();
        }
        return ByteBuffer.wrap(this.toArray());
    }

    public final ByteBuffer toByteBufferUnsafe() {
        ByteVector byteVector = this;
        if (byteVector instanceof Chunk) {
            View view;
            Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
            View v = view = chunk._1();
            return v.asByteBufferUnsafe();
        }
        return ByteBuffer.wrap(this.toArray());
    }

    public final String toBin() {
        return this.toBin(Bases$Alphabets$Binary$.MODULE$);
    }

    public final String toBin(Bases.BinaryAlphabet alphabet) {
        StringBuilder bldr = new StringBuilder();
        this.foreachS(new F1BU(bldr, alphabet){
            private final StringBuilder bldr$1;
            private final Bases.BinaryAlphabet alphabet$1;
            {
                this.bldr$1 = bldr$2;
                this.alphabet$1 = alphabet$5;
            }

            public void apply(byte b) {
                for (int n = 7; n >= 0; --n) {
                    int idx = 1 & b >> n;
                    this.bldr$1.append(this.alphabet$1.toChar(idx));
                }
            }
        });
        return bldr.toString();
    }

    public final String toHex() {
        return this.toHex(Bases$Alphabets$HexLowercase$.MODULE$);
    }

    public final String toHex(Bases.HexAlphabet alphabet) {
        char[] out = new char[(int)this.size() * 2];
        IntRef i = IntRef.create((int)0);
        this.foreachV((Function1<View, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
            View view = x$1;
            if (view != null) {
                View view2 = ByteVector$View$.MODULE$.unapply(view);
                At at = view2._1();
                long l = view2._2();
                long l2 = view2._3();
                if (at instanceof AtArray) {
                    AtArray atArr = (AtArray)at;
                    long offset = l;
                    long length = l2;
                    long end = offset + length;
                    for (long j = offset; j < end; ++j) {
                        ByteVector.scodec$bits$ByteVector$$_$update$1(out, i, alphabet, atArr.apply(j));
                    }
                    return;
                }
                if (at instanceof AtByteBuffer) {
                    AtByteBuffer atByteBuffer = (AtByteBuffer)at;
                    long offset = l;
                    long length = l2;
                    ByteBuffer buf = atByteBuffer.buf().duplicate();
                    buf.position((int)offset);
                    buf.limit((int)(offset + length));
                    while (buf.hasRemaining()) {
                        ByteVector.scodec$bits$ByteVector$$_$update$1(out, i, alphabet, buf.get());
                    }
                    return;
                }
            }
            View other = view;
            other.foreach(new F1BU(out, i, alphabet, this){
                private final char[] out$3;
                private final IntRef i$6;
                private final Bases.HexAlphabet alphabet$7;
                {
                    this.out$3 = out$4;
                    this.i$6 = i$7;
                    this.alphabet$7 = alphabet$9;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                }

                public void apply(byte b) {
                    ByteVector.scodec$bits$ByteVector$$_$update$1(this.out$3, this.i$6, this.alphabet$7, b);
                }
            });
        });
        return new String(out);
    }

    public final String toHexDump() {
        return HexDumpFormat$.MODULE$.NoAnsi().render(this);
    }

    public final String toHexDumpColorized() {
        return HexDumpFormat$.MODULE$.Default().render(this);
    }

    public final void printHexDump() {
        HexDumpFormat$.MODULE$.Default().print(this);
    }

    public final String toBase16() {
        return this.toHex();
    }

    public final String toBase16(Bases.HexAlphabet alphabet) {
        return this.toHex(alphabet);
    }

    public final String toBase32() {
        return this.toBase32(Bases$Alphabets$Base32$.MODULE$);
    }

    private final int bitsAtOffset(byte[] bytes, long bitIndex, int length) {
        int i = (int)(bitIndex / 8L);
        if (i >= bytes.length) {
            return 0;
        }
        int off = (int)(bitIndex - (long)(i * 8));
        int mask = (1 << length) - 1 << 8 - length;
        int half = bytes[i] << off & mask;
        int full = off + length <= 8 || i + 1 >= bytes.length ? half : half | (bytes[i + 1] & (mask << 8 - off & 0xFF)) >>> 8 - off;
        return full >>> 8 - length;
    }

    public final String toBase32(Bases.Base32Alphabet alphabet) {
        int bitsPerChar = 5;
        int bytesPerGroup = 5;
        int charsPerGroup = bytesPerGroup * 8 / bitsPerChar;
        byte[] bytes = this.toArray();
        CharBuffer bldr = CharBuffer.allocate((bytes.length + bytesPerGroup - 1) / bytesPerGroup * charsPerGroup);
        long bidx = 0L;
        while (bidx / 8L < (long)bytes.length) {
            char c = alphabet.toChar(this.bitsAtOffset(bytes, bidx, bitsPerChar));
            bldr.append(c);
            bidx += (long)bitsPerChar;
        }
        if (alphabet.pad() != (char)0) {
            int padLen = ((bytes.length + bitsPerChar - 1) / bitsPerChar * bitsPerChar - bytes.length) * 8 / bitsPerChar;
            for (int i = 0; i < padLen; ++i) {
                bldr.append(alphabet.pad());
            }
        }
        return bldr.flip().toString();
    }

    public final String toBase58() {
        return this.toBase58(Bases$Alphabets$Base58$.MODULE$);
    }

    public final String toBase58(Bases.Alphabet alphabet) {
        if (this.isEmpty()) {
            return "";
        }
        BigInt ZERO = package$.MODULE$.BigInt().apply(0);
        BigInt RADIX = package$.MODULE$.BigInt().apply(58L);
        List ones = (List)package$.MODULE$.List().fill((int)this.takeWhile((Function1<Object, Object>)(Function1 & Serializable)_$7 -> ByteVector.$anonfun$1(BoxesRunTime.unboxToByte((Object)_$7))).length(), ByteVector::$anonfun$2);
        return ByteVector.go$7(ZERO, ones, RADIX, alphabet, package$.MODULE$.BigInt().apply(1, this.toArray()), package$.MODULE$.List().empty());
    }

    public final String toBase64() {
        return this.toBase64(Bases$Alphabets$Base64$.MODULE$);
    }

    public final String toBase64(Bases.Base64Alphabet alphabet) {
        int idx;
        byte[] bytes = this.toArray();
        CharBuffer bldr = CharBuffer.allocate((bytes.length + 2) / 3 * 4);
        int mod = bytes.length % 3;
        for (idx = 0; idx < bytes.length - mod; idx += 3) {
            int buffer = (bytes[idx] & 0xFF) << 16 | (bytes[idx + 1] & 0xFF) << 8 | bytes[idx + 2] & 0xFF;
            int fourth = buffer & 0x3F;
            int third = (buffer >>= 6) & 0x3F;
            int second = (buffer >>= 6) & 0x3F;
            int first = buffer >>= 6;
            bldr.append(alphabet.toChar(first)).append(alphabet.toChar(second)).append(alphabet.toChar(third)).append(alphabet.toChar(fourth));
        }
        if (mod == 1) {
            int buffer = (bytes[idx] & 0xFF) << 4;
            int second = buffer & 0x3F;
            int first = buffer >>= 6;
            bldr.append(alphabet.toChar(first)).append(alphabet.toChar(second));
            if (alphabet.pad() != (char)0) {
                bldr.append(alphabet.pad()).append(alphabet.pad());
            }
        } else if (mod == 2) {
            int buffer = (bytes[idx] & 0xFF) << 10 | (bytes[idx + 1] & 0xFF) << 2;
            int third = buffer & 0x3F;
            int second = (buffer >>= 6) & 0x3F;
            int first = buffer >>= 6;
            bldr.append(alphabet.toChar(first)).append(alphabet.toChar(second)).append(alphabet.toChar(third));
            if (alphabet.pad() != (char)0) {
                bldr.append(alphabet.pad());
            }
        }
        return bldr.flip().toString();
    }

    public final String toBase64NoPad() {
        return this.toBase64(Bases$Alphabets$Base64NoPad$.MODULE$);
    }

    public final String toBase64Url() {
        return this.toBase64(Bases$Alphabets$Base64Url$.MODULE$);
    }

    public final String toBase64UrlNoPad() {
        return this.toBase64(Bases$Alphabets$Base64UrlNoPad$.MODULE$);
    }

    public final byte toByte(boolean signed) {
        return this.bits().toByte(signed);
    }

    public boolean toByte$default$1() {
        return true;
    }

    public final short toShort(boolean signed, ByteOrdering ordering) {
        return this.bits().toShort(signed, ordering);
    }

    public boolean toShort$default$1() {
        return true;
    }

    public ByteOrdering toShort$default$2() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final int toInt(boolean signed, ByteOrdering ordering) {
        return this.bits().toInt(signed, ordering);
    }

    public boolean toInt$default$1() {
        return true;
    }

    public ByteOrdering toInt$default$2() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final long toLong(boolean signed, ByteOrdering ordering) {
        return this.bits().toLong(signed, ordering);
    }

    public boolean toLong$default$1() {
        return true;
    }

    public ByteOrdering toLong$default$2() {
        return ByteOrdering$BigEndian$.MODULE$;
    }

    public final UUID toUUID() {
        if (this.size() != 16L) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(60).append("Cannot convert ByteVector of size ").append(this.size()).append(" to UUID; must be 16 bytes").toString());
        }
        ByteBuffer byteBuffer = this.toByteBuffer();
        long mostSignificant = byteBuffer.getLong();
        long leastSignificant = byteBuffer.getLong();
        return new UUID(mostSignificant, leastSignificant);
    }

    public final Either<CharacterCodingException, String> decodeString(Charset charset) {
        Left left;
        CharsetDecoder decoder = charset.newDecoder();
        try {
            left = package$.MODULE$.Right().apply((Object)decoder.decode(this.toByteBuffer()).toString());
        }
        catch (CharacterCodingException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public final String decodeStringLenient(boolean replaceMalformedInput, boolean replaceUnmappableChars, String replacement, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder().replaceWith(replacement).onMalformedInput(replaceMalformedInput ? CodingErrorAction.REPLACE : CodingErrorAction.IGNORE).onUnmappableCharacter(replaceUnmappableChars ? CodingErrorAction.REPLACE : CodingErrorAction.IGNORE);
        return decoder.decode(this.toByteBuffer()).toString();
    }

    public boolean decodeStringLenient$default$1() {
        return true;
    }

    public boolean decodeStringLenient$default$2() {
        return true;
    }

    public String decodeStringLenient$default$3() {
        return "\ufffd";
    }

    public final Either<CharacterCodingException, String> decodeUtf8() {
        return this.decodeString(Charset.forName("UTF-8"));
    }

    public final String decodeUtf8Lenient() {
        return this.decodeStringLenient(this.decodeStringLenient$default$1(), this.decodeStringLenient$default$2(), this.decodeStringLenient$default$3(), Charset.forName("UTF-8"));
    }

    public final Either<CharacterCodingException, String> decodeAscii() {
        return this.decodeString(Charset.forName("US-ASCII"));
    }

    public final String decodeAsciiLenient() {
        return this.decodeStringLenient(this.decodeStringLenient$default$1(), this.decodeStringLenient$default$2(), this.decodeStringLenient$default$3(), Charset.forName("US-ASCII"));
    }

    @Override
    public final ByteVector not() {
        return this.mapS(new F1B(){

            public byte apply(byte b) {
                return ~b;
            }
        });
    }

    @Override
    public final ByteVector or(ByteVector other) {
        return this.zipWithS(other, new F2B(){

            public byte apply(byte b, byte b2) {
                return (byte)(b | b2);
            }
        });
    }

    @Override
    public final ByteVector and(ByteVector other) {
        return this.zipWithS(other, new F2B(){

            public byte apply(byte b, byte b2) {
                return (byte)(b & b2);
            }
        });
    }

    @Override
    public final ByteVector xor(ByteVector other) {
        return this.zipWithS(other, new F2B(){

            public byte apply(byte b, byte b2) {
                return (byte)(b ^ b2);
            }
        });
    }

    public final ByteVector zipWith(ByteVector other, Function2<Object, Object, Object> f) {
        return this.zipWithS(other, new F2B(f){
            private final Function2 f$14;
            {
                this.f$14 = f$27;
            }

            public byte apply(byte b, byte b2) {
                return BoxesRunTime.unboxToByte((Object)this.f$14.apply((Object)BoxesRunTime.boxToByte((byte)b), (Object)BoxesRunTime.boxToByte((byte)b2)));
            }
        });
    }

    public final ByteVector zipWith2(ByteVector other, ByteVector other2, Function3<Object, Object, Object, Object> f) {
        return this.zipWithS(other, other2, new F3B(f){
            private final Function3 f$15;
            {
                this.f$15 = f$28;
            }

            public byte apply(byte b, byte b2, byte b3) {
                return BoxesRunTime.unboxToByte((Object)this.f$15.apply((Object)BoxesRunTime.boxToByte((byte)b), (Object)BoxesRunTime.boxToByte((byte)b2), (Object)BoxesRunTime.boxToByte((byte)b3)));
            }
        });
    }

    public final ByteVector zipWith3(ByteVector other, ByteVector other2, ByteVector other3, Function4<Object, Object, Object, Object, Object> f) {
        return this.zipWithS(other, other2, other3, new F4B(f){
            private final Function4 f$16;
            {
                this.f$16 = f$29;
            }

            public byte apply(byte b, byte b2, byte b3, byte b4) {
                return BoxesRunTime.unboxToByte((Object)this.f$16.apply((Object)BoxesRunTime.boxToByte((byte)b), (Object)BoxesRunTime.boxToByte((byte)b2), (Object)BoxesRunTime.boxToByte((byte)b3), (Object)BoxesRunTime.boxToByte((byte)b4)));
            }
        });
    }

    public final ByteVector zipWithS(ByteVector other, F2B f) {
        At at = new At(f, other, this){
            private final F2B f$17;
            private final ByteVector other$1;
            private final /* synthetic */ ByteVector $outer;
            {
                this.f$17 = f$30;
                this.other$1 = other$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public byte apply(long i) {
                return this.f$17.apply(this.$outer.apply(i), this.other$1.apply(i));
            }
        };
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(at, 0L, RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(this.size()), other.size())));
    }

    public final ByteVector zipWithS(ByteVector other, ByteVector other2, F3B f) {
        At at = new At(f, other, other2, this){
            private final F3B f$18;
            private final ByteVector other$2;
            private final ByteVector other2$1;
            private final /* synthetic */ ByteVector $outer;
            {
                this.f$18 = f$31;
                this.other$2 = other$6;
                this.other2$1 = other2$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public byte apply(long i) {
                return this.f$18.apply(this.$outer.apply(i), this.other$2.apply(i), this.other2$1.apply(i));
            }
        };
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(at, 0L, RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(this.size()), other.size())), other2.size())));
    }

    public final ByteVector zipWithS(ByteVector other, ByteVector other2, ByteVector other3, F4B f) {
        At at = new At(f, other, other2, other3, this){
            private final F4B f$19;
            private final ByteVector other$3;
            private final ByteVector other2$2;
            private final ByteVector other3$1;
            private final /* synthetic */ ByteVector $outer;
            {
                this.f$19 = f$32;
                this.other$3 = other$7;
                this.other2$2 = other2$4;
                this.other3$1 = other3$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public byte apply(long i) {
                return this.f$19.apply(this.$outer.apply(i), this.other$3.apply(i), this.other2$2.apply(i), this.other3$1.apply(i));
            }
        };
        return ByteVector$Chunk$.MODULE$.apply(ByteVector$View$.MODULE$.apply(at, 0L, RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(this.size()), other.size())), other2.size())), other3.size())));
    }

    public final ByteVector zipWithI(ByteVector other, Function2<Object, Object, Object> op) {
        return this.zipWith(other, (Function2<Object, Object, Object>)(Function2 & Serializable)(x$1, x$2) -> ByteVector.zipWithI$$anonfun$1(op, BoxesRunTime.unboxToByte((Object)x$1), BoxesRunTime.unboxToByte((Object)x$2)));
    }

    public final ByteVector zipWithI2(ByteVector other, ByteVector other2, Function3<Object, Object, Object, Object> op) {
        return this.zipWith2(other, other2, (Function3<Object, Object, Object, Object>)(Function3 & Serializable)(x$1, x$2, x$3) -> ByteVector.zipWithI2$$anonfun$1(op, BoxesRunTime.unboxToByte((Object)x$1), BoxesRunTime.unboxToByte((Object)x$2), BoxesRunTime.unboxToByte((Object)x$3)));
    }

    public final ByteVector zipWithI3(ByteVector other, ByteVector other2, ByteVector other3, Function4<Object, Object, Object, Object, Object> op) {
        return this.zipWith3(other, other2, other3, (Function4<Object, Object, Object, Object, Object>)(Function4 & Serializable)(x$1, x$2, x$3, x$4) -> ByteVector.zipWithI3$$anonfun$1(op, BoxesRunTime.unboxToByte((Object)x$1), BoxesRunTime.unboxToByte((Object)x$2), BoxesRunTime.unboxToByte((Object)x$3), BoxesRunTime.unboxToByte((Object)x$4)));
    }

    public int hashCode() {
        Object object = this.hashCode$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.hashCode$lzyINIT1());
    }

    private Object hashCode$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hashCode$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        long chunkSize = 65536L;
                        n = BoxesRunTime.boxToInteger((int)ByteVector.go$8(chunkSize, this, MurmurHash3$.MODULE$.stringHash("ByteVector"), 1));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hashCode$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final boolean $eq$eq$eq(ByteVector other) {
        if (this == other) {
            return true;
        }
        long s = this.size();
        if (s != other.size()) {
            return false;
        }
        return this.go$9(s, other, 0L);
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof ByteVector) {
            ByteVector that = (ByteVector)object;
            return this.$eq$eq$eq(that);
        }
        return false;
    }

    public boolean equalsConstantTime(ByteVector other) {
        if (this.size() != other.size()) {
            return false;
        }
        int result = 0;
        int idx = 0;
        long s = this.size();
        while ((long)idx < s) {
            result |= (byte)(this.apply(Int$.MODULE$.int2long(idx)) ^ other.apply(Int$.MODULE$.int2long(idx)));
            ++idx;
        }
        return result == 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "ByteVector(empty)";
        }
        if (this.size() < 512L) {
            return new java.lang.StringBuilder(22).append("ByteVector(").append(this.size()).append(" bytes, 0x").append(this.toHex()).append(")").toString();
        }
        return new java.lang.StringBuilder(21).append("ByteVector(").append(this.size()).append(" bytes, #").append(this.hashCode()).append(")").toString();
    }

    public String pretty(String prefix) {
        ByteVector byteVector = this;
        if (byteVector instanceof Append) {
            Append append = ByteVector$Append$.MODULE$.unapply((Append)byteVector);
            ByteVector byteVector2 = append._1();
            ByteVector byteVector3 = append._2();
            ByteVector l = byteVector2;
            ByteVector r = byteVector3;
            return new java.lang.StringBuilder(14).append(prefix).append("bytes:append\n").append(l.pretty(new java.lang.StringBuilder(2).append(prefix).append("  ").toString())).append("\n").append(r.pretty(new java.lang.StringBuilder(2).append(prefix).append("  ").toString())).toString();
        }
        if (byteVector instanceof Chunks) {
            Append append;
            Chunks chunks = ByteVector$Chunks$.MODULE$.unapply((Chunks)byteVector);
            Append c = append = chunks._1();
            return new java.lang.StringBuilder(15).append(prefix).append("bytes:chunks ").append(this.size()).append("\n").append(c.left().pretty(new java.lang.StringBuilder(2).append(prefix).append("  ").toString())).append("\n").append(c.right().pretty(new java.lang.StringBuilder(2).append(prefix).append("  ").toString())).toString();
        }
        if (byteVector instanceof Buffer) {
            Buffer b = (Buffer)byteVector;
            return new java.lang.StringBuilder(15).append(prefix).append("bytes:buffer ").append(this.size()).append("\n").append(b.hd().pretty(new java.lang.StringBuilder(2).append(prefix).append("  ").toString())).append("\n").append(b.lastBytes().pretty(new java.lang.StringBuilder(2).append(prefix).append("  ").toString())).toString();
        }
        if (byteVector instanceof Chunk) {
            Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
            View view = chunk._1();
            return new java.lang.StringBuilder(0).append(prefix).append(this.size() < 16L ? new java.lang.StringBuilder(2).append("0x").append(this.toHex()).toString() : new java.lang.StringBuilder(1).append("#").append(this.hashCode()).toString()).toString();
        }
        throw new MatchError((Object)byteVector);
    }

    private void checkIndex(long n) {
        if (n < 0L || n >= this.size()) {
            throw new IndexOutOfBoundsException(new java.lang.StringBuilder(25).append("invalid index: ").append(n).append(" for size ").append(this.size()).toString());
        }
    }

    public final Object writeReplace() {
        return new SerializationProxy(this.toArray());
    }

    public int compare(ByteVector that) {
        if (this == that) {
            return 0;
        }
        long thisLength = this.length();
        long thatLength = that.length();
        long commonLength = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(thisLength), thatLength);
        int i = 0;
        while ((long)i < commonLength) {
            int cmp = new RichInt(Predef$.MODULE$.intWrapper(this.apply(i) & 0xFF)).compare((Object)BoxesRunTime.boxToInteger((int)(that.apply(i) & 0xFF)));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        if (thisLength < thatLength) {
            return -1;
        }
        if (thisLength > thatLength) {
            return 1;
        }
        return 0;
    }

    private static final ByteVector go$1(ByteVector cur, long n1, List accR) {
        ByteVector byteVector;
        while (true) {
            if ((byteVector = cur) instanceof Chunk) {
                View view;
                Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
                View bs = view = chunk._1();
                return ((ByteVector)accR.foldLeft((Object)ByteVector$Chunk$.MODULE$.apply(bs.drop(n1)), (Function2 & Serializable)(_$1, _$2) -> _$1.$plus$plus((ByteVector)_$2))).unbuffer();
            }
            if (byteVector instanceof Append) {
                Append append = ByteVector$Append$.MODULE$.unapply((Append)byteVector);
                ByteVector byteVector2 = append._1();
                ByteVector byteVector3 = append._2();
                ByteVector l = byteVector2;
                ByteVector r = byteVector3;
                if (n1 > l.size()) {
                    ByteVector byteVector4 = r;
                    long l2 = n1 - l.size();
                    cur = byteVector4;
                    n1 = l2;
                    continue;
                }
                ByteVector byteVector5 = l;
                List list = accR.$colon$colon((Object)r);
                cur = byteVector5;
                accR = list;
                continue;
            }
            if (byteVector instanceof Buffer) {
                Buffer b = (Buffer)byteVector;
                if (n1 > b.hd().size()) {
                    ByteVector byteVector6 = b.lastBytes();
                    long l = n1 - b.hd().size();
                    cur = byteVector6;
                    n1 = l;
                    continue;
                }
                ByteVector byteVector7 = b.hd();
                ByteVector byteVector8 = b.lastBytes();
                List list = accR.$colon$colon((Object)byteVector8);
                cur = byteVector7;
                accR = list;
                continue;
            }
            if (!(byteVector instanceof Chunks)) break;
            Chunks c = (Chunks)byteVector;
            cur = c.chunks();
        }
        throw new MatchError((Object)byteVector);
    }

    private static final ByteVector go$2(ByteVector accL, ByteVector cur, long n1) {
        ByteVector byteVector;
        while (true) {
            if ((byteVector = cur) instanceof Chunk) {
                View view;
                Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
                View bs = view = chunk._1();
                return accL.$plus$plus(ByteVector$Chunk$.MODULE$.apply(bs.take(n1)));
            }
            if (byteVector instanceof Append) {
                Append append = ByteVector$Append$.MODULE$.unapply((Append)byteVector);
                ByteVector byteVector2 = append._1();
                ByteVector byteVector3 = append._2();
                ByteVector l = byteVector2;
                ByteVector r = byteVector3;
                if (n1 > l.size()) {
                    ByteVector byteVector4 = accL.$plus$plus(l);
                    ByteVector byteVector5 = r;
                    long l2 = n1 - l.size();
                    accL = byteVector4;
                    cur = byteVector5;
                    n1 = l2;
                    continue;
                }
                cur = l;
                continue;
            }
            if (byteVector instanceof Chunks) {
                Chunks c = (Chunks)byteVector;
                cur = c.chunks();
                continue;
            }
            if (!(byteVector instanceof Buffer)) break;
            Buffer b = (Buffer)byteVector;
            cur = b.unbuffer();
        }
        throw new MatchError((Object)byteVector);
    }

    private static final Object go$3(Function2 f$5, List rem, Object a) {
        List list;
        while ((list = rem) instanceof .colon.colon) {
            Chunks chunks;
            Append append;
            .colon.colon colon2 = (.colon.colon)list;
            ByteVector byteVector = (ByteVector)colon2.head();
            List list2 = colon2.next$access$1();
            if (byteVector instanceof Chunk) {
                List rem2;
                View view;
                Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
                View bs = view = chunk._1();
                List list3 = rem2 = list2;
                Object object = f$5.apply(a, (Object)bs.at().asByteBuffer(bs.offset(), (int)bs.size()));
                rem = list3;
                a = object;
                continue;
            }
            if (byteVector instanceof Append) {
                Append append2 = ByteVector$Append$.MODULE$.unapply((Append)byteVector);
                ByteVector byteVector2 = append2._1();
                ByteVector byteVector3 = append2._2();
                ByteVector l = byteVector2;
                ByteVector r = byteVector3;
                List rem3 = list2;
                rem = rem3.$colon$colon((Object)r).$colon$colon((Object)l);
                continue;
            }
            if (byteVector instanceof Chunks && (append = (chunks = ByteVector$Chunks$.MODULE$.unapply((Chunks)byteVector))._1()) != null) {
                Append append3 = ByteVector$Append$.MODULE$.unapply(append);
                ByteVector byteVector4 = append3._1();
                ByteVector byteVector5 = append3._2();
                ByteVector l = byteVector4;
                ByteVector r = byteVector5;
                List rem4 = list2;
                rem = rem4.$colon$colon((Object)r).$colon$colon((Object)l);
                continue;
            }
            if (!(byteVector instanceof Buffer)) break;
            Buffer b = (Buffer)byteVector;
            List rem5 = list2;
            ByteVector byteVector6 = b.unbuffer();
            rem = rem5.$colon$colon((Object)byteVector6);
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        List list4 = list;
        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
            return a;
        }
        throw new MatchError((Object)list);
    }

    private static final void go$4(Function1 f$10, List rem) {
        List list;
        while ((list = rem) instanceof .colon.colon) {
            Chunks chunks;
            Append append;
            .colon.colon colon2 = (.colon.colon)list;
            ByteVector byteVector = (ByteVector)colon2.head();
            List list2 = colon2.next$access$1();
            if (byteVector instanceof Chunk) {
                View view;
                Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
                View bs = view = chunk._1();
                List rem2 = list2;
                f$10.apply((Object)bs);
                rem = rem2;
                continue;
            }
            if (byteVector instanceof Append) {
                Append append2 = ByteVector$Append$.MODULE$.unapply((Append)byteVector);
                ByteVector byteVector2 = append2._1();
                ByteVector byteVector3 = append2._2();
                ByteVector l = byteVector2;
                ByteVector r = byteVector3;
                List rem3 = list2;
                rem = rem3.$colon$colon((Object)r).$colon$colon((Object)l);
                continue;
            }
            if (byteVector instanceof Chunks && (append = (chunks = ByteVector$Chunks$.MODULE$.unapply((Chunks)byteVector))._1()) != null) {
                Append append3 = ByteVector$Append$.MODULE$.unapply(append);
                ByteVector byteVector4 = append3._1();
                ByteVector byteVector5 = append3._2();
                ByteVector l = byteVector4;
                ByteVector r = byteVector5;
                List rem4 = list2;
                rem = rem4.$colon$colon((Object)r).$colon$colon((Object)l);
                continue;
            }
            if (!(byteVector instanceof Buffer)) break;
            Buffer b = (Buffer)byteVector;
            List rem5 = list2;
            ByteVector byteVector6 = b.unbuffer();
            rem = rem5.$colon$colon((Object)byteVector6);
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        List list3 = list;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            return;
        }
        throw new MatchError((Object)list);
    }

    private static final boolean go$5(Function1 f$11, List rem) {
        List list;
        while ((list = rem) instanceof .colon.colon) {
            Chunks chunks;
            Append append;
            .colon.colon colon2 = (.colon.colon)list;
            ByteVector byteVector = (ByteVector)colon2.head();
            List list2 = colon2.next$access$1();
            if (byteVector instanceof Chunk) {
                View view;
                Chunk chunk = ByteVector$Chunk$.MODULE$.unapply((Chunk)byteVector);
                View bs = view = chunk._1();
                List rem2 = list2;
                if (BoxesRunTime.unboxToBoolean((Object)f$11.apply((Object)bs))) {
                    rem = rem2;
                    continue;
                }
                return false;
            }
            if (byteVector instanceof Append) {
                Append append2 = ByteVector$Append$.MODULE$.unapply((Append)byteVector);
                ByteVector byteVector2 = append2._1();
                ByteVector byteVector3 = append2._2();
                ByteVector l = byteVector2;
                ByteVector r = byteVector3;
                List rem3 = list2;
                rem = rem3.$colon$colon((Object)r).$colon$colon((Object)l);
                continue;
            }
            if (byteVector instanceof Chunks && (append = (chunks = ByteVector$Chunks$.MODULE$.unapply((Chunks)byteVector))._1()) != null) {
                Append append3 = ByteVector$Append$.MODULE$.unapply(append);
                ByteVector byteVector4 = append3._1();
                ByteVector byteVector5 = append3._2();
                ByteVector l = byteVector4;
                ByteVector r = byteVector5;
                List rem4 = list2;
                rem = rem4.$colon$colon((Object)r).$colon$colon((Object)l);
                continue;
            }
            if (!(byteVector instanceof Buffer)) break;
            Buffer b = (Buffer)byteVector;
            List rem5 = list2;
            ByteVector byteVector6 = b.unbuffer();
            rem = rem5.$colon$colon((Object)byteVector6);
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        List list3 = list;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            return true;
        }
        throw new MatchError((Object)list);
    }

    private static final long go$6(ByteVector slice$1, ByteVector b, long idx) {
        while (!b.startsWith(slice$1)) {
            if (b.isEmpty()) {
                return -1L;
            }
            ByteVector byteVector = b.tail();
            long l = idx + 1L;
            b = byteVector;
            idx = l;
        }
        return idx;
    }

    private final IterableOnce groupedIterator$$anonfun$1(long chunkSize$1) {
        return this.drop(chunkSize$1).scodec$bits$ByteVector$$groupedIterator(chunkSize$1);
    }

    private final /* synthetic */ byte map$$anonfun$1(Function1 f$12, long i) {
        return BoxesRunTime.unboxToByte((Object)f$12.apply((Object)BoxesRunTime.boxToByte((byte)this.apply(i))));
    }

    private static final /* synthetic */ byte mapI$$anonfun$1(int _$5) {
        return (byte)_$5;
    }

    private final /* synthetic */ byte reverse$$anonfun$1(long l) {
        return this.apply(this.size() - l - 1L);
    }

    public static final void scodec$bits$ByteVector$$_$update$1(char[] out$1, IntRef i$3, Bases.HexAlphabet alphabet$2, byte b) {
        int n;
        out$1[i$3.elem] = alphabet$2.toChar(b >> 4 & 0xF);
        out$1[i$3.elem + 1] = alphabet$2.toChar(b & 0xF);
        i$3.elem = n = i$3.elem + 2;
    }

    private static final /* synthetic */ boolean $anonfun$1(byte _$7) {
        return _$7 == 0;
    }

    private static final char $anonfun$2() {
        return '1';
    }

    private static final String go$7(BigInt ZERO$1, List ones$1, BigInt RADIX$1, Bases.Alphabet alphabet$3, BigInt value, List chars) {
        BigInt bigInt;
        while (!BoxesRunTime.equals((Object)ZERO$1, (Object)(bigInt = value))) {
            Tuple2 tuple2 = value.$div$percent(RADIX$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BigInt div = (BigInt)tuple2._1();
            BigInt rem = (BigInt)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)div, (Object)rem);
            BigInt div2 = (BigInt)tuple22._1();
            BigInt rem2 = (BigInt)tuple22._2();
            BigInt bigInt2 = div2;
            char c = alphabet$3.toChar(rem2.toInt());
            List list = (List)chars.$plus$colon((Object)BoxesRunTime.boxToCharacter((char)c));
            value = bigInt2;
            chars = list;
        }
        return ((IterableOnceOps)ones$1.$plus$plus((IterableOnce)chars)).mkString();
    }

    private static final /* synthetic */ byte zipWithI$$anonfun$1(Function2 op$1, byte x$1, byte x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)x$1), (Object)BoxesRunTime.boxToByte((byte)x$2));
        if (tuple2 != null) {
            byte l = BoxesRunTime.unboxToByte((Object)tuple2._1());
            byte r = BoxesRunTime.unboxToByte((Object)tuple2._2());
            return (byte)BoxesRunTime.unboxToInt((Object)op$1.apply((Object)BoxesRunTime.boxToByte((byte)l), (Object)BoxesRunTime.boxToByte((byte)r)));
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ byte zipWithI2$$anonfun$1(Function3 op$2, byte x$1, byte x$2, byte x$3) {
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)x$1), (Object)BoxesRunTime.boxToByte((byte)x$2), (Object)BoxesRunTime.boxToByte((byte)x$3));
        if (tuple3 != null) {
            byte l = BoxesRunTime.unboxToByte((Object)tuple3._1());
            byte r1 = BoxesRunTime.unboxToByte((Object)tuple3._2());
            byte r2 = BoxesRunTime.unboxToByte((Object)tuple3._3());
            return (byte)BoxesRunTime.unboxToInt((Object)op$2.apply((Object)BoxesRunTime.boxToByte((byte)l), (Object)BoxesRunTime.boxToByte((byte)r1), (Object)BoxesRunTime.boxToByte((byte)r2)));
        }
        throw new MatchError((Object)tuple3);
    }

    private static final /* synthetic */ byte zipWithI3$$anonfun$1(Function4 op$3, byte x$1, byte x$2, byte x$3, byte x$4) {
        Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)x$1), (Object)BoxesRunTime.boxToByte((byte)x$2), (Object)BoxesRunTime.boxToByte((byte)x$3), (Object)BoxesRunTime.boxToByte((byte)x$4));
        if (tuple4 != null) {
            byte l = BoxesRunTime.unboxToByte((Object)tuple4._1());
            byte r1 = BoxesRunTime.unboxToByte((Object)tuple4._2());
            byte r2 = BoxesRunTime.unboxToByte((Object)tuple4._3());
            byte r3 = BoxesRunTime.unboxToByte((Object)tuple4._4());
            return (byte)BoxesRunTime.unboxToInt((Object)op$3.apply((Object)BoxesRunTime.boxToByte((byte)l), (Object)BoxesRunTime.boxToByte((byte)r1), (Object)BoxesRunTime.boxToByte((byte)r2), (Object)BoxesRunTime.boxToByte((byte)r3)));
        }
        throw new MatchError((Object)tuple4);
    }

    private static final int go$8(long chunkSize$2, ByteVector bytes, int h, int iter) {
        while (!bytes.isEmpty()) {
            ByteVector byteVector = bytes.drop(chunkSize$2);
            int n = MurmurHash3$.MODULE$.mix(h, MurmurHash3$.MODULE$.bytesHash(bytes.take(chunkSize$2).toArray()));
            int n2 = iter + 1;
            bytes = byteVector;
            h = n;
            iter = n2;
        }
        return MurmurHash3$.MODULE$.finalizeHash(h, iter);
    }

    private final boolean go$9(long s$2, ByteVector other$4, long i) {
        while (i < s$2) {
            if (this.apply(i) == other$4.apply(i)) {
                ++i;
                continue;
            }
            return false;
        }
        return true;
    }

    public static class Append
    extends ByteVector
    implements Product {
        private final ByteVector left;
        private final ByteVector right;
        private final long size;

        public static Append fromProduct(Product product) {
            return ByteVector$Append$.MODULE$.fromProduct(product);
        }

        public static Append unapply(Append append) {
            return ByteVector$Append$.MODULE$.unapply(append);
        }

        public Append(ByteVector left, ByteVector right) {
            this.left = left;
            this.right = right;
            this.size = left.size() + right.size();
        }

        public boolean canEqual(Object that) {
            return that instanceof Append;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Append";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "left";
            }
            if (1 == n2) {
                return "right";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteVector left() {
            return this.left;
        }

        public ByteVector right() {
            return this.right;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public byte getImpl(long n) {
            if (n < this.left().size()) {
                return this.left().getImpl(n);
            }
            return this.right().getImpl(n - this.left().size());
        }

        public Append copy(ByteVector left, ByteVector right) {
            return new Append(left, right);
        }

        public ByteVector copy$default$1() {
            return this.left();
        }

        public ByteVector copy$default$2() {
            return this.right();
        }

        public ByteVector _1() {
            return this.left();
        }

        public ByteVector _2() {
            return this.right();
        }
    }

    public static abstract class At {
        public abstract byte apply(long var1);

        public ByteBuffer asByteBuffer(long offset, int size) {
            byte[] arr = new byte[size];
            this.copyToArray(arr, 0, offset, size);
            return ByteBuffer.wrap(arr);
        }

        public ByteBuffer asByteBufferUnsafe(long offset, int size) {
            return this.asByteBuffer(offset, size);
        }

        public void copyToArray(byte[] xs, int start, long offset, int size) {
            for (int i = 0; i < size; ++i) {
                xs[start + i] = this.apply(offset + (long)i);
            }
        }

        public int copyToBuffer(ByteBuffer buffer, long offset, int size) {
            int i;
            for (i = 0; i < size && buffer.remaining() > 0; ++i) {
                buffer.put(this.apply(offset + (long)i));
            }
            return i;
        }

        public void copyToStream(OutputStream s, long offset, long size) {
            int i = 0;
            while ((long)i < size) {
                s.write(this.apply(offset + (long)i));
                ++i;
            }
        }
    }

    public static class AtArray
    extends At {
        private final byte[] arr;

        public AtArray(byte[] arr) {
            this.arr = arr;
        }

        public byte[] arr() {
            return this.arr;
        }

        @Override
        public byte apply(long i) {
            return this.arr()[(int)i];
        }

        @Override
        public ByteBuffer asByteBuffer(long start, int size) {
            return this.asByteBufferUnsafe(start, size).asReadOnlyBuffer();
        }

        @Override
        public ByteBuffer asByteBufferUnsafe(long start, int size) {
            ByteBuffer b = ByteBuffer.wrap(this.arr(), (int)start, size);
            if (start == 0L && size == this.arr().length) {
                return b;
            }
            return b.slice();
        }

        @Override
        public void copyToArray(byte[] xs, int start, long offset, int size) {
            System.arraycopy(this.arr(), (int)offset, xs, start, size);
        }

        @Override
        public void copyToStream(OutputStream s, long offset, long size) {
            s.write(this.arr(), (int)offset, ByteVector$.MODULE$.toIntSize(size));
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer, long offset, int size) {
            int toCopy = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(buffer.remaining()), size);
            buffer.put(this.arr(), (int)offset, toCopy);
            return toCopy;
        }
    }

    public static class AtByteBuffer
    extends At {
        private final ByteBuffer buf;

        public AtByteBuffer(ByteBuffer buf) {
            this.buf = buf;
        }

        public ByteBuffer buf() {
            return this.buf;
        }

        @Override
        public byte apply(long i) {
            return this.buf().get((int)i);
        }

        @Override
        public void copyToArray(byte[] xs, int start, long offset, int size) {
            ByteBuffer n = this.buf().duplicate();
            n.position((int)offset);
            n.get(xs, start, size);
        }

        @Override
        public ByteBuffer asByteBuffer(long offset, int size) {
            return this.asByteBufferUnsafe(offset, size).asReadOnlyBuffer();
        }

        @Override
        public ByteBuffer asByteBufferUnsafe(long offset, int size) {
            ByteBuffer b = this.buf().duplicate();
            if (offset == 0L && b.position() == 0 && size == b.remaining()) {
                return b;
            }
            b.position((int)offset);
            b.limit((int)offset + size);
            return b.slice();
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer, long offset, int size) {
            int toCopy = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(buffer.remaining()), size);
            buffer.put(this.asByteBuffer(offset, toCopy));
            return toCopy;
        }
    }

    public static class Buffer
    extends ByteVector {
        private final AtomicLong id;
        private final long stamp;
        private final ByteVector hd;
        private final byte[] lastChunk;
        private final int lastSize;

        public Buffer(AtomicLong id, long stamp, ByteVector hd, byte[] lastChunk, int lastSize) {
            this.id = id;
            this.stamp = stamp;
            this.hd = hd;
            this.lastChunk = lastChunk;
            this.lastSize = lastSize;
        }

        public AtomicLong id() {
            return this.id;
        }

        public long stamp() {
            return this.stamp;
        }

        public ByteVector hd() {
            return this.hd;
        }

        public byte[] lastChunk() {
            return this.lastChunk;
        }

        public int lastSize() {
            return this.lastSize;
        }

        @Override
        public long size() {
            return this.hd().size() + (long)this.lastSize();
        }

        @Override
        public ByteVector take(long n) {
            if (n <= this.hd().size()) {
                return this.hd().take(n);
            }
            return this.hd().$plus$plus(this.lastBytes().take(n - this.hd().size()));
        }

        @Override
        public ByteVector drop(long n) {
            if (n <= this.hd().size()) {
                return ByteVector$Buffer$.MODULE$.apply(this.id(), this.stamp(), this.hd().drop(n), this.lastChunk(), this.lastSize());
            }
            return this.unbuffer().drop(n).bufferBy(this.lastChunk().length);
        }

        @Override
        public byte getImpl(long n) {
            if (n < this.hd().size()) {
                return this.hd().getImpl(n);
            }
            return this.lastChunk()[(int)(n - this.hd().size())];
        }

        @Override
        public ByteVector $colon$plus(byte b) {
            if (this.id().compareAndSet(this.stamp(), this.stamp() + 1L) && this.lastSize() < this.lastChunk().length) {
                this.lastChunk()[this.lastSize()] = b;
                return ByteVector$Buffer$.MODULE$.apply(this.id(), this.stamp() + 1L, this.hd(), this.lastChunk(), this.lastSize() + 1);
            }
            return ByteVector$Buffer$.MODULE$.apply(new AtomicLong(0L), 0L, this.unbuffer(), new byte[this.lastChunk().length], 0).$colon$plus(b);
        }

        @Override
        public ByteVector $plus$plus(ByteVector bs) {
            if (bs.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return bs;
            }
            if (this.id().compareAndSet(this.stamp(), this.stamp() + 1L) && (long)(this.lastChunk().length - this.lastSize()) > bs.size()) {
                bs.copyToArray(this.lastChunk(), this.lastSize());
                return ByteVector$Buffer$.MODULE$.apply(this.id(), this.stamp() + 1L, this.hd(), this.lastChunk(), this.lastSize() + (int)bs.size());
            }
            if (this.lastSize() == 0) {
                return ByteVector$Buffer$.MODULE$.apply(this.id(), this.stamp(), this.hd().$plus$plus(bs).unbuffer(), this.lastChunk(), this.lastSize());
            }
            return ByteVector$Buffer$.MODULE$.apply(new AtomicLong(0L), 0L, this.unbuffer(), new byte[this.lastChunk().length], 0).$plus$plus(bs);
        }

        public ByteVector lastBytes() {
            return ByteVector$.MODULE$.view(this.lastChunk()).take(this.lastSize());
        }

        @Override
        public ByteVector unbuffer() {
            return this.hd().$plus$plus(this.lastSize() * 2 < this.lastChunk().length ? this.lastBytes().copy() : this.lastBytes());
        }

        public ByteVector rebuffer(int chunkSize) {
            Predef$.MODULE$.require(chunkSize > this.lastChunk().length);
            byte[] lastChunk2 = new byte[chunkSize];
            Object object = Predef$.MODULE$.byteArrayOps(this.lastChunk());
            ArrayOps$.MODULE$.copyToArray$extension(object, (Object)lastChunk2, 0, lastChunk2.length);
            return ByteVector$Buffer$.MODULE$.apply(new AtomicLong(0L), 0L, this.hd(), this.lastChunk(), this.lastSize());
        }
    }

    public static class ByteVectorInputStream
    extends InputStream {
        private final ByteVector bv;
        private final int bvlen;
        private final CustomAtomicInteger pos;

        public ByteVectorInputStream(ByteVector bv) {
            this.bv = bv;
            this.bvlen = (int)bv.size();
            this.pos = new CustomAtomicInteger(0);
        }

        @Override
        public int read() {
            int p = this.pos.getAndIncrement();
            if (p >= this.bvlen) {
                return -1;
            }
            return this.bv.get(p) & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            IntRef l = IntRef.create((int)-1);
            int cpos2 = this.pos.getAndUpdate_((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable)cpos -> {
                int n;
                l$1.elem = n = Math.min(len, this.bvlen - cpos);
                return cpos + l$1.elem;
            });
            if (cpos2 >= this.bvlen) {
                return -1;
            }
            this.bv.copyToArray(b, off, cpos2, l.elem);
            return l.elem;
        }

        @Override
        public int available() {
            return Math.max(this.bvlen - this.pos.get(), 0);
        }

        public class CustomAtomicInteger
        extends AtomicInteger {
            public CustomAtomicInteger(int v) {
                super(v);
            }

            public int getAndUpdate_(Function1<Object, Object> updateFunction) {
                int prev = this.get();
                int next = updateFunction.apply$mcII$sp(prev);
                while (!this.compareAndSet(prev, next)) {
                    prev = this.get();
                    next = updateFunction.apply$mcII$sp(prev);
                }
                return prev;
            }
        }
    }

    public static class Chunk
    extends ByteVector
    implements Product {
        private final View bytes;

        public static Chunk fromProduct(Product product) {
            return ByteVector$Chunk$.MODULE$.fromProduct(product);
        }

        public static Chunk unapply(Chunk chunk) {
            return ByteVector$Chunk$.MODULE$.unapply(chunk);
        }

        public Chunk(View bytes) {
            this.bytes = bytes;
        }

        public boolean canEqual(Object that) {
            return that instanceof Chunk;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Chunk";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "bytes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public View bytes() {
            return this.bytes;
        }

        @Override
        public long size() {
            return this.bytes().size();
        }

        @Override
        public byte getImpl(long i) {
            return this.bytes().apply(i);
        }

        public Chunk copy(View bytes) {
            return new Chunk(bytes);
        }

        public View copy$default$1() {
            return this.bytes();
        }

        public View _1() {
            return this.bytes();
        }
    }

    public static class Chunks
    extends ByteVector
    implements Product {
        private final Append chunks;

        public static Chunks fromProduct(Product product) {
            return ByteVector$Chunks$.MODULE$.fromProduct(product);
        }

        public static Chunks unapply(Chunks chunks) {
            return ByteVector$Chunks$.MODULE$.unapply(chunks);
        }

        public Chunks(Append chunks) {
            this.chunks = chunks;
        }

        public boolean canEqual(Object that) {
            return that instanceof Chunks;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Chunks";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "chunks";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Append chunks() {
            return this.chunks;
        }

        @Override
        public long size() {
            return this.chunks().size();
        }

        @Override
        public byte getImpl(long n) {
            return this.chunks().getImpl(n);
        }

        @Override
        public ByteVector $plus$plus(ByteVector b) {
            if (b.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return b;
            }
            return this.go$10(this.chunks(), b.unbuffer());
        }

        public Chunks copy(Append chunks) {
            return new Chunks(chunks);
        }

        public Append copy$default$1() {
            return this.chunks();
        }

        public Append _1() {
            return this.chunks();
        }

        private final ByteVector go$10(Append chunks, ByteVector last) {
            while (true) {
                Append left;
                long lastN;
                if ((lastN = last.size()) >= chunks.size() || lastN * 2L <= chunks.right().size()) {
                    return ByteVector$Chunks$.MODULE$.apply(ByteVector$Append$.MODULE$.apply(chunks, last));
                }
                ByteVector byteVector = chunks.left();
                if (!(byteVector instanceof Append)) break;
                Append append = left = (Append)byteVector;
                Append append2 = ByteVector$Append$.MODULE$.apply(chunks.right(), last);
                chunks = append;
                last = append2;
            }
            return ByteVector$Chunks$.MODULE$.apply(ByteVector$Append$.MODULE$.apply(chunks, last));
        }
    }

    public static abstract class F1B {
        public abstract byte apply(byte var1);
    }

    public static abstract class F1BB {
        public abstract boolean apply(byte var1);
    }

    public static abstract class F1BU {
        public abstract void apply(byte var1);
    }

    public static abstract class F2B {
        public abstract byte apply(byte var1, byte var2);
    }

    public static abstract class F3B {
        public abstract byte apply(byte var1, byte var2, byte var3);
    }

    public static abstract class F4B {
        public abstract byte apply(byte var1, byte var2, byte var3, byte var4);
    }

    public static abstract class F5B {
        public abstract byte apply(byte var1, byte var2, byte var3, byte var4, byte var5);
    }

    public static final class GroupedOp {
        private final ByteVector self;

        public static boolean equals$extension(ByteVector byteVector, Object object) {
            return ByteVector$GroupedOp$.MODULE$.equals$extension(byteVector, object);
        }

        public static Iterator<ByteVector> grouped$extension(ByteVector byteVector, long l) {
            return ByteVector$GroupedOp$.MODULE$.grouped$extension(byteVector, l);
        }

        public static int hashCode$extension(ByteVector byteVector) {
            return ByteVector$GroupedOp$.MODULE$.hashCode$extension(byteVector);
        }

        public GroupedOp(ByteVector self) {
            this.self = self;
        }

        public int hashCode() {
            return ByteVector$GroupedOp$.MODULE$.hashCode$extension(this.self());
        }

        public boolean equals(Object x$0) {
            return ByteVector$GroupedOp$.MODULE$.equals$extension(this.self(), x$0);
        }

        public ByteVector self() {
            return this.self;
        }

        public final Iterator<ByteVector> grouped(long chunkSize) {
            return ByteVector$GroupedOp$.MODULE$.grouped$extension(this.self(), chunkSize);
        }
    }

    public static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        public SerializationProxy(byte[] bytes) {
            this.bytes = bytes;
        }

        private byte[] bytes() {
            return this.bytes;
        }

        public Object readResolve() {
            return ByteVector$.MODULE$.view(this.bytes());
        }
    }

    public static class View
    implements Product,
    Serializable {
        private final At at;
        private final long offset;
        private final long size;

        public static View empty() {
            return ByteVector$View$.MODULE$.empty();
        }

        public static View fromProduct(Product product) {
            return ByteVector$View$.MODULE$.fromProduct(product);
        }

        public static View unapply(View view) {
            return ByteVector$View$.MODULE$.unapply(view);
        }

        public View(At at, long offset, long size) {
            this.at = at;
            this.offset = offset;
            this.size = size;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.at()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.offset()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof View)) return false;
            View view = (View)object;
            if (this.offset() != view.offset()) return false;
            if (this.size() != view.size()) return false;
            At at = this.at();
            At at2 = view.at();
            if (at == null) {
                if (at2 != null) {
                    return false;
                }
            } else if (!at.equals(at2)) return false;
            if (!view.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof View;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "View";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "at";
                }
                case 1: {
                    return "offset";
                }
                case 2: {
                    return "size";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public At at() {
            return this.at;
        }

        public long offset() {
            return this.offset;
        }

        public long size() {
            return this.size;
        }

        public byte apply(long n) {
            return this.at().apply(this.offset() + n);
        }

        public void foreach(F1BU f) {
            for (long i = 0L; i < this.size(); ++i) {
                f.apply(this.at().apply(this.offset() + i));
            }
        }

        public boolean foreachPartial(F1BB f) {
            boolean cont = true;
            for (long i = 0L; i < this.size() && cont; ++i) {
                cont = f.apply(this.at().apply(this.offset() + i));
            }
            return cont;
        }

        public ByteBuffer asByteBuffer() {
            return this.at().asByteBuffer(this.offset(), ByteVector$.MODULE$.toIntSize(this.size()));
        }

        public ByteBuffer asByteBufferUnsafe() {
            return this.at().asByteBufferUnsafe(this.offset(), ByteVector$.MODULE$.toIntSize(this.size()));
        }

        public void copyToStream(OutputStream s) {
            this.at().copyToStream(s, this.offset(), this.size());
        }

        public void copyToArray(byte[] xs, int start) {
            this.at().copyToArray(xs, start, this.offset(), ByteVector$.MODULE$.toIntSize(this.size()));
        }

        public void copyToArray(byte[] xs, int start, long offset, int size) {
            this.at().copyToArray(xs, start, this.offset() + offset, (int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(this.size()), (long)size));
        }

        public byte[] toArray() {
            byte[] arr = new byte[ByteVector$.MODULE$.toIntSize(this.size())];
            this.copyToArray(arr, 0);
            return arr;
        }

        public byte[] toArrayUnsafe() {
            AtByteBuffer atbuf;
            ByteBuffer buf;
            At at = this.at();
            if (at instanceof AtArray) {
                AtArray atarr = (AtArray)at;
                if (this.offset() == 0L) {
                    Object object = Predef$.MODULE$.byteArrayOps(atarr.arr());
                    if (this.size() == (long)ArrayOps$.MODULE$.size$extension(object)) {
                        return atarr.arr();
                    }
                }
            }
            if (at instanceof AtByteBuffer && (buf = (atbuf = (AtByteBuffer)at).buf()).hasArray() && this.offset() == 0L && buf.arrayOffset() == 0 && this.size() == (long)buf.array().length) {
                return atbuf.buf().array();
            }
            return this.toArray();
        }

        public int copyToBuffer(ByteBuffer buffer) {
            return this.at().copyToBuffer(buffer, this.offset(), ByteVector$.MODULE$.toIntSize(this.size()));
        }

        public View take(long n) {
            if (n <= 0L) {
                return ByteVector$View$.MODULE$.empty();
            }
            if (n >= this.size()) {
                return this;
            }
            return ByteVector$View$.MODULE$.apply(this.at(), this.offset(), n);
        }

        public View drop(long n) {
            if (n <= 0L) {
                return this;
            }
            if (n >= this.size()) {
                return ByteVector$View$.MODULE$.empty();
            }
            return ByteVector$View$.MODULE$.apply(this.at(), this.offset() + n, this.size() - n);
        }

        public View copy(At at, long offset, long size) {
            return new View(at, offset, size);
        }

        public At copy$default$1() {
            return this.at();
        }

        public long copy$default$2() {
            return this.offset();
        }

        public long copy$default$3() {
            return this.size();
        }

        public At _1() {
            return this.at();
        }

        public long _2() {
            return this.offset();
        }

        public long _3() {
            return this.size();
        }
    }
}

