/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public interface ByteVectorCrossPlatform {
    public static ByteVector deflate$(ByteVectorCrossPlatform $this, int level, int strategy, boolean nowrap, int chunkSize) {
        return $this.deflate(level, strategy, nowrap, chunkSize);
    }

    default public ByteVector deflate(int level, int strategy, boolean nowrap, int chunkSize) {
        ByteVector byteVector;
        if (((ByteVector)this).isEmpty()) {
            byteVector = (ByteVector)this;
        } else {
            Deflater deflater = new Deflater(level, nowrap);
            try {
                deflater.setStrategy(strategy);
                byte[] buffer = new byte[(int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)chunkSize), ((ByteVector)this).size())];
                ObjectRef result = ObjectRef.create((Object)ByteVector$.MODULE$.empty());
                ((ByteVector)this).foreachV((Function1<ByteVector.View, BoxedUnit>)(JProcedure1 & Serializable)v -> {
                    deflater.setInput(v.toArray());
                    ByteVector byteVector = ((ByteVector)result$1.elem).$plus$plus(ByteVectorCrossPlatform.loop$1(deflater, buffer, ByteVector$.MODULE$.empty(), false));
                    result$1.elem = byteVector;
                    byteVector = null;
                });
                deflater.setInput((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE)));
                deflater.finish();
                byteVector = ((ByteVector)result.elem).$plus$plus(ByteVectorCrossPlatform.loop$1(deflater, buffer, ByteVector$.MODULE$.empty(), true));
            }
            finally {
                deflater.end();
            }
        }
        return byteVector;
    }

    public static int deflate$default$1$(ByteVectorCrossPlatform $this) {
        return $this.deflate$default$1();
    }

    default public int deflate$default$1() {
        return -1;
    }

    public static int deflate$default$2$(ByteVectorCrossPlatform $this) {
        return $this.deflate$default$2();
    }

    default public int deflate$default$2() {
        return 0;
    }

    public static boolean deflate$default$3$(ByteVectorCrossPlatform $this) {
        return $this.deflate$default$3();
    }

    default public boolean deflate$default$3() {
        return false;
    }

    public static int deflate$default$4$(ByteVectorCrossPlatform $this) {
        return $this.deflate$default$4();
    }

    default public int deflate$default$4() {
        return 4096;
    }

    public static Either inflate$(ByteVectorCrossPlatform $this, int chunkSize, boolean nowrap) {
        return $this.inflate(chunkSize, nowrap);
    }

    default public Either<DataFormatException, ByteVector> inflate(int chunkSize, boolean nowrap) {
        Right right;
        block8: {
            if (((ByteVector)this).isEmpty()) {
                right = package$.MODULE$.Right().apply((Object)this);
            } else {
                byte[] arr = ((ByteVector)this).toArray();
                Inflater inflater = new Inflater(nowrap);
                try {
                    inflater.setInput(arr);
                    try {
                        byte[] buffer = new byte[RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(chunkSize), arr.length)];
                        ByteVector inflated = ByteVectorCrossPlatform.loop$2(inflater, buffer, ByteVector$.MODULE$.empty());
                        if (inflater.finished()) {
                            right = package$.MODULE$.Right().apply((Object)inflated);
                            break block8;
                        }
                        right = package$.MODULE$.Left().apply((Object)new DataFormatException(new StringBuilder(83).append("Insufficient data -- inflation reached end of input without completing inflation - ").append(inflated).toString()));
                    }
                    catch (DataFormatException e) {
                        right = package$.MODULE$.Left().apply((Object)e);
                    }
                }
                finally {
                    inflater.end();
                }
            }
        }
        return right;
    }

    public static int inflate$default$1$(ByteVectorCrossPlatform $this) {
        return $this.inflate$default$1();
    }

    default public int inflate$default$1() {
        return 4096;
    }

    public static boolean inflate$default$2$(ByteVectorCrossPlatform $this) {
        return $this.inflate$default$2();
    }

    default public boolean inflate$default$2() {
        return false;
    }

    public static ByteVector sha1$(ByteVectorCrossPlatform $this) {
        return $this.sha1();
    }

    default public ByteVector sha1() {
        return this.digest("SHA-1");
    }

    public static ByteVector sha256$(ByteVectorCrossPlatform $this) {
        return $this.sha256();
    }

    default public ByteVector sha256() {
        return this.digest("SHA-256");
    }

    public static ByteVector md5$(ByteVectorCrossPlatform $this) {
        return $this.md5();
    }

    default public ByteVector md5() {
        return this.digest("MD5");
    }

    public static ByteVector digest$(ByteVectorCrossPlatform $this, String algorithm) {
        return $this.digest(algorithm);
    }

    default public ByteVector digest(String algorithm) {
        return this.digest(MessageDigest.getInstance(algorithm));
    }

    public static ByteVector digest$(ByteVectorCrossPlatform $this, MessageDigest digest) {
        return $this.digest(digest);
    }

    default public ByteVector digest(MessageDigest digest) {
        ((ByteVector)this).foreachV((Function1<ByteVector.View, BoxedUnit>)(JProcedure1 & Serializable)v -> digest.update(v.toArray()));
        return ByteVector$.MODULE$.view(digest.digest());
    }

    public static Either encrypt$(ByteVectorCrossPlatform $this, Cipher ci, Key key, Option aparams, SecureRandom sr) {
        return $this.encrypt(ci, key, (Option<AlgorithmParameters>)aparams, sr);
    }

    default public Either<GeneralSecurityException, ByteVector> encrypt(Cipher ci, Key key, Option<AlgorithmParameters> aparams, SecureRandom sr) {
        return this.cipher(ci, key, 1, aparams, sr);
    }

    public static Option encrypt$default$3$(ByteVectorCrossPlatform $this) {
        return $this.encrypt$default$3();
    }

    default public Option<AlgorithmParameters> encrypt$default$3() {
        return None$.MODULE$;
    }

    public static Either decrypt$(ByteVectorCrossPlatform $this, Cipher ci, Key key, Option aparams, SecureRandom sr) {
        return $this.decrypt(ci, key, (Option<AlgorithmParameters>)aparams, sr);
    }

    default public Either<GeneralSecurityException, ByteVector> decrypt(Cipher ci, Key key, Option<AlgorithmParameters> aparams, SecureRandom sr) {
        return this.cipher(ci, key, 2, aparams, sr);
    }

    public static Option decrypt$default$3$(ByteVectorCrossPlatform $this) {
        return $this.decrypt$default$3();
    }

    default public Option<AlgorithmParameters> decrypt$default$3() {
        return None$.MODULE$;
    }

    public static Either cipher$(ByteVectorCrossPlatform $this, Cipher ci, Key key, int opmode, Option aparams, SecureRandom sr) {
        return $this.cipher(ci, key, opmode, (Option<AlgorithmParameters>)aparams, sr);
    }

    default public Either<GeneralSecurityException, ByteVector> cipher(Cipher ci, Key key, int opmode, Option<AlgorithmParameters> aparams2, SecureRandom sr) {
        Left left;
        try {
            aparams2.fold((Function0)((JFunction0.mcV.sp & Serializable)() -> ByteVectorCrossPlatform.cipher$$anonfun$1(ci, key, opmode, sr)), (Function1)(JProcedure1 & Serializable)aparams -> ci.init(opmode, key, (AlgorithmParameters)aparams, sr));
            ((ByteVector)this).foreachV((Function1<ByteVector.View, BoxedUnit>)(JProcedure1 & Serializable)view -> ci.update(view.toArrayUnsafe()));
            left = package$.MODULE$.Right().apply((Object)ByteVector$.MODULE$.view(ci.doFinal()));
        }
        catch (GeneralSecurityException e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    public static Option cipher$default$4$(ByteVectorCrossPlatform $this) {
        return $this.cipher$default$4();
    }

    default public Option<AlgorithmParameters> cipher$default$4() {
        return None$.MODULE$;
    }

    private static ByteVector loop$1(Deflater deflater$1, byte[] buffer$1, ByteVector acc, boolean fin) {
        ByteVector byteVector = acc;
        while (!(fin && deflater$1.finished() || !fin && deflater$1.needsInput())) {
            int count = deflater$1.deflate(buffer$1);
            byteVector = byteVector.$plus$plus(ByteVector$.MODULE$.apply(buffer$1, 0, count));
        }
        return byteVector;
    }

    private static ByteVector loop$2(Inflater inflater$1, byte[] buffer$3, ByteVector acc) {
        ByteVector byteVector = acc;
        while (!inflater$1.finished() && !inflater$1.needsInput()) {
            int count = inflater$1.inflate(buffer$3);
            byteVector = byteVector.$plus$plus(ByteVector$.MODULE$.apply(buffer$3, 0, count));
        }
        return byteVector;
    }

    private static void cipher$$anonfun$1(Cipher ci$1, Key key$1, int opmode$1, SecureRandom sr$1) {
        ci$1.init(opmode$1, key$1, sr$1);
    }
}

