/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.scijava.Context;
import org.scijava.Gateway;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.script.DefaultScriptInterpreter;
import org.scijava.script.ScriptInterpreter;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.service.Service;

public class ScriptREPL {
    private static final String NULL = "<null>";
    @Parameter
    private Context context;
    @Parameter
    private ScriptService scriptService;
    @Parameter(required=false)
    private PluginService pluginService;
    private final Consumer<String> out;
    private String languagePreference;
    private List<ScriptLanguage> languages;
    private ScriptInterpreter interpreter;
    private boolean debug;
    private static final String NL = System.getProperty("line.separator");

    public ScriptREPL(Context context) {
        this(context, System.out);
    }

    public ScriptREPL(Context context, String language) {
        this(context, language, System.out);
    }

    public ScriptREPL(Context context, OutputStream out) {
        this(context, null, out);
    }

    public ScriptREPL(Context context, String language, OutputStream out) {
        this(context, language, ScriptREPL.outputStreamConsumer(out));
    }

    public ScriptREPL(Context context, String language, Consumer<String> out) {
        context.inject(this);
        this.languagePreference = language;
        this.out = out;
    }

    public List<ScriptLanguage> getInterpretedLanguages() {
        if (this.languages == null) {
            this.initLanguages();
        }
        return this.languages;
    }

    public ScriptInterpreter getInterpreter() {
        return this.interpreter;
    }

    public void loop() throws IOException {
        this.loop(System.in);
    }

    public void loop(InputStream in) throws IOException {
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        try {
            this.loop(() -> {
                try {
                    return bin.readLine();
                }
                catch (IOException exc) {
                    throw new RuntimeException(exc);
                }
            });
        }
        catch (RuntimeException exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw exc;
        }
    }

    public void loop(Supplier<?> in) {
        block1: {
            String line;
            this.initialize();
            do {
                this.prompt();
                Object input = in.get();
                String string = line = input == null ? null : input.toString();
                if (line == null) break block1;
            } while (this.evaluate(line));
            return;
        }
    }

    public void initialize() {
        this.initialize(true);
    }

    public void initialize(boolean verbose) {
        if (verbose) {
            this.println("Welcome to the SciJava REPL!");
            this.println();
            this.help();
        }
        List<ScriptLanguage> langs = this.getInterpretedLanguages();
        if (verbose) {
            if (langs.isEmpty()) {
                this.println("--------------------------------------------------------------");
                this.println("Uh oh! There are no SciJava script languages available!");
                this.println("Are any on your classpath? E.g.: org.scijava:scripting-groovy?");
                this.println("--------------------------------------------------------------");
                this.println();
                return;
            }
            this.println("Have fun!");
            this.println();
        }
        if (!langs.isEmpty()) {
            if (this.languagePreference != null) {
                this.selectPreferredLanguage(langs);
            } else {
                this.lang(langs.get(0));
            }
        }
        this.populateBindings(this.interpreter.getBindings());
    }

    private void selectPreferredLanguage(List<ScriptLanguage> langs) {
        ScriptLanguage preference = langs.stream().filter(lang -> this.languagePreference.equals(lang.getLanguageName())).findFirst().orElse(langs.get(0));
        this.lang(preference);
    }

    public void prompt() {
        this.print(this.interpreter == null || this.interpreter.isReady() ? "> " : "\\ ");
    }

    public boolean evaluate(String line) {
        try {
            String tLine = line.trim();
            if (tLine.equals(":help")) {
                this.help();
            } else if (tLine.equals(":vars")) {
                this.vars();
            } else if (tLine.equals(":langs")) {
                this.langs();
            } else if (tLine.equals(":debug")) {
                this.debug();
            } else if (tLine.startsWith(":lang ")) {
                this.lang(line.substring(6).trim());
            } else {
                if (tLine.equals(":quit")) {
                    return false;
                }
                if (this.interpreter == null) {
                    return true;
                }
                Object result = this.interpreter.interpret(line);
                if (result != ScriptInterpreter.MORE_INPUT_PENDING) {
                    this.println(ScriptREPL.s(result));
                }
            }
        }
        catch (ScriptException exc) {
            if (this.debug) {
                this.printStackTrace(exc);
            } else {
                String msg = exc.getMessage();
                this.println(msg == null ? exc.getClass().getName() : msg);
            }
        }
        catch (Throwable exc) {
            this.printStackTrace(exc);
        }
        return true;
    }

    public void help() {
        this.println("Available built-in commands:");
        this.println();
        this.println("  :help           | this handy list of commands");
        this.println("  :vars           | dump a list of variables");
        this.println("  :lang <name>    | switch the active language");
        this.println("  :langs          | list available languages");
        this.println("  :debug          | toggle full stack traces");
        this.println("  :quit           | exit the REPL");
        this.println();
        this.println("Or type a statement to evaluate it with the active language.");
        this.println();
    }

    public void vars() {
        if (this.interpreter == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        Bindings bindings = this.interpreter.getBindings();
        for (String key : bindings.keySet()) {
            Object value = bindings.get(key);
            keys.add(key);
            types.add(this.type(value));
        }
        this.printColumns(keys, types);
    }

    public void lang(String langName) {
        ScriptLanguage language = this.scriptService.getLanguageByName(langName);
        if (language == null) {
            this.println("No such language: " + langName);
            return;
        }
        this.lang(language);
        this.println("language -> " + this.interpreter.getLanguage().getLanguageName());
    }

    public void lang(ScriptLanguage language) {
        DefaultScriptInterpreter newInterpreter = new DefaultScriptInterpreter(language);
        try {
            this.copyBindings(this.interpreter, newInterpreter);
        }
        catch (Throwable t) {
            this.printStackTrace(t);
        }
        this.interpreter = newInterpreter;
    }

    public void langs() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> versions = new ArrayList<String>();
        ArrayList<List<String>> aliases = new ArrayList<List<String>>();
        for (ScriptLanguage lang : this.getInterpretedLanguages()) {
            names.add(lang.getLanguageName());
            versions.add(lang.getLanguageVersion());
            aliases.add(lang.getNames());
        }
        this.printColumns(names, versions, aliases);
    }

    public void debug() {
        this.debug = !this.debug;
        this.println("debug mode -> " + this.debug);
    }

    public static void main(String ... args) throws Exception {
        ScriptREPL scriptCLI;
        Context context = new Context();
        if (args.length > 0) {
            String preference = args[0];
            scriptCLI = new ScriptREPL(context, preference);
        } else {
            scriptCLI = new ScriptREPL(context);
        }
        scriptCLI.loop();
        context.dispose();
        System.exit(0);
    }

    private synchronized void initLanguages() {
        if (this.languages != null) {
            return;
        }
        ArrayList<ScriptLanguage> langs = new ArrayList<ScriptLanguage>();
        for (ScriptLanguage lang : this.scriptService.getLanguages()) {
            if (lang.isCompiledLanguage()) continue;
            langs.add(lang);
        }
        this.languages = langs;
    }

    private void populateBindings(Bindings bindings) {
        bindings.put("ctx", (Object)this.context);
        for (Service service : this.context.getServiceIndex().getAll()) {
            String name = this.serviceName(service);
            bindings.put(name, (Object)service);
        }
        for (Gateway gateway : this.gateways()) {
            bindings.put(gateway.getShortName(), (Object)gateway);
        }
    }

    private void copyBindings(ScriptInterpreter src, ScriptInterpreter dest) {
        if (src == null) {
            return;
        }
        Bindings srcBindings = src.getBindings();
        Bindings destBindings = dest.getBindings();
        for (String key : src.getBindings().keySet()) {
            Object value = src.getLanguage().decode(srcBindings.get(key));
            destBindings.put(key, value);
        }
    }

    private List<Gateway> gateways() {
        ArrayList<Gateway> gateways = new ArrayList<Gateway>();
        if (this.pluginService == null) {
            return gateways;
        }
        List<PluginInfo<Gateway>> infos = this.pluginService.getPluginsOfType(Gateway.class);
        for (PluginInfo<Gateway> info : infos) {
            try {
                Constructor<Gateway> ctor = info.loadClass().getConstructor(Context.class);
                Gateway gateway = ctor.newInstance(this.context);
                gateways.add(gateway);
            }
            catch (Throwable t) {
                this.printStackTrace(t);
            }
        }
        return gateways;
    }

    private String serviceName(Service service) {
        String pluginName;
        PluginInfo<?> info = service.getInfo();
        String string = pluginName = info == null ? null : info.getName();
        if (pluginName != null && !pluginName.isEmpty()) {
            return pluginName;
        }
        String serviceName = service.getClass().getSimpleName();
        String shortName = ScriptREPL.lowerCamelCase(serviceName.replaceAll("^(Default)?(.*)Service$", "$2"));
        return shortName;
    }

    private String type(Object value) {
        if (value == null) {
            return NULL;
        }
        Object decoded = this.interpreter.getLanguage().decode(value);
        if (decoded == null) {
            return NULL;
        }
        return "[" + decoded.getClass().getName() + "]";
    }

    private void print(String s) {
        this.out.accept(s);
    }

    private void println() {
        this.print(NL);
    }

    private void println(String s) {
        this.print(s + NL);
    }

    private void printStackTrace(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(baos));
        this.println(baos.toString());
    }

    private void printColumns(List<?> ... columns) {
        int pad = 2;
        int[] widths = new int[columns.length];
        for (int c = 0; c < columns.length; ++c) {
            List<?> list = columns[c];
            for (Object o : list) {
                String s = ScriptREPL.s(o);
                if (s.length() <= widths[c]) continue;
                widths[c] = s.length();
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns[0].size(); ++i) {
            sb.setLength(0);
            for (int c = 0; c < columns.length; ++c) {
                String s = ScriptREPL.s(columns[c].get(i));
                sb.append(s);
                if (c >= columns.length - 1) continue;
                for (int p = s.length(); p < widths[c] + 2; ++p) {
                    sb.append(' ');
                }
            }
            this.println(sb.toString());
        }
    }

    private static Consumer<String> outputStreamConsumer(OutputStream out) {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        return s -> {
            ps.print((String)s);
            ps.flush();
        };
    }

    private static String lowerCamelCase(String s) {
        char c;
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length() && (c = sb.charAt(i)) >= 'A' && c <= 'Z'; ++i) {
            sb.setCharAt(i, (char)(c - 65 + 97));
        }
        return sb.toString();
    }

    private static String s(Object o) {
        return o == null ? NULL : o.toString();
    }
}

