/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.object;

import java.util.List;
import org.scijava.Named;
import org.scijava.event.EventService;
import org.scijava.object.NamedObjectIndex;
import org.scijava.object.event.ObjectsAddedEvent;
import org.scijava.object.event.ObjectsRemovedEvent;
import org.scijava.service.SciJavaService;

public interface ObjectService
extends SciJavaService {
    default public EventService eventService() {
        return this.context().getService(EventService.class);
    }

    public NamedObjectIndex<Object> getIndex();

    default public <T> List<T> getObjects(Class<T> type) {
        List list;
        List result = list = this.getIndex().get(type);
        return result;
    }

    default public String getName(Object obj) {
        String n;
        if (obj == null) {
            throw new NullPointerException();
        }
        String name = this.getIndex().getName(obj);
        if (name != null) {
            return name;
        }
        if (obj instanceof Named && (n = ((Named)obj).getName()) != null) {
            return n;
        }
        String s = obj.toString();
        if (s != null) {
            return s;
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode());
    }

    default public void addObject(Object obj) {
        this.addObject(obj, null);
    }

    default public void addObject(Object obj, String name) {
        this.getIndex().add(obj, name);
        this.eventService().publish(new ObjectsAddedEvent(obj));
    }

    default public void removeObject(Object obj) {
        this.getIndex().remove(obj);
        this.eventService().publish(new ObjectsRemovedEvent(obj));
    }

    @Deprecated
    default public EventService getEventService() {
        return this.eventService();
    }
}

