/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.process;

import org.scijava.Context;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=PreprocessorPlugin.class, priority=20000.0)
public class ServicePreprocessor
extends AbstractPreprocessorPlugin {
    @Override
    public void process(Module module) {
        for (ModuleItem<?> input : module.getInfo().inputs()) {
            if (!input.isAutoFill() || module.isInputResolved(input.getName())) continue;
            Class<?> type = input.getType();
            if (Service.class.isAssignableFrom(type)) {
                ModuleItem<?> serviceInput = input;
                this.setServiceValue(this.getContext(), module, serviceInput);
            }
            if (!Context.class.isAssignableFrom(type) || !type.isAssignableFrom(this.getContext().getClass())) continue;
            String name = input.getName();
            module.setInput(name, this.getContext());
            module.resolveInput(name);
        }
    }

    private <S extends Service> void setServiceValue(Context context, Module module, ModuleItem<S> input) {
        S service = context.getService(input.getType());
        input.setValue(module, service);
        module.resolveInput(input.getName());
    }
}

