/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.nio;

import java.nio.ByteBuffer;
import java.util.function.Function;
import org.scijava.io.ByteBank;

public class ByteBufferByteBank
implements ByteBank {
    private static final int DEFAULT_CAPACITY = 10000;
    private ByteBuffer buffer;
    private int size;
    private Function<Integer, ByteBuffer> provider;

    public ByteBufferByteBank() {
        this.provider = ByteBuffer::allocate;
        this.buffer = this.provider.apply(10000);
    }

    public ByteBufferByteBank(Function<Integer, ByteBuffer> provider) {
        this.provider = provider;
        this.buffer = provider.apply(10000);
    }

    public ByteBufferByteBank(Function<Integer, ByteBuffer> provider, int initialCapacity) {
        this.provider = provider;
        this.buffer = provider.apply(initialCapacity);
    }

    public ByteBufferByteBank(int initialCapacity) {
        this.provider = ByteBuffer::allocate;
        this.buffer = this.provider.apply(initialCapacity);
    }

    @Override
    public long getMaxBufferSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setBytes(long startpos, byte[] bytes, int offset, int length) {
        this.checkWritePos(startpos, startpos + (long)length);
        int neededCapacity = this.size + length;
        this.ensureCapacity(neededCapacity);
        this.buffer.position((int)startpos);
        this.buffer.put(bytes, offset, length);
        this.updateSize(startpos + (long)length);
    }

    @Override
    public void setByte(long pos, byte b) {
        this.checkWritePos(pos, pos);
        if (pos == (long)this.buffer.capacity()) {
            this.ensureCapacity((int)pos + 1);
        }
        this.buffer.put((int)pos, b);
        this.updateSize(pos + 1L);
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.size = 0;
    }

    @Override
    public byte getByte(long pos) {
        this.checkReadPos(pos, pos);
        return this.buffer.get((int)pos);
    }

    @Override
    public int getBytes(long startPos, byte[] b, int offset, int length) {
        this.checkReadPos(startPos, startPos + (long)length);
        int readLength = (int)Math.min(this.size() - startPos, (long)length);
        this.buffer.position((int)startPos);
        this.buffer.get(b, offset, readLength);
        return readLength;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean isReadOnly() {
        String className = this.buffer.getClass().getName();
        return className.equals("java.nio.HeapByteBufferR") || className.equals("java.nio.DirectByteBufferR");
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.buffer.capacity();
        if (minCapacity <= oldCapacity) {
            return;
        }
        int growth = Math.min(oldCapacity / 2 + 16, Integer.MAX_VALUE);
        int newCapacity = growth > Integer.MAX_VALUE - oldCapacity ? Integer.MAX_VALUE : oldCapacity + growth;
        int newLength = Math.max(minCapacity, newCapacity);
        this.buffer.position(0);
        ByteBuffer newBuffer = ByteBuffer.allocate(newLength);
        newBuffer.order(this.buffer.order());
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    private void updateSize(long newSize) {
        this.size = (int)(newSize > (long)this.size ? newSize : (long)this.size);
    }
}

