/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.event.bushe;

import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.scijava.event.bushe.EventService;
import org.scijava.event.bushe.Prioritized;
import org.scijava.event.bushe.ProxySubscriber;
import org.scijava.event.bushe.ReferenceStrength;

public abstract class AbstractProxySubscriber
implements ProxySubscriber,
Prioritized {
    private Object proxiedSubscriber;
    private Method subscriptionMethod;
    private ReferenceStrength referenceStrength;
    private EventService eventService;
    private int priority;
    protected boolean veto;

    protected AbstractProxySubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, EventService es, boolean veto) {
        this(proxiedSubscriber, subscriptionMethod, referenceStrength, 0, es, veto);
    }

    protected AbstractProxySubscriber(Object proxiedSubscriber, Method subscriptionMethod, ReferenceStrength referenceStrength, int priority, EventService es, boolean veto) {
        this.referenceStrength = referenceStrength;
        this.priority = priority;
        this.eventService = es;
        this.veto = veto;
        if (proxiedSubscriber == null) {
            throw new IllegalArgumentException("The realSubscriber cannot be null when constructing a proxy subscriber.");
        }
        if (subscriptionMethod == null) {
            throw new IllegalArgumentException("The subscriptionMethod cannot be null when constructing a proxy subscriber.");
        }
        Class<?> returnType = subscriptionMethod.getReturnType();
        if (veto && returnType != Boolean.TYPE) {
            throw new IllegalArgumentException("The subscriptionMethod must have the two parameters, the first one must be a String and the second a non-primitive (Object or derivative).");
        }
        this.proxiedSubscriber = ReferenceStrength.WEAK.equals((Object)referenceStrength) ? new WeakReference<Object>(proxiedSubscriber) : proxiedSubscriber;
        this.subscriptionMethod = subscriptionMethod;
    }

    @Override
    public Object getProxiedSubscriber() {
        if (this.proxiedSubscriber instanceof WeakReference) {
            return ((WeakReference)this.proxiedSubscriber).get();
        }
        return this.proxiedSubscriber;
    }

    public Method getSubscriptionMethod() {
        return this.subscriptionMethod;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public ReferenceStrength getReferenceStrength() {
        return this.referenceStrength;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void proxyUnsubscribed() {
        this.proxiedSubscriber = null;
    }

    public final int hashCode() {
        throw new RuntimeException("Proxy subscribers are not allowed in Hash Maps, since the underlying values use Weak References thatmay disappear, the calculations may not be the same insuccessive calls as required by hashCode.");
    }

    protected boolean retryReflectiveCallUsingAccessibleObject(Object[] args, Method subscriptionMethod, Object obj, IllegalAccessException e, String message) {
        boolean accessibleTriedAndFailed = false;
        if (subscriptionMethod != null) {
            AccessibleObject[] accessibleMethod = new AccessibleObject[]{subscriptionMethod};
            try {
                AccessibleObject.setAccessible(accessibleMethod, true);
                Object returnValue = subscriptionMethod.invoke(obj, args);
                return Boolean.valueOf(returnValue + "");
            }
            catch (SecurityException ex) {
                accessibleTriedAndFailed = true;
            }
            catch (InvocationTargetException e1) {
                throw new RuntimeException(message, e);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(message, e);
            }
        }
        if (accessibleTriedAndFailed) {
            message = message + ".  An attempt was made to make the method accessible, but the SecurityManager denied the attempt.";
        }
        throw new RuntimeException(message, e);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractProxySubscriber) {
            AbstractProxySubscriber bps = (AbstractProxySubscriber)obj;
            if (this.referenceStrength != bps.referenceStrength) {
                return false;
            }
            if (this.subscriptionMethod != bps.subscriptionMethod) {
                return false;
            }
            if (ReferenceStrength.WEAK == this.referenceStrength ? ((WeakReference)this.proxiedSubscriber).get() != ((WeakReference)bps.proxiedSubscriber).get() : this.proxiedSubscriber != bps.proxiedSubscriber) {
                return false;
            }
            if (this.veto != bps.veto) {
                return false;
            }
            return this.eventService == bps.eventService;
        }
        return false;
    }

    public String toString() {
        return "AbstractProxySubscriber{realSubscriber=" + (this.proxiedSubscriber instanceof WeakReference ? ((WeakReference)this.proxiedSubscriber).get() : this.proxiedSubscriber) + ", subscriptionMethod=" + this.subscriptionMethod + ", veto=" + this.veto + ", referenceStrength=" + (Object)((Object)this.referenceStrength) + ", eventService=" + this.eventService + '}';
    }
}

