/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Attributes;
import org.scijava.Versioned;
import org.scijava.util.Types;
import org.scijava.util.XML;

public class Manifest
implements Versioned {
    private final java.util.jar.Manifest manifest;

    private Manifest(java.util.jar.Manifest manifest) {
        this.manifest = manifest;
    }

    public String getArchiverVersion() {
        return this.get("Archiver-Version");
    }

    public String getBuildJdk() {
        return this.get("Build-Jdk");
    }

    public String getBuiltBy() {
        return this.get("Built-By");
    }

    public String getCreatedBy() {
        return this.get("Created-By");
    }

    public String getImplementationBuild() {
        return this.get("Implementation-Build");
    }

    public String getImplementationDate() {
        return this.get("Implementation-Date");
    }

    public String getImplementationTitle() {
        return this.get("Implementation-Title");
    }

    public String getImplementationVendor() {
        return this.get("Implementation-Vendor");
    }

    public String getImplementationVendorId() {
        return this.get("Implementation-Vendor-Id");
    }

    public String getImplementationVersion() {
        return this.get("Implementation-Version");
    }

    public String getManifestVersion() {
        return this.get("Manifest-Version");
    }

    public String getPackage() {
        return this.get("Package");
    }

    public String getSpecificationTitle() {
        return this.get("Specification-Title");
    }

    public String getSpecificationVendor() {
        return this.get("Specification-Vendor");
    }

    public String getSpecificationVersion() {
        return this.get("Specification-Version");
    }

    public String get(String key) {
        if (this.manifest == null) {
            return null;
        }
        Attributes mainAttrs = this.manifest.getMainAttributes();
        if (mainAttrs == null) {
            return null;
        }
        return mainAttrs.getValue(key);
    }

    public Map<Object, Object> getAll() {
        if (this.manifest == null) {
            return null;
        }
        Attributes mainAttrs = this.manifest.getMainAttributes();
        if (mainAttrs == null) {
            return null;
        }
        return Collections.unmodifiableMap(mainAttrs);
    }

    public static Manifest getManifest(Class<?> c) {
        try {
            return Manifest.getManifest(new URL("jar:" + Types.location(c) + "!/"));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Manifest getManifest(XML xml) throws IOException {
        String path = xml.getPath();
        if (path == null || !path.startsWith("file:")) {
            return null;
        }
        int dotJAR = path.indexOf(".jar!/");
        return Manifest.getManifest(new File(path.substring(5, dotJAR + 4)));
    }

    public static Manifest getManifest(File jarFile) throws IOException {
        if (!jarFile.exists()) {
            throw new FileNotFoundException();
        }
        return Manifest.getManifest(new URL("jar:file:" + jarFile.getAbsolutePath() + "!/"));
    }

    private static Manifest getManifest(URL jarURL) throws IOException {
        JarURLConnection conn = (JarURLConnection)jarURL.openConnection();
        return new Manifest(conn.getManifest());
    }

    @Override
    public String getVersion() {
        String v = this.getBaseVersion();
        if (v == null || !v.endsWith("-SNAPSHOT")) {
            return v;
        }
        String buildNumber = this.getImplementationBuild();
        return buildNumber == null ? v : v + "-" + buildNumber;
    }

    private String getBaseVersion() {
        String manifestVersion = this.getImplementationVersion();
        if (manifestVersion != null) {
            return manifestVersion;
        }
        return this.getSpecificationVersion();
    }
}

