/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui;

public class ARGBPlane {
    private final int width;
    private final int height;
    private final int[] data;

    public ARGBPlane(int width, int height, int[] data) {
        this.width = width;
        this.height = height;
        this.data = data;
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Both width and height must be greater than zero");
        }
        if ((long)width * (long)height > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Plane is too large");
        }
        if (data.length != width * height) {
            throw new IllegalArgumentException("Data size mismatch");
        }
    }

    public ARGBPlane(int width, int height) {
        this(width, height, new int[width * height]);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getData() {
        return this.data;
    }

    public int getARGB(int x, int y) {
        return this.data[this.index(x, y)];
    }

    public int getAlpha(int x, int y) {
        return this.alpha(this.data[this.index(x, y)]);
    }

    public int getRed(int x, int y) {
        return this.red(this.data[this.index(x, y)]);
    }

    public int getGreen(int x, int y) {
        return this.green(this.data[this.index(x, y)]);
    }

    public int getBlue(int x, int y) {
        return this.blue(this.data[this.index(x, y)]);
    }

    public void setARGB(int x, int y, int argb) {
        this.data[this.index((int)x, (int)y)] = argb;
    }

    public void setAlpha(int x, int y, int v) {
        int argb = this.data[this.index(x, y)];
        int component = v & 0xFF;
        argb &= 0xFFFFFF;
        this.data[this.index((int)x, (int)y)] = argb |= component << 24;
    }

    public void setRed(int x, int y, int v) {
        int argb = this.data[this.index(x, y)];
        int component = v & 0xFF;
        argb &= 0xFF00FFFF;
        this.data[this.index((int)x, (int)y)] = argb |= component << 16;
    }

    public void setGreen(int x, int y, int v) {
        int argb = this.data[this.index(x, y)];
        int component = v & 0xFF;
        argb &= 0xFFFF00FF;
        this.data[this.index((int)x, (int)y)] = argb |= component << 8;
    }

    public void setBlue(int x, int y, int v) {
        int argb = this.data[this.index(x, y)];
        int component = v & 0xFF;
        argb &= 0xFFFFFF00;
        this.data[this.index((int)x, (int)y)] = argb |= component << 0;
    }

    private int index(int x, int y) {
        return y * this.width + x;
    }

    private int alpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    private int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    private int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    private int blue(int argb) {
        return argb >> 0 & 0xFF;
    }
}

