/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.IOException;
import java.io.OutputStream;

public abstract class LineOutputStream
extends OutputStream {
    public byte[] buffer = new byte[16384];
    public int len;

    public abstract void println(String var1) throws IOException;

    @Override
    public synchronized void write(int b) throws IOException {
        this.ensure(this.len + 1);
        this.buffer[this.len++] = (byte)b;
        if (b == 10) {
            this.flush();
        }
    }

    @Override
    public synchronized void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public synchronized void write(byte[] buf, int offset, int length) throws IOException {
        int eol;
        for (eol = length; eol > 0 && buf[eol - 1] != 10; --eol) {
        }
        if (eol >= 0) {
            this.ensure(this.len + eol);
            System.arraycopy(buf, offset, this.buffer, this.len, eol);
            this.len += eol;
            this.flush();
            if ((length -= eol) == 0) {
                return;
            }
            offset += eol;
        }
        this.ensure(this.len + length);
        System.arraycopy(buf, offset, this.buffer, this.len, length);
        this.len += length;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.len > 0) {
            if (this.buffer[this.len - 1] == 10) {
                --this.len;
            }
            this.println(new String(this.buffer, 0, this.len));
        }
        this.len = 0;
    }

    protected synchronized void ensure(int length) {
        if (this.buffer.length >= length) {
            return;
        }
        int newLength = this.buffer.length * 3 / 2;
        if (newLength < length) {
            newLength = length + 16;
        }
        byte[] newBuffer = new byte[newLength];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.len);
        this.buffer = newBuffer;
    }
}

