/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.script.ScriptException;
import org.scijava.MenuPath;
import org.scijava.plugin.SingletonService;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptLanguageIndex;
import org.scijava.script.ScriptModule;
import org.scijava.service.SciJavaService;

public interface ScriptService
extends SingletonService<ScriptLanguage>,
SciJavaService {
    public static final String SCRIPTS_PATH_PROPERTY = "scijava.scripts.path";
    public static final String SCRIPTS_RESOURCE_DIR = "scripts";

    public ScriptLanguageIndex getIndex();

    default public List<ScriptLanguage> getLanguages() {
        return new ArrayList<ScriptLanguage>(this.getIndex());
    }

    default public ScriptLanguage getLanguageByExtension(String extension) {
        return this.getIndex().getByExtension(extension);
    }

    default public ScriptLanguage getLanguageByName(String name) {
        return this.getIndex().getByName(name);
    }

    public List<File> getScriptDirectories();

    public MenuPath getMenuPrefix(File var1);

    public void addScriptDirectory(File var1);

    public void addScriptDirectory(File var1, MenuPath var2);

    public void removeScriptDirectory(File var1);

    public Collection<ScriptInfo> getScripts();

    public ScriptInfo getScript(File var1);

    public Future<ScriptModule> run(File var1, boolean var2, Object ... var3) throws FileNotFoundException, ScriptException;

    public Future<ScriptModule> run(File var1, boolean var2, Map<String, Object> var3) throws FileNotFoundException, ScriptException;

    default public Future<ScriptModule> run(String path, String script, boolean process, Object ... inputs) {
        return this.run(path, (Reader)new StringReader(script), process, inputs);
    }

    default public Future<ScriptModule> run(String path, String script, boolean process, Map<String, Object> inputMap) {
        return this.run(path, (Reader)new StringReader(script), process, inputMap);
    }

    default public Future<ScriptModule> run(String path, Reader reader, boolean process, Object ... inputs) {
        return this.run(new ScriptInfo(this.getContext(), path, reader), process, inputs);
    }

    default public Future<ScriptModule> run(String path, Reader reader, boolean process, Map<String, Object> inputMap) {
        return this.run(new ScriptInfo(this.getContext(), path, reader), process, inputMap);
    }

    public Future<ScriptModule> run(ScriptInfo var1, boolean var2, Object ... var3);

    public Future<ScriptModule> run(ScriptInfo var1, boolean var2, Map<String, Object> var3);

    default public boolean canHandleFile(File file) {
        return this.getIndex().canHandleFile(file);
    }

    default public boolean canHandleFile(String fileName) {
        return this.getIndex().canHandleFile(fileName);
    }

    default public void addAlias(Class<?> type) {
        this.addAlias(type.getSimpleName(), type);
    }

    public void addAlias(String var1, Class<?> var2);

    public Class<?> lookupClass(String var1) throws ScriptException;

    @Override
    default public Class<ScriptLanguage> getPluginType() {
        return ScriptLanguage.class;
    }
}

