/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import org.scijava.event.EventService;
import org.scijava.io.IOPlugin;
import org.scijava.io.IOService;
import org.scijava.io.event.DataOpenedEvent;
import org.scijava.io.event.DataSavedEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public final class DefaultIOService
extends AbstractHandlerService<String, IOPlugin<?>>
implements IOService {
    @Parameter
    private LogService log;
    @Parameter
    private EventService eventService;

    @Override
    public Object open(String source) throws IOException {
        IOPlugin<?> opener = this.getOpener(source);
        if (opener == null) {
            return null;
        }
        Object data = opener.open(source);
        if (data == null) {
            return null;
        }
        this.eventService.publish(new DataOpenedEvent(source, data));
        return data;
    }

    @Override
    public void save(Object data, String destination) throws IOException {
        IOPlugin<Object> saver = this.getSaver(data, destination);
        if (saver != null) {
            saver.save(data, destination);
            this.eventService.publish(new DataSavedEvent(destination, data));
        }
    }
}

