/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parsington.eval;

import java.util.LinkedList;
import org.scijava.parsington.ExpressionParser;
import org.scijava.parsington.Operator;
import org.scijava.parsington.SyntaxTree;
import org.scijava.parsington.Tokens;
import org.scijava.parsington.eval.AbstractEvaluator;
import org.scijava.parsington.eval.TreeEvaluator;

public abstract class AbstractTreeEvaluator
extends AbstractEvaluator
implements TreeEvaluator {
    public AbstractTreeEvaluator() {
    }

    public AbstractTreeEvaluator(ExpressionParser parser) {
        super(parser);
    }

    @Override
    public Object evaluate(String expression) {
        return this.evaluate(this.getParser().parseTree(expression));
    }

    @Override
    public Object evaluate(LinkedList<Object> queue) {
        return this.evaluate(new SyntaxTree(queue));
    }

    @Override
    public Object evaluate(SyntaxTree syntaxTree) {
        Object token = syntaxTree.token();
        if (Tokens.isOperator(token)) {
            Operator op = (Operator)token;
            assert (op.getArity() == syntaxTree.count());
            return this.execute(op, syntaxTree);
        }
        assert (syntaxTree.count() == 0);
        return token;
    }
}

