/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parsington.eval;

import java.util.Deque;
import org.scijava.parsington.ExpressionParser;
import org.scijava.parsington.Function;
import org.scijava.parsington.Operator;
import org.scijava.parsington.Operators;
import org.scijava.parsington.Tokens;
import org.scijava.parsington.Variable;
import org.scijava.parsington.eval.AbstractStackEvaluator;
import org.scijava.parsington.eval.StandardEvaluator;

public abstract class AbstractStandardStackEvaluator
extends AbstractStackEvaluator
implements StandardEvaluator {
    public AbstractStandardStackEvaluator() {
    }

    public AbstractStandardStackEvaluator(ExpressionParser parser) {
        super(parser);
    }

    @Override
    public Object postInc(Object a) {
        Variable v = this.var(a);
        Object value = this.value(v);
        if (value == null) {
            return null;
        }
        this.set(v, this.add(a, 1));
        return value;
    }

    @Override
    public Object postDec(Object a) {
        Variable v = this.var(a);
        Object value = this.value(v);
        if (value == null) {
            return null;
        }
        this.set(v, this.sub(a, 1));
        return value;
    }

    @Override
    public Object preInc(Object a) {
        Variable v = this.var(a);
        Object result = this.add(a, 1);
        this.set(v, result);
        return result;
    }

    @Override
    public Object preDec(Object a) {
        Variable v = this.var(a);
        Object result = this.sub(a, 1);
        this.set(v, result);
        return result;
    }

    @Override
    public Object question(Object a, Object b) {
        return null;
    }

    @Override
    public Object colon(Object a, Object b) {
        return null;
    }

    @Override
    public Object assign(Object a, Object b) {
        Variable v = this.var(a);
        this.set(v, this.value(b));
        return v;
    }

    @Override
    public Object powAssign(Object a, Object b) {
        return this.assign(a, this.pow(a, b));
    }

    @Override
    public Object dotPowAssign(Object a, Object b) {
        return this.assign(a, this.dotPow(a, b));
    }

    @Override
    public Object mulAssign(Object a, Object b) {
        return this.assign(a, this.mul(a, b));
    }

    @Override
    public Object divAssign(Object a, Object b) {
        return this.assign(a, this.div(a, b));
    }

    @Override
    public Object modAssign(Object a, Object b) {
        return this.assign(a, this.mod(a, b));
    }

    @Override
    public Object rightDivAssign(Object a, Object b) {
        return this.assign(a, this.rightDiv(a, b));
    }

    @Override
    public Object dotDivAssign(Object a, Object b) {
        return this.assign(a, this.dotDiv(a, b));
    }

    @Override
    public Object dotRightDivAssign(Object a, Object b) {
        return this.assign(a, this.dotRightDiv(a, b));
    }

    @Override
    public Object addAssign(Object a, Object b) {
        return this.assign(a, this.add(a, b));
    }

    @Override
    public Object subAssign(Object a, Object b) {
        return this.assign(a, this.sub(a, b));
    }

    @Override
    public Object andAssign(Object a, Object b) {
        return this.assign(a, this.bitwiseAnd(a, b));
    }

    @Override
    public Object orAssign(Object a, Object b) {
        return this.assign(a, this.bitwiseOr(a, b));
    }

    @Override
    public Object leftShiftAssign(Object a, Object b) {
        return this.assign(a, this.leftShift(a, b));
    }

    @Override
    public Object rightShiftAssign(Object a, Object b) {
        return this.assign(a, this.rightShift(a, b));
    }

    @Override
    public Object unsignedRightShiftAssign(Object a, Object b) {
        return this.assign(a, this.unsignedRightShift(a, b));
    }

    @Override
    public Object execute(Operator op, Deque<Object> stack) {
        Object b;
        int arity = op.getArity();
        Object[] args = new Object[arity];
        for (int i = args.length - 1; i >= 0; --i) {
            args[i] = stack.pop();
        }
        Object a = args.length > 0 ? args[0] : null;
        Object object = b = args.length > 1 ? args[1] : null;
        if (op instanceof Function) {
            return this.function(a, b);
        }
        if (op == Operators.DOT) {
            return this.dot(a, b);
        }
        if (Tokens.isMatchingGroup(op, Operators.PARENS)) {
            return this.parens(args);
        }
        if (Tokens.isMatchingGroup(op, Operators.BRACKETS)) {
            return this.brackets(args);
        }
        if (Tokens.isMatchingGroup(op, Operators.BRACES)) {
            return this.braces(args);
        }
        if (op == Operators.TRANSPOSE) {
            return this.transpose(a);
        }
        if (op == Operators.DOT_TRANSPOSE) {
            return this.dotTranspose(a);
        }
        if (op == Operators.POW) {
            return this.pow(a, b);
        }
        if (op == Operators.DOT_POW) {
            return this.dotPow(a, b);
        }
        if (op == Operators.POST_INC) {
            return this.postInc(a);
        }
        if (op == Operators.POST_DEC) {
            return this.postDec(a);
        }
        if (op == Operators.PRE_INC) {
            return this.preInc(a);
        }
        if (op == Operators.PRE_DEC) {
            return this.preDec(a);
        }
        if (op == Operators.POS) {
            return this.pos(a);
        }
        if (op == Operators.NEG) {
            return this.neg(a);
        }
        if (op == Operators.COMPLEMENT) {
            return this.complement(a);
        }
        if (op == Operators.NOT) {
            return this.not(a);
        }
        if (op == Operators.MUL) {
            return this.mul(a, b);
        }
        if (op == Operators.DIV) {
            return this.div(a, b);
        }
        if (op == Operators.MOD) {
            return this.mod(a, b);
        }
        if (op == Operators.RIGHT_DIV) {
            return this.rightDiv(a, b);
        }
        if (op == Operators.DOT_MUL) {
            return this.dotMul(a, b);
        }
        if (op == Operators.DOT_DIV) {
            return this.dotDiv(a, b);
        }
        if (op == Operators.DOT_RIGHT_DIV) {
            return this.dotRightDiv(a, b);
        }
        if (op == Operators.ADD) {
            return this.add(a, b);
        }
        if (op == Operators.SUB) {
            return this.sub(a, b);
        }
        if (op == Operators.LEFT_SHIFT) {
            return this.leftShift(a, b);
        }
        if (op == Operators.RIGHT_SHIFT) {
            return this.rightShift(a, b);
        }
        if (op == Operators.UNSIGNED_RIGHT_SHIFT) {
            return this.unsignedRightShift(a, b);
        }
        if (op == Operators.LESS_THAN) {
            return this.lessThan(a, b);
        }
        if (op == Operators.GREATER_THAN) {
            return this.greaterThan(a, b);
        }
        if (op == Operators.LESS_THAN_OR_EQUAL) {
            return this.lessThanOrEqual(a, b);
        }
        if (op == Operators.GREATER_THAN_OR_EQUAL) {
            return this.greaterThanOrEqual(a, b);
        }
        if (op == Operators.INSTANCEOF) {
            return this.instanceOf(a, b);
        }
        if (op == Operators.EQUAL) {
            return this.equal(a, b);
        }
        if (op == Operators.NOT_EQUAL) {
            return this.notEqual(a, b);
        }
        if (op == Operators.BITWISE_AND) {
            return this.bitwiseAnd(a, b);
        }
        if (op == Operators.BITWISE_OR) {
            return this.bitwiseOr(a, b);
        }
        if (op == Operators.LOGICAL_AND) {
            return this.logicalAnd(a, b);
        }
        if (op == Operators.LOGICAL_OR) {
            return this.logicalOr(a, b);
        }
        if (op == Operators.QUESTION) {
            return this.question(a, b);
        }
        if (op == Operators.COLON) {
            return this.colon(a, b);
        }
        if (op == Operators.ASSIGN) {
            return this.assign(a, b);
        }
        if (op == Operators.POW_ASSIGN) {
            return this.powAssign(a, b);
        }
        if (op == Operators.DOT_POW_ASSIGN) {
            return this.dotPowAssign(a, b);
        }
        if (op == Operators.MUL_ASSIGN) {
            return this.mulAssign(a, b);
        }
        if (op == Operators.DIV_ASSIGN) {
            return this.divAssign(a, b);
        }
        if (op == Operators.MOD_ASSIGN) {
            return this.modAssign(a, b);
        }
        if (op == Operators.RIGHT_DIV_ASSIGN) {
            return this.rightDivAssign(a, b);
        }
        if (op == Operators.DOT_DIV_ASSIGN) {
            return this.dotDivAssign(a, b);
        }
        if (op == Operators.DOT_RIGHT_DIV_ASSIGN) {
            return this.dotRightDivAssign(a, b);
        }
        if (op == Operators.ADD_ASSIGN) {
            return this.addAssign(a, b);
        }
        if (op == Operators.SUB_ASSIGN) {
            return this.subAssign(a, b);
        }
        if (op == Operators.AND_ASSIGN) {
            return this.andAssign(a, b);
        }
        if (op == Operators.OR_ASSIGN) {
            return this.orAssign(a, b);
        }
        if (op == Operators.LEFT_SHIFT_ASSIGN) {
            return this.leftShiftAssign(a, b);
        }
        if (op == Operators.RIGHT_SHIFT_ASSIGN) {
            return this.rightShiftAssign(a, b);
        }
        if (op == Operators.UNSIGNED_RIGHT_SHIFT_ASSIGN) {
            return this.unsignedRightShiftAssign(a, b);
        }
        return null;
    }

    private Variable var(Object token) {
        if (Tokens.isVariable(token)) {
            return (Variable)token;
        }
        throw new IllegalArgumentException("Not a variable: " + token);
    }
}

