/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parse.eval;

import java.util.ArrayDeque;
import java.util.LinkedList;
import org.scijava.parse.ExpressionParser;
import org.scijava.parse.Function;
import org.scijava.parse.Group;
import org.scijava.parse.Operator;
import org.scijava.parse.Tokens;
import org.scijava.parse.eval.AbstractEvaluator;
import org.scijava.parse.eval.StackEvaluator;

public abstract class AbstractStackEvaluator
extends AbstractEvaluator
implements StackEvaluator {
    private static final String[] ARY = new String[]{"nullary", "unary", "binary", "ternary", "quaternary", "quinary", "senary", "septenary", "octary", "nonary"};

    public AbstractStackEvaluator() {
    }

    public AbstractStackEvaluator(ExpressionParser parser) {
        super(parser);
    }

    @Override
    public Object evaluate(LinkedList<Object> queue) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        while (!queue.isEmpty()) {
            Object token = queue.removeFirst();
            Object result = Tokens.isOperator(token) ? this.execute((Operator)token, stack) : token;
            if (result == null) {
                AbstractStackEvaluator.die(token);
            }
            stack.push(result);
        }
        if (stack.isEmpty()) {
            return null;
        }
        if (stack.size() == 1) {
            return stack.pop();
        }
        LinkedList resultList = new LinkedList();
        while (!stack.isEmpty()) {
            resultList.addFirst(stack.pop());
        }
        return resultList;
    }

    private static String ary(int arity) {
        return arity < ARY.length ? ARY[arity] : arity + "-ary";
    }

    private static String ary(Operator op) {
        return AbstractStackEvaluator.ary(op.getArity());
    }

    private static void die(Object token) {
        StringBuilder message = new StringBuilder("Unsupported");
        if (token instanceof Operator) {
            message.append(" " + AbstractStackEvaluator.ary((Operator)token));
        }
        message.append(" " + AbstractStackEvaluator.type(token) + ": " + token);
        throw new IllegalArgumentException(message.toString());
    }

    private static String type(Object token) {
        if (token instanceof Function) {
            return "function";
        }
        if (token instanceof Group) {
            return "group";
        }
        if (token instanceof Operator) {
            return "operator";
        }
        return "token";
    }
}

