/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parse;

import org.scijava.parse.Token;

public class Operator
extends Token
implements Comparable<Operator> {
    private final int arity;
    private final Associativity associativity;
    private final double precedence;

    public Operator(String symbol, int arity, Associativity associativity, double precedence) {
        super(symbol);
        this.arity = arity;
        this.associativity = associativity;
        this.precedence = precedence;
    }

    public int getArity() {
        return this.arity;
    }

    public Associativity getAssociativity() {
        return this.associativity;
    }

    public boolean isLeftAssociative() {
        Associativity a = this.getAssociativity();
        return a == Associativity.LEFT || a == Associativity.EITHER;
    }

    public boolean isRightAssociative() {
        Associativity a = this.getAssociativity();
        return a == Associativity.RIGHT || a == Associativity.EITHER;
    }

    public boolean isInfix() {
        return this.getArity() > 1;
    }

    public boolean isPrefix() {
        return this.getArity() == 1 && this.isRightAssociative();
    }

    public boolean isPostfix() {
        return this.getArity() == 1 && this.isLeftAssociative();
    }

    public double getPrecedence() {
        return this.precedence;
    }

    public Operator instance() {
        return this;
    }

    @Override
    public int compareTo(Operator that) {
        double thatP;
        double thisP = this.getPrecedence();
        if (thisP == (thatP = that.getPrecedence())) {
            return 0;
        }
        return thisP < thatP ? -1 : 1;
    }

    public static enum Associativity {
        EITHER,
        LEFT,
        RIGHT,
        NONE;

    }
}

