/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCExceptionHandler;
import org.schwering.irc.lib.IRCRuntimeConfig;
import org.schwering.irc.lib.IRCServerConfig;
import org.schwering.irc.lib.IRCTrafficLogger;
import org.schwering.irc.lib.IRCUser;
import org.schwering.irc.lib.impl.DefaultIRCConfig;
import org.schwering.irc.lib.impl.DefaultIRCRuntimeConfig;
import org.schwering.irc.lib.impl.DefaultIRCServerConfig;
import org.schwering.irc.lib.impl.SocketFactory;
import org.schwering.irc.lib.util.IRCModeParser;
import org.schwering.irc.lib.util.IRCParser;
import org.schwering.irc.lib.util.IRCUtil;
import org.schwering.irc.lib.util.LoggingReader;
import org.schwering.irc.lib.util.LoggingWriter;

public class DefaultIRCConnection
implements IRCConnection {
    private Socket socket;
    private byte level = 0;
    private BufferedReader in;
    private PrintWriter out;
    private IRCEventListener[] listeners = new IRCEventListener[0];
    private final IRCTrafficLogger trafficLogger;
    private final IRCExceptionHandler exceptionHandler;
    private final IRCServerConfig serverConfig;
    private final IRCRuntimeConfig runtimeConfig;
    private String nick;
    private Thread thread;
    private int remotePort;

    public DefaultIRCConnection(IRCServerConfig serverConfig, IRCRuntimeConfig runtimeConfig) {
        int[] ports = serverConfig.getPorts();
        if (serverConfig.getHost() == null || ports == null || ports.length == 0) {
            throw new IllegalArgumentException("Host and ports may not be null.");
        }
        this.serverConfig = serverConfig instanceof DefaultIRCConfig || serverConfig instanceof DefaultIRCServerConfig ? serverConfig : new DefaultIRCServerConfig(serverConfig);
        this.runtimeConfig = runtimeConfig instanceof DefaultIRCConfig || runtimeConfig instanceof DefaultIRCRuntimeConfig ? runtimeConfig : new DefaultIRCRuntimeConfig(runtimeConfig);
        this.nick = serverConfig.getNick();
        this.trafficLogger = runtimeConfig.getTrafficLogger();
        this.exceptionHandler = runtimeConfig.getExceptionHandler();
    }

    @Override
    public void connect() throws IOException, KeyManagementException, NoSuchAlgorithmException {
        if (this.level != 0) {
            throw new SocketException("Socket closed or already open (" + this.level + ")");
        }
        SocketFactory socketFactory = new SocketFactory(this.runtimeConfig.getTimeout(), this.runtimeConfig.getProxy(), this.runtimeConfig.getSSLSupport());
        IOException exception = null;
        String host = this.serverConfig.getHost();
        for (int i = 0; i < this.serverConfig.getPortsCount() && this.socket == null; ++i) {
            try {
                int port = this.serverConfig.getPortAt(i);
                this.socket = socketFactory.createSocket(host, port);
                this.remotePort = port;
                exception = null;
                continue;
            }
            catch (IOException exc) {
                if (this.socket != null) {
                    this.socket.close();
                }
                this.socket = null;
                exception = exc;
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.level = 1;
        String encoding = this.serverConfig.getEncoding();
        if (this.trafficLogger != null) {
            this.in = new LoggingReader((Reader)new InputStreamReader(this.socket.getInputStream(), encoding), this.trafficLogger);
            this.out = new LoggingWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), encoding), this.trafficLogger);
        } else {
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), encoding));
            this.out = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), encoding));
        }
        this.thread = this.createThread();
        this.thread.start();
        this.register();
    }

    protected Thread createThread() {
        return new Thread(this.createConsumer(), "irc://" + this.serverConfig.getUsername() + "@" + this.serverConfig.getHost() + ":" + this.remotePort);
    }

    protected Runnable createConsumer() {
        return new Consumer();
    }

    private void register() {
        String pass = this.serverConfig.getPassword();
        if (pass != null) {
            this.send("PASS " + pass);
        }
        this.send("NICK " + this.serverConfig.getNick());
        this.send("USER " + this.serverConfig.getUsername() + " " + this.socket.getLocalAddress().getHostAddress() + " " + this.serverConfig.getHost() + " :" + this.serverConfig.getRealname());
    }

    @Override
    public void send(String line) {
        try {
            IRCParser p;
            this.out.write(line + "\r\n");
            this.out.flush();
            if (this.level == 1 && "NICK".equalsIgnoreCase((p = new IRCParser(line)).getCommand())) {
                this.nick = p.getParameter(1).trim();
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
            throw new RuntimeException(exc);
        }
    }

    private synchronized void get(String line) {
        block51: {
            String command;
            IRCParser p;
            block53: {
                int i;
                block52: {
                    block50: {
                        try {
                            p = new IRCParser(line, this.runtimeConfig.isStripColorsEnabled());
                        }
                        catch (Exception exc) {
                            return;
                        }
                        command = p.getCommand();
                        if (!"PRIVMSG".equalsIgnoreCase(command)) break block50;
                        IRCUser user = p.getUser();
                        String middle = p.getMiddle();
                        String trailing = p.getTrailing();
                        for (int i2 = this.listeners.length - 1; i2 >= 0; --i2) {
                            this.listeners[i2].onPrivmsg(middle, user, trailing);
                        }
                        break block51;
                    }
                    if (!"MODE".equalsIgnoreCase(command)) break block52;
                    String chan = p.getParameter(1);
                    if (IRCUtil.isChan(chan)) {
                        IRCUser user = p.getUser();
                        String param2 = p.getParameter(2);
                        String paramsFrom3 = p.getParametersFrom(3);
                        for (int i3 = this.listeners.length - 1; i3 >= 0; --i3) {
                            this.listeners[i3].onMode(chan, user, new IRCModeParser(param2, paramsFrom3));
                        }
                    } else {
                        IRCUser user = p.getUser();
                        String paramsFrom2 = p.getParametersFrom(2);
                        for (int i4 = this.listeners.length - 1; i4 >= 0; --i4) {
                            this.listeners[i4].onMode(user, chan, paramsFrom2);
                        }
                    }
                    break block51;
                }
                if (!"PING".equalsIgnoreCase(command)) break block53;
                String ping = p.getTrailing();
                if (this.runtimeConfig.isAutoPong()) {
                    this.doPong(ping);
                } else {
                    for (i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onPing(ping);
                    }
                }
                if (this.level != 1) break block51;
                this.level = (byte)2;
                for (i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onRegistered();
                }
                break block51;
            }
            if ("JOIN".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String trailing = p.getTrailing();
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onJoin(trailing, user);
                }
            } else if ("NICK".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String changingNick = p.getNick();
                String newNick = p.getTrailing();
                if (changingNick.equalsIgnoreCase(this.nick)) {
                    this.nick = newNick;
                }
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onNick(user, newNick);
                }
            } else if ("QUIT".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String trailing = p.getTrailing();
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onQuit(user, trailing);
                }
            } else if ("PART".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String chan = p.getParameter(1);
                String msg = p.getParameterCount() > 1 ? p.getTrailing() : "";
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onPart(chan, user, msg);
                }
            } else if ("NOTICE".equalsIgnoreCase(command)) {
                IRCUser user = p.getUser();
                String middle = p.getMiddle();
                String trailing = p.getTrailing();
                for (int i = this.listeners.length - 1; i >= 0; --i) {
                    this.listeners[i].onNotice(middle, user, trailing);
                }
            } else {
                int reply = IRCUtil.parseInt(command);
                if (reply >= 1 && reply < 400) {
                    String potNick = p.getParameter(1);
                    if ((this.level == 1 || this.level == 2) && this.nick.length() > potNick.length() && this.nick.substring(0, potNick.length()).equalsIgnoreCase(potNick)) {
                        this.nick = potNick;
                        if (this.level == 2) {
                            this.level = (byte)3;
                        }
                    }
                    if (this.level == 1 && this.nick.equals(potNick)) {
                        this.level = (byte)2;
                        for (int i = this.listeners.length - 1; i >= 0; --i) {
                            this.listeners[i].onRegistered();
                        }
                    }
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onReply(reply, middle, trailing);
                    }
                } else if (reply >= 400 && reply < 600) {
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onError(reply, trailing);
                    }
                } else if ("KICK".equalsIgnoreCase(command)) {
                    IRCUser user = p.getUser();
                    String param1 = p.getParameter(1);
                    String param2 = p.getParameter(2);
                    String msg = p.getParameterCount() > 2 ? p.getTrailing() : "";
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onKick(param1, user, param2, msg);
                    }
                } else if ("INVITE".equalsIgnoreCase(command)) {
                    IRCUser user = p.getUser();
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onInvite(trailing, user, middle);
                    }
                } else if ("TOPIC".equalsIgnoreCase(command)) {
                    IRCUser user = p.getUser();
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onTopic(middle, user, trailing);
                    }
                } else if ("ERROR".equalsIgnoreCase(command)) {
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].onError(trailing);
                    }
                } else {
                    String prefix = p.getPrefix();
                    String middle = p.getMiddle();
                    String trailing = p.getTrailing();
                    for (int i = this.listeners.length - 1; i >= 0; --i) {
                        this.listeners[i].unknown(prefix, command, middle, trailing);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void close() {
        try {
            if (!this.thread.isInterrupted()) {
                this.thread.interrupt();
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        if (this.level != -1) {
            this.level = (byte)-1;
            for (int i = this.listeners.length - 1; i >= 0; --i) {
                this.listeners[i].onDisconnected();
            }
        }
        this.socket = null;
        this.in = null;
        this.out = null;
        this.listeners = new IRCEventListener[0];
    }

    private void handleException(Exception exc) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.exception(this, exc);
        }
    }

    @Override
    public synchronized void addIRCEventListener(IRCEventListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null.");
        }
        int len = this.listeners.length;
        IRCEventListener[] oldListeners = this.listeners;
        this.listeners = new IRCEventListener[len + 1];
        System.arraycopy(oldListeners, 0, this.listeners, 0, len);
        this.listeners[len] = l;
    }

    public synchronized void addIRCEventListener(IRCEventListener l, int i) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null.");
        }
        if (i < 0 || i > this.listeners.length) {
            throw new IndexOutOfBoundsException("i is not in range");
        }
        int len = this.listeners.length;
        IRCEventListener[] oldListeners = this.listeners;
        this.listeners = new IRCEventListener[len + 1];
        if (i > 0) {
            System.arraycopy(oldListeners, 0, this.listeners, 0, i);
        }
        if (i < this.listeners.length) {
            System.arraycopy(oldListeners, i, this.listeners, i + 1, len - i);
        }
        this.listeners[i] = l;
    }

    @Override
    public synchronized boolean removeIRCEventListener(IRCEventListener l) {
        if (l == null) {
            return false;
        }
        int index = -1;
        for (int i = 0; i < this.listeners.length; ++i) {
            if (!this.listeners[i].equals(l)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return false;
        }
        this.listeners[index] = null;
        int len = this.listeners.length - 1;
        IRCEventListener[] newListeners = new IRCEventListener[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            if (this.listeners[j] != null) {
                newListeners[i++] = this.listeners[j];
            }
            ++j;
        }
        this.listeners = newListeners;
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.level >= 1;
    }

    @Override
    public String getNick() {
        return this.nick;
    }

    @Override
    public int getPort() {
        return this.socket != null ? this.socket.getPort() : 0;
    }

    @Override
    public int getTimeout() {
        if (this.socket != null) {
            try {
                return this.socket.getSoTimeout();
            }
            catch (IOException exc) {
                this.handleException(exc);
                return -1;
            }
        }
        return -1;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket != null ? this.socket.getLocalAddress() : null;
    }

    public String toString() {
        return "DefaultIRCConnection [nick=" + this.nick + ", config=" + this.serverConfig + "]";
    }

    @Override
    public void doAway() {
        this.send("AWAY");
    }

    @Override
    public void doAway(String msg) {
        this.send("AWAY :" + msg);
    }

    @Override
    public void doInvite(String nick, String chan) {
        this.send("INVITE " + nick + " " + chan);
    }

    @Override
    public void doIson(String nick) {
        this.send("ISON " + nick);
    }

    @Override
    public void doJoin(String chan) {
        this.send("JOIN " + chan);
    }

    @Override
    public void doJoin(String chan, String key) {
        this.send("JOIN " + chan + " " + key);
    }

    @Override
    public void doKick(String chan, String nick) {
        this.send("KICK " + chan + " " + nick);
    }

    @Override
    public void doKick(String chan, String nick, String msg) {
        this.send("KICK " + chan + " " + nick + " :" + msg);
    }

    @Override
    public void doList() {
        this.send("LIST");
    }

    @Override
    public void doList(String chan) {
        this.send("LIST " + chan);
    }

    @Override
    public void doNames() {
        this.send("NAMES");
    }

    @Override
    public void doNames(String chan) {
        this.send("NAMES " + chan);
    }

    @Override
    public void doPrivmsg(String target, String msg) {
        this.send("PRIVMSG " + target + " :" + msg);
    }

    @Override
    public void doMode(String chan) {
        this.send("MODE " + chan);
    }

    @Override
    public void doMode(String target, String mode) {
        this.send("MODE " + target + " " + mode);
    }

    @Override
    public void doNick(String nick) {
        this.send("NICK " + nick);
    }

    @Override
    public void doNotice(String target, String msg) {
        this.send("NOTICE " + target + " :" + msg);
    }

    @Override
    public void doPart(String chan) {
        this.send("PART " + chan);
    }

    @Override
    public void doPart(String chan, String msg) {
        this.send("PART " + chan + " :" + msg);
    }

    @Override
    public void doPong(String ping) {
        this.send("PONG :" + ping);
    }

    @Override
    public void doQuit() {
        this.send("QUIT");
    }

    @Override
    public void doQuit(String msg) {
        this.send("QUIT :" + msg);
    }

    @Override
    public void doTopic(String chan) {
        this.send("TOPIC " + chan);
    }

    @Override
    public void doTopic(String chan, String topic) {
        this.send("TOPIC " + chan + " :" + topic);
    }

    @Override
    public void doWho(String criteric) {
        this.send("WHO " + criteric);
    }

    @Override
    public void doWhois(String nick) {
        this.send("WHOIS " + nick);
    }

    @Override
    public void doWhowas(String nick) {
        this.send("WHOWAS " + nick);
    }

    @Override
    public void doUserhost(String nick) {
        this.send("USERHOST " + nick);
    }

    @Override
    public boolean isSSL() {
        return this.runtimeConfig.getSSLSupport() != null;
    }

    protected class Consumer
    implements Runnable {
        protected Consumer() {
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = DefaultIRCConnection.this.in.readLine()) != null) {
                    DefaultIRCConnection.this.get(line);
                }
            }
            catch (IOException exc) {
                DefaultIRCConnection.this.handleException(exc);
                DefaultIRCConnection.this.close();
            }
            finally {
                DefaultIRCConnection.this.close();
            }
        }
    }
}

