/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.schwering.irc.lib.IRCConfig;
import org.schwering.irc.lib.IRCExceptionHandler;
import org.schwering.irc.lib.IRCRuntimeConfig;
import org.schwering.irc.lib.IRCSSLSupport;
import org.schwering.irc.lib.IRCServerConfig;
import org.schwering.irc.lib.IRCTrafficLogger;
import org.schwering.irc.lib.impl.DefaultIRCConfig;
import org.schwering.irc.lib.util.IRCUtil;

public final class IRCConfigBuilder {
    public static final boolean DEFAULT_AUTOPONG = true;
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final boolean DEFAULT_STRIP_COLORS = false;
    public static final int DEFAULT_TIMEOUT = 900000;
    private boolean autoPong = true;
    private String encoding = "utf-8";
    private IRCExceptionHandler exceptionHandler;
    private String host;
    private String nick;
    private String password;
    private final List<Integer> ports = new ArrayList<Integer>();
    private Proxy proxy;
    private String realname;
    private IRCSSLSupport sslSupport;
    private boolean stripColors = false;
    private int timeout = 900000;
    private IRCTrafficLogger trafficLogger;
    private String username;

    public static IRCConfigBuilder newBuilder() {
        return new IRCConfigBuilder();
    }

    private IRCConfigBuilder() {
    }

    public IRCConfigBuilder autoPong(boolean autoPong) {
        this.autoPong = autoPong;
        return this;
    }

    public IRCConfig build() {
        return new DefaultIRCConfig(this.host, IRCUtil.toArray(this.ports), this.password, this.nick, this.username, this.realname, this.encoding, this.timeout, this.autoPong, this.stripColors, this.sslSupport, this.proxy, this.trafficLogger, this.exceptionHandler);
    }

    public IRCConfigBuilder config(IRCConfig config) {
        this.serverConfig(config);
        this.runtimeConfig(config);
        return this;
    }

    public IRCConfigBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public IRCConfigBuilder exceptionHandler(IRCExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public IRCConfigBuilder host(String host) {
        this.host = host;
        return this;
    }

    public IRCConfigBuilder nick(String nick) {
        this.nick = nick;
        return this;
    }

    public IRCConfigBuilder password(String password) {
        this.password = password;
        return this;
    }

    public IRCConfigBuilder port(int port) {
        this.ports.add(port);
        return this;
    }

    public IRCConfigBuilder portRange(int portMin, int portMax) {
        if (portMin > portMax) {
            int tmp = portMin;
            portMin = portMax;
            portMax = tmp;
        }
        for (int port = portMin; port <= portMax; ++port) {
            this.ports.add(port);
        }
        return this;
    }

    public IRCConfigBuilder ports(int ... port) {
        for (int p : port) {
            this.ports.add(p);
        }
        return this;
    }

    public IRCConfigBuilder realname(String realname) {
        this.realname = realname;
        return this;
    }

    public IRCConfigBuilder runtimeConfig(IRCRuntimeConfig runtimeConfig) {
        this.timeout = runtimeConfig.getTimeout();
        this.autoPong = runtimeConfig.isAutoPong();
        this.stripColors = runtimeConfig.isStripColorsEnabled();
        this.sslSupport = runtimeConfig.getSSLSupport();
        this.proxy = runtimeConfig.getProxy();
        this.trafficLogger = runtimeConfig.getTrafficLogger();
        this.exceptionHandler = runtimeConfig.getExceptionHandler();
        return this;
    }

    public IRCConfigBuilder serverConfig(IRCServerConfig serverConfig) {
        this.host = serverConfig.getHost();
        this.ports(serverConfig.getPorts());
        this.password = serverConfig.getPassword();
        this.nick = serverConfig.getNick();
        this.username = serverConfig.getUsername();
        this.realname = serverConfig.getRealname();
        this.encoding = serverConfig.getEncoding();
        return this;
    }

    public IRCConfigBuilder socksProxy(String socksProxyHost, int socksProxyPort) {
        if (socksProxyHost == null) {
            throw new IllegalArgumentException("socksProxyHost must be non-null, non-empty");
        }
        this.proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(socksProxyHost, socksProxyPort));
        return this;
    }

    public IRCConfigBuilder sslSupport(IRCSSLSupport sslSupport) {
        this.sslSupport = sslSupport;
        return this;
    }

    public IRCConfigBuilder stripColors(boolean stripColors) {
        this.stripColors = stripColors;
        return this;
    }

    public IRCConfigBuilder timeout(int millis) {
        this.timeout = millis;
        return this;
    }

    public IRCConfigBuilder trafficLogger(IRCTrafficLogger trafficLogger) {
        this.trafficLogger = trafficLogger;
        return this;
    }

    public IRCConfigBuilder username(String username) {
        this.username = username;
        return this;
    }
}

