/*
 * Decompiled with CFR 0.152.
 */
package org.scf4j.props;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.scf4j.Configuration;
import org.scf4j.ConfigurationException;
import org.scf4j.Configurator;
import org.scf4j.Property;
import org.scf4j.props.Messages;
import org.scf4j.util.PrimitivesTypeCoercer;
import org.scf4j.util.TypeCoercer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyConfigurator
implements Configurator {
    private static final String EXTENSION = ".properties";
    private final Logger logger = LoggerFactory.getLogger(PropertyConfigurator.class);
    private TypeCoercer coercer;
    private File configurationRoot;

    public boolean isAvailable(Class<?> clazz) {
        File file = this.getFile(this.defendClazz(clazz));
        this.logger.debug(Messages.getString("configuration.file.for.clazz.pcls.is.pfile", new Object[0]), (Object)clazz.getCanonicalName(), (Object)file.getAbsolutePath());
        return file.exists();
    }

    private Configuration defendClazz(Class<?> clazz) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException(Messages.getString("configuration.must.be.an.interface", new Object[0]));
        }
        Configuration configuration = clazz.getAnnotation(Configuration.class);
        if (configuration == null) {
            throw new IllegalArgumentException(Messages.getString("not.a.configuration.0", clazz.getCanonicalName()));
        }
        return configuration;
    }

    private File getFile(Configuration configuration) {
        return new File(this.configurationRoot, configuration.value() + EXTENSION);
    }

    public <T> T getConfiguration(Class<T> clazz) throws ConfigurationException {
        File file = this.getFile(this.defendClazz(clazz));
        this.logger.debug(Messages.getString("configuration.file.for.clazz.pcls.is.pfile", new Object[0]), (Object)clazz.getCanonicalName(), (Object)file.getAbsolutePath());
        Properties properties = this.loadProperties(file);
        return this.getConfiguration(clazz, properties, "");
    }

    private Properties loadProperties(File file) throws ConfigurationException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            this.logger.error(Messages.getString("could.not.load.the.configuration", new Object[0]), (Throwable)e);
            throw new ConfigurationException(Messages.getString("could.not.load.the.configuration", new Object[0]), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private <T> T getConfiguration(Class<T> clazz, Properties properties, String path) throws ConfigurationException {
        final Map<Method, Object> propertyMapping = this.mapProperties(clazz, properties, path);
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method method, Object[] objects) throws Throwable {
                return propertyMapping.get(method);
            }
        }));
    }

    private Map<Method, Object> mapProperties(Class<?> clazz, Properties properties, String path) throws ConfigurationException {
        HashMap<Method, Object> propertyMapping = new HashMap<Method, Object>();
        for (Method method : clazz.getDeclaredMethods()) {
            this.mapProperty(propertyMapping, properties, path, method);
        }
        return propertyMapping;
    }

    private void mapProperty(Map<Method, Object> propertyMapping, Properties properties, String path, Method method) throws ConfigurationException {
        Property property = this.defendMethod(method);
        String separator = path.equals("") ? "" : ".";
        String propertyPath = path + separator + property.id();
        String value = properties.getProperty(propertyPath);
        this.logger.debug(Messages.getString("try.to.map.and.coerce.property.pstr", new Object[0]), (Object)propertyPath);
        Object nested = this.checkNested(properties, method.getReturnType(), propertyPath);
        if (nested != null) {
            propertyMapping.put(method, nested);
        } else if (value != null) {
            propertyMapping.put(method, this.getCoercer().coerce(value, method.getReturnType()));
        } else if (property.optional()) {
            propertyMapping.put(method, this.getCoercer().coerce(property.value(), method.getReturnType()));
        } else {
            throw new ConfigurationException(Messages.getString("required.property.0.is.missing", propertyPath));
        }
    }

    private Property defendMethod(Method method) {
        if (method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalArgumentException(Messages.getString("found.void.return.type.in.property.method.0", method.getName()));
        }
        Property property = method.getAnnotation(Property.class);
        if (property == null) {
            throw new IllegalArgumentException(Messages.getString("method.0.is.not.annotated.with.property", method.getName()));
        }
        return property;
    }

    private Object checkNested(Properties properties, Class<?> returnType, String propertyPath) throws ConfigurationException {
        Configuration configuration;
        if (returnType.isInterface() && (configuration = returnType.getAnnotation(Configuration.class)) != null) {
            this.logger.debug(Messages.getString("found.nested.configuration.pcls.path.pstr", new Object[0]), (Object)returnType.getCanonicalName(), (Object)propertyPath);
            return this.getConfiguration(returnType, properties, propertyPath);
        }
        return null;
    }

    private TypeCoercer getCoercer() {
        if (this.coercer == null) {
            this.coercer = new PrimitivesTypeCoercer();
        }
        return this.coercer;
    }

    @PostConstruct
    public void checkConstruction() {
        if (this.configurationRoot == null) {
            throw new IllegalStateException(Messages.getString("propertyconfigurator.is.missing.the.property.configurationroot", new Object[0]));
        }
        if (!this.configurationRoot.isDirectory()) {
            throw new IllegalStateException(Messages.getString("propertyconfigurator.s.root.directory.is.not.a.directory.0", this.configurationRoot.getAbsolutePath()));
        }
    }

    public void setTypeCoercer(TypeCoercer coercer) {
        this.coercer = coercer;
    }

    public void setConfigurationRoot(File configurationRoot) {
        this.configurationRoot = configurationRoot;
    }
}

