/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.matchers;

import java.util.List;
import org.hamcrest.TypeSafeMatcher;
import org.scassandra.cql.CqlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ScassandraMatcher<T extends List<S>, S>
extends TypeSafeMatcher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScassandraMatcher.class);

    ScassandraMatcher() {
    }

    protected boolean matchesSafely(T queries) {
        for (int i = 0; i < queries.size(); ++i) {
            Object actual = queries.get(i);
            try {
                if (!this.match(actual)) continue;
                return true;
            }
            catch (IllegalArgumentException e) {
                if (i == queries.size() - 1) {
                    throw e;
                }
                LOGGER.info("Found prepared statement execution that didn't match: {}, reason: {}", actual, (Object)e.getMessage());
            }
        }
        return false;
    }

    protected abstract boolean match(S var1);

    protected boolean checkVariables(List<Object> expectedVariables, List<CqlType> variableTypes, List<Object> actualVariables) {
        if (variableTypes.size() != actualVariables.size()) {
            throw new IllegalArgumentException(String.format("Server has returned a different number of variables to variable types: variables %s variableTypes %s", actualVariables, variableTypes));
        }
        if (expectedVariables.size() != actualVariables.size()) {
            return false;
        }
        for (int index = 0; index < expectedVariables.size(); ++index) {
            Object expectedVariable = expectedVariables.get(index);
            Object actualVariable = actualVariables.get(index);
            CqlType columnType = variableTypes.get(index);
            if (columnType.equals(expectedVariable, actualVariable)) continue;
            return false;
        }
        return true;
    }
}

