/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.matchers;

import java.util.List;
import org.hamcrest.Description;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.Query;
import org.scassandra.matchers.ScassandraMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryMatcher
extends ScassandraMatcher<List<Query>, Query> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryMatcher.class);
    private Query expectedQuery;

    public QueryMatcher(Query expectedQuery) {
        if (expectedQuery == null) {
            throw new IllegalArgumentException("null query");
        }
        this.expectedQuery = expectedQuery;
    }

    @Override
    protected boolean match(Query actualQuery) {
        if (!actualQuery.getConsistency().equals(this.expectedQuery.getConsistency())) {
            return false;
        }
        if (!actualQuery.getQuery().equals(this.expectedQuery.getQuery())) {
            return false;
        }
        List<Object> expectedVariables = this.expectedQuery.getVariables();
        List<CqlType> variableTypes = actualQuery.getVariableTypes();
        List<Object> actualVariables = actualQuery.getVariables();
        return this.checkVariables(expectedVariables, variableTypes, actualVariables);
    }

    public void describeMismatchSafely(List<Query> actual, Description description) {
        description.appendText("the following queries were executed: ");
        for (Query query : actual) {
            description.appendText("\n" + query);
        }
    }

    public void describeTo(Description description) {
        description.appendText("Expected query " + this.expectedQuery + " to be executed");
    }
}

