/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.matchers;

import java.util.List;
import org.hamcrest.Description;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.PreparedStatementExecution;
import org.scassandra.matchers.ScassandraMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementMatcher
extends ScassandraMatcher<List<PreparedStatementExecution>, PreparedStatementExecution> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreparedStatementMatcher.class);
    private PreparedStatementExecution expectedPreparedStatementExecution;

    public PreparedStatementMatcher(PreparedStatementExecution expectedPreparedStatementExecution) {
        if (expectedPreparedStatementExecution == null) {
            throw new IllegalArgumentException("null expectedPreparedStatementExecution");
        }
        this.expectedPreparedStatementExecution = expectedPreparedStatementExecution;
    }

    public void describeMismatchSafely(List<PreparedStatementExecution> preparedStatementExecutions, Description description) {
        description.appendText("the following prepared statements were executed: ");
        for (PreparedStatementExecution preparedStatement : preparedStatementExecutions) {
            description.appendText("\n" + preparedStatement);
        }
    }

    public void describeTo(Description description) {
        description.appendText("Expected prepared statement " + this.expectedPreparedStatementExecution + " to be executed");
    }

    @Override
    protected boolean match(PreparedStatementExecution actualPreparedStatementExecution) {
        List<CqlType> variableTypes = actualPreparedStatementExecution.getVariableTypes();
        List<Object> actualVariables = actualPreparedStatementExecution.getVariables();
        if (!actualPreparedStatementExecution.getConsistency().equals(this.expectedPreparedStatementExecution.getConsistency())) {
            return false;
        }
        if (!actualPreparedStatementExecution.getPreparedStatementText().equals(this.expectedPreparedStatementExecution.getPreparedStatementText())) {
            return false;
        }
        List<Object> expectedVariables = this.expectedPreparedStatementExecution.getVariables();
        return this.checkVariables(expectedVariables, variableTypes, actualVariables);
    }
}

