/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.Consistency;
import org.scassandra.server.priming.ErrorConstants;

public class ReadTimeoutConfig
extends Config {
    private final int receivedAcknowledgements;
    private final int requiredAcknowledgements;
    private final boolean dataRetrieved;
    private final Consistency consistencyLevel;

    public ReadTimeoutConfig(int receivedAcknowledgements, int requiredAcknowledgements, boolean dataRetrieved) {
        this(receivedAcknowledgements, requiredAcknowledgements, dataRetrieved, null);
    }

    public ReadTimeoutConfig(int receivedAcknowledgements, int requiredAcknowledgements, boolean dataRetrieved, Consistency consistencyLevel) {
        this.receivedAcknowledgements = receivedAcknowledgements;
        this.requiredAcknowledgements = requiredAcknowledgements;
        this.dataRetrieved = dataRetrieved;
        this.consistencyLevel = consistencyLevel;
    }

    @Override
    Map<String, ?> getProperties() {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)ErrorConstants.ReceivedResponse(), (Object)String.valueOf(this.receivedAcknowledgements)).put((Object)ErrorConstants.RequiredResponse(), (Object)String.valueOf(this.requiredAcknowledgements)).put((Object)ErrorConstants.DataPresent(), (Object)String.valueOf(this.dataRetrieved));
        if (this.consistencyLevel != null) {
            builder.put((Object)ErrorConstants.ConsistencyLevel(), (Object)String.valueOf(this.consistencyLevel.toString()));
        }
        return builder.build();
    }
}

