/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.cql;

import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.scassandra.antlr4.CqlTypesBaseListener;
import org.scassandra.antlr4.CqlTypesLexer;
import org.scassandra.antlr4.CqlTypesParser;
import org.scassandra.cql.CqlType;
import org.scassandra.cql.ListType;
import org.scassandra.cql.MapType;
import org.scassandra.cql.PrimitiveType;
import org.scassandra.cql.SetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlTypeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CqlTypeFactory.class);

    public CqlType buildType(String typeString) {
        CqlTypesLexer lexer = new CqlTypesLexer((CharStream)new ANTLRInputStream(typeString));
        CqlTypesParser parser = new CqlTypesParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalArgumentException(msg);
            }
        });
        CqlTypesBaseListenerImpl listener = new CqlTypesBaseListenerImpl();
        parser.addParseListener(listener);
        parser.data_type();
        return listener.getCqlType();
    }

    private static class CqlTypesBaseListenerImpl
    extends CqlTypesBaseListener {
        private CqlType cqlType;
        private Stack<CqlType> inProgress = new Stack();

        private CqlTypesBaseListenerImpl() {
        }

        @Override
        public void enterData_type(@NotNull CqlTypesParser.Data_typeContext ctx) {
            LOGGER.debug("Type begins: " + ctx.start.getText());
        }

        @Override
        public void exitData_type(@NotNull CqlTypesParser.Data_typeContext ctx) {
            LOGGER.debug("Type ends: " + ctx.start.getText());
        }

        @Override
        public void exitNative_type(@NotNull CqlTypesParser.Native_typeContext ctx) {
            String text = ctx.start.getText();
            PrimitiveType primitiveType = PrimitiveType.fromName(text);
            if (this.inProgress.isEmpty()) {
                this.cqlType = primitiveType;
            } else {
                this.inProgress.push(primitiveType);
            }
        }

        @Override
        public void enterMap_type(@NotNull CqlTypesParser.Map_typeContext ctx) {
            LOGGER.debug("end map:" + ctx.start.getText());
            this.inProgress.push(new MapType(null, null));
        }

        @Override
        public void exitMap_type(@NotNull CqlTypesParser.Map_typeContext ctx) {
            LOGGER.debug("start map:" + ctx.start.getText());
            CqlType value = this.inProgress.pop();
            CqlType key = this.inProgress.pop();
            this.inProgress.pop();
            this.cqlType = new MapType(key, value);
        }

        @Override
        public void enterSet_type(@NotNull CqlTypesParser.Set_typeContext ctx) {
            this.inProgress.push(new SetType(null));
        }

        @Override
        public void exitSet_type(@NotNull CqlTypesParser.Set_typeContext ctx) {
            CqlType value = this.inProgress.pop();
            this.inProgress.pop();
            this.cqlType = new SetType(value);
        }

        @Override
        public void enterList_type(@NotNull CqlTypesParser.List_typeContext ctx) {
            this.inProgress.push(new ListType(null));
        }

        @Override
        public void exitList_type(@NotNull CqlTypesParser.List_typeContext ctx) {
            CqlType value = this.inProgress.pop();
            this.inProgress.pop();
            this.cqlType = new ListType(value);
        }

        public CqlType getCqlType() {
            return this.cqlType;
        }
    }
}

