/*
 * Decompiled with CFR 0.152.
 */
package org.scalatestplus.junit5;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.scalatest.Reporter;
import org.scalatest.StatefulStatus;
import org.scalatest.Tracker;
import org.scalatest.events.Event;
import org.scalatest.events.IndentedText;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.events.TopOfMethod;
import org.scalatest.events.TopOfMethod$;
import org.scalatest.exceptions.PayloadField;
import org.scalatestplus.junit5.JUnitHelper$;
import org.scalatestplus.junit5.Resources$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.package$;

public class JUnitExecutionListener
implements TestExecutionListener {
    private final Reporter report;
    private final Tracker theTracker;
    private final StatefulStatus status;
    private final Set failedTests;
    private final Pattern TEST_DESCRIPTION_PATTERN;

    public JUnitExecutionListener(Reporter report, Map<String, Object> config, Tracker theTracker, StatefulStatus status) {
        this.report = report;
        this.theTracker = theTracker;
        this.status = status;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("\\[(.*)\\]/\\[class:(.*)\\]/\\[method:(.*)\\(\\)\\]");
    }

    public Set<String> failedTests() {
        return this.failedTests;
    }

    public Some<TopOfMethod> getTopOfMethod(String className, String methodName) {
        return Some$.MODULE$.apply((Object)TopOfMethod$.MODULE$.apply(className, new StringBuilder(15).append("public void ").append(className).append(".").append(methodName).append("()").toString()));
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            Tuple3<String, String, String> tuple3 = this.parseTestDescription(testIdentifier.getUniqueId());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String testName = (String)tuple3._1();
            String testClass = (String)tuple3._2();
            String testClassName = (String)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testName, (Object)testClass, (Object)testClassName);
            String testName2 = (String)tuple32._1();
            String testClass2 = (String)tuple32._2();
            String testClassName2 = (String)tuple32._3();
            TestExecutionResult.Status status = testExecutionResult.getStatus();
            TestExecutionResult.Status status2 = TestExecutionResult.Status.SUCCESSFUL;
            if (!(status != null ? !status.equals(status2) : status2 != null)) {
                IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testName2, 1, true);
                this.report.apply((Event)TestSucceeded$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option)Some$.MODULE$.apply((Object)testClass2), testName2, testName2, (IndexedSeq)package$.MODULE$.Vector().empty(), (Option)None$.MODULE$, (Option)Some$.MODULE$.apply((Object)formatter), this.getTopOfMethod(testClass2, testName2), TestSucceeded$.MODULE$.$lessinit$greater$default$11(), TestSucceeded$.MODULE$.$lessinit$greater$default$12(), TestSucceeded$.MODULE$.$lessinit$greater$default$13(), TestSucceeded$.MODULE$.$lessinit$greater$default$14()));
                return;
            }
            this.failedTests().add(testIdentifier.getDisplayName());
            Option throwable = Option$.MODULE$.apply(testExecutionResult.getThrowable().orElseGet(null));
            String message = (String)throwable.map((Function1 & Serializable)_$1 -> _$1.toString()).getOrElse(JUnitExecutionListener::$anonfun$2);
            IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testName2, 1, true);
            Option payload = throwable.flatMap((Function1 & Serializable)x$1 -> {
                Throwable throwable = x$1;
                if (throwable instanceof PayloadField) {
                    Throwable optPayload = (Throwable)((PayloadField)throwable);
                    return ((PayloadField)optPayload).payload();
                }
                return None$.MODULE$;
            });
            this.report.apply((Event)TestFailed$.MODULE$.apply(this.theTracker.nextOrdinal(), message, testClassName2, testClass2, (Option)Some$.MODULE$.apply((Object)testClass2), testName2, testName2, (IndexedSeq)package$.MODULE$.Vector().empty(), (IndexedSeq)package$.MODULE$.Vector().empty(), throwable, (Option)None$.MODULE$, (Option)Some$.MODULE$.apply((Object)formatter), (Option)Some$.MODULE$.apply((Object)SeeStackDepthException$.MODULE$), (Option)None$.MODULE$, payload, TestFailed$.MODULE$.$lessinit$greater$default$16(), TestFailed$.MODULE$.$lessinit$greater$default$17()));
            this.status.setFailed();
            return;
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (testIdentifier.isTest()) {
            Tuple3<String, String, String> tuple3 = this.parseTestDescription(testIdentifier.getUniqueId());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String testName = (String)tuple3._1();
            String testClass = (String)tuple3._2();
            String testClassName = (String)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testName, (Object)testClass, (Object)testClassName);
            String testName2 = (String)tuple32._1();
            String testClass2 = (String)tuple32._2();
            String testClassName2 = (String)tuple32._3();
            IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testName2, 1, true);
            this.report.apply((Event)TestIgnored$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option)Some$.MODULE$.apply((Object)testClass2), testName2, testName2, (Option)Some$.MODULE$.apply((Object)formatter), this.getTopOfMethod(testClass2, testName2), TestIgnored$.MODULE$.$lessinit$greater$default$9(), TestIgnored$.MODULE$.$lessinit$greater$default$10(), TestIgnored$.MODULE$.$lessinit$greater$default$11()));
            return;
        }
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            Tuple3<String, String, String> tuple3 = this.parseTestDescription(testIdentifier.getUniqueId());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String testName = (String)tuple3._1();
            String testClass = (String)tuple3._2();
            String testClassName = (String)tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testName, (Object)testClass, (Object)testClassName);
            String testName2 = (String)tuple32._1();
            String testClass2 = (String)tuple32._2();
            String testClassName2 = (String)tuple32._3();
            this.report.apply((Event)TestStarting$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option)Some$.MODULE$.apply((Object)testClass2), testName2, testName2, (Option)Some$.MODULE$.apply((Object)MotionToSuppress$.MODULE$), this.getTopOfMethod(testClass2, testName2), TestStarting$.MODULE$.$lessinit$greater$default$9(), TestStarting$.MODULE$.$lessinit$greater$default$10(), TestStarting$.MODULE$.$lessinit$greater$default$11(), TestStarting$.MODULE$.$lessinit$greater$default$12()));
            return;
        }
    }

    private Tuple3<String, String, String> parseTestDescription(String displayName) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN.matcher(displayName);
        if (!matcher.find()) {
            throw new RuntimeException(new StringBuilder(25).append("unexpected displayName [").append(displayName).append("]").toString());
        }
        String testName = matcher.group(3);
        String testClass = matcher.group(2);
        String testClassName = testClass.replaceAll(".*\\.", "");
        return Tuple3$.MODULE$.apply((Object)testName, (Object)testClass, (Object)testClassName);
    }

    private static final String $anonfun$2() {
        return Resources$.MODULE$.jUnitTestFailed();
    }
}

